/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.actions.events;

import com.itextpdf.commons.actions.AbstractITextConfigurationEvent;
import com.itextpdf.commons.actions.AbstractProductProcessITextEvent;
import com.itextpdf.commons.actions.sequence.AbstractIdentifiableElement;
import com.itextpdf.commons.actions.sequence.SequenceId;
import com.itextpdf.commons.actions.sequence.SequenceIdManager;
import com.itextpdf.kernel.pdf.PdfDocument;
import java.lang.ref.WeakReference;
import java.util.List;

public final class LinkDocumentIdEvent
extends AbstractITextConfigurationEvent {
    private final WeakReference<PdfDocument> document;
    private final WeakReference<SequenceId> sequenceId;

    public LinkDocumentIdEvent(PdfDocument document, SequenceId sequenceId) {
        this.document = new WeakReference<PdfDocument>(document);
        this.sequenceId = new WeakReference<SequenceId>(sequenceId);
    }

    public LinkDocumentIdEvent(PdfDocument document, AbstractIdentifiableElement identifiableElement) {
        this(document, identifiableElement == null ? null : SequenceIdManager.getSequenceId(identifiableElement));
    }

    @Override
    public void doAction() {
        SequenceId storedSequenceId = (SequenceId)this.sequenceId.get();
        PdfDocument storedPdfDocument = (PdfDocument)this.document.get();
        if (storedSequenceId == null || storedPdfDocument == null) {
            return;
        }
        List<AbstractProductProcessITextEvent> anonymousEvents = this.getEvents(storedSequenceId);
        if (anonymousEvents != null) {
            SequenceId documentId = storedPdfDocument.getDocumentIdWrapper();
            for (AbstractProductProcessITextEvent event : anonymousEvents) {
                List<AbstractProductProcessITextEvent> storedEvents = this.getEvents(documentId);
                if (storedEvents.contains(event)) continue;
                this.addEvent(documentId, event);
            }
        }
    }
}

