/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.FontNames;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.kernel.font.Type3Glyph;
import java.util.HashMap;
import java.util.Map;

public class Type3Font
extends FontProgram {
    private final Map<Integer, Type3Glyph> type3Glyphs = new HashMap<Integer, Type3Glyph>();
    private final Map<Integer, Type3Glyph> type3GlyphsWithoutUnicode = new HashMap<Integer, Type3Glyph>();
    private boolean colorized = false;
    private int flags = 0;

    Type3Font(boolean colorized) {
        this.colorized = colorized;
        this.fontNames = new FontNames();
        this.getFontMetrics().setBbox(0, 0, 0, 0);
    }

    public Type3Glyph getType3Glyph(int unicode) {
        return this.type3Glyphs.get(unicode);
    }

    public Type3Glyph getType3GlyphByCode(int code) {
        Type3Glyph glyph = this.type3GlyphsWithoutUnicode.get(code);
        if (glyph == null && this.codeToGlyph.get(code) != null) {
            glyph = this.type3Glyphs.get(((Glyph)this.codeToGlyph.get(code)).getUnicode());
        }
        return glyph;
    }

    @Override
    public int getPdfFontFlags() {
        return this.flags;
    }

    @Override
    public boolean isFontSpecific() {
        return false;
    }

    public boolean isColorized() {
        return this.colorized;
    }

    @Override
    public int getKerning(Glyph glyph1, Glyph glyph2) {
        return 0;
    }

    public int getNumberOfGlyphs() {
        return this.type3Glyphs.size() + this.type3GlyphsWithoutUnicode.size();
    }

    @Override
    protected void setFontName(String fontName) {
        super.setFontName(fontName);
    }

    @Override
    protected void setFontFamily(String fontFamily) {
        super.setFontFamily(fontFamily);
    }

    @Override
    protected void setFontWeight(int fontWeight) {
        super.setFontWeight(fontWeight);
    }

    @Override
    protected void setFontStretch(String fontWidth) {
        super.setFontStretch(fontWidth);
    }

    @Override
    protected void setCapHeight(int capHeight) {
        super.setCapHeight(capHeight);
    }

    @Override
    protected void setItalicAngle(int italicAngle) {
        super.setItalicAngle(italicAngle);
    }

    @Override
    protected void setTypoAscender(int ascender) {
        super.setTypoAscender(ascender);
    }

    @Override
    protected void setTypoDescender(int descender) {
        super.setTypoDescender(descender);
    }

    void setPdfFontFlags(int flags) {
        this.flags = flags;
    }

    void addGlyph(int code, int unicode, int width, int[] bbox, Type3Glyph type3Glyph) {
        if (this.codeToGlyph.containsKey(code)) {
            this.removeGlyphFromMappings(code);
        }
        Glyph glyph = new Glyph(code, width, unicode, bbox);
        this.codeToGlyph.put(code, glyph);
        if (unicode < 0) {
            this.type3GlyphsWithoutUnicode.put(code, type3Glyph);
        } else {
            this.unicodeToGlyph.put(unicode, glyph);
            this.type3Glyphs.put(unicode, type3Glyph);
        }
        this.recalculateAverageWidth();
    }

    private void removeGlyphFromMappings(int glyphCode) {
        Glyph removed = (Glyph)this.codeToGlyph.remove(glyphCode);
        if (removed == null) {
            return;
        }
        int unicode = removed.getUnicode();
        if (unicode < 0) {
            this.type3GlyphsWithoutUnicode.remove(glyphCode);
        } else {
            this.unicodeToGlyph.remove(unicode);
            this.type3Glyphs.remove(unicode);
        }
    }

    private void recalculateAverageWidth() {
        int widthSum = 0;
        int glyphsNumber = this.codeToGlyph.size();
        for (Glyph glyph : this.codeToGlyph.values()) {
            if (glyph.getWidth() == 0) {
                --glyphsNumber;
                continue;
            }
            widthSum += glyph.getWidth();
        }
        this.avgWidth = glyphsNumber == 0 ? 0 : widthSum / glyphsNumber;
    }
}

