/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.confirmations.ConfirmEvent;
import com.itextpdf.commons.actions.confirmations.EventConfirmationType;
import com.itextpdf.commons.actions.data.ProductData;
import com.itextpdf.commons.actions.sequence.SequenceId;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.kernel.actions.data.ITextCoreProductData;
import com.itextpdf.kernel.actions.events.FlushPdfDocumentEvent;
import com.itextpdf.kernel.actions.events.ITextCoreProductEvent;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.events.Event;
import com.itextpdf.kernel.events.EventDispatcher;
import com.itextpdf.kernel.events.IEventDispatcher;
import com.itextpdf.kernel.events.IEventHandler;
import com.itextpdf.kernel.events.PdfDocumentEvent;
import com.itextpdf.kernel.exceptions.BadPasswordException;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.numbering.EnglishAlphabetNumbering;
import com.itextpdf.kernel.numbering.RomanNumbering;
import com.itextpdf.kernel.pdf.CountOutputStream;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.EncryptedEmbeddedStreamsHandler;
import com.itextpdf.kernel.pdf.FingerPrint;
import com.itextpdf.kernel.pdf.IPdfPageExtraCopier;
import com.itextpdf.kernel.pdf.IPdfPageFactory;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.MemoryLimitsAwareHandler;
import com.itextpdf.kernel.pdf.OcgPropertiesCopier;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocumentInfo;
import com.itextpdf.kernel.pdf.PdfEncryptedPayload;
import com.itextpdf.kernel.pdf.PdfEncryptedPayloadDocument;
import com.itextpdf.kernel.pdf.PdfEncryption;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNameTree;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutline;
import com.itextpdf.kernel.pdf.PdfOutputIntent;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfPageFactory;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.PdfXrefTable;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.kernel.pdf.VersionConforming;
import com.itextpdf.kernel.pdf.WriterProperties;
import com.itextpdf.kernel.pdf.XmpMetaInfoConverter;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.collection.PdfCollection;
import com.itextpdf.kernel.pdf.filespec.PdfEncryptedPayloadFileSpecFactory;
import com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import com.itextpdf.kernel.pdf.navigation.PdfDestination;
import com.itextpdf.kernel.pdf.statistics.NumberOfPagesStatisticsEvent;
import com.itextpdf.kernel.pdf.statistics.SizeOfPdfStatisticsEvent;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.kernel.xmp.options.PropertyOptions;
import com.itextpdf.kernel.xmp.options.SerializeOptions;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfDocument
implements IEventDispatcher,
Closeable {
    private static IPdfPageFactory pdfPageFactory = new PdfPageFactory();
    private PageSize defaultPageSize = PageSize.DEFAULT;
    protected EventDispatcher eventDispatcher = new EventDispatcher();
    protected PdfWriter writer = null;
    protected PdfReader reader = null;
    protected byte[] xmpMetadata = null;
    protected PdfCatalog catalog = null;
    protected PdfDictionary trailer = null;
    protected PdfDocumentInfo info = null;
    protected PdfVersion pdfVersion = PdfVersion.PDF_1_7;
    private PdfString originalDocumentId;
    private PdfString modifiedDocumentId;
    final PdfXrefTable xref = new PdfXrefTable();
    protected FingerPrint fingerPrint;
    protected final StampingProperties properties;
    protected PdfStructTreeRoot structTreeRoot;
    protected int structParentIndex = -1;
    protected boolean closeReader = true;
    protected boolean closeWriter = true;
    protected boolean isClosing = false;
    protected boolean closed = false;
    protected boolean flushUnusedObjects = false;
    private Map<PdfIndirectReference, PdfFont> documentFonts = new HashMap<PdfIndirectReference, PdfFont>();
    private PdfFont defaultFont = null;
    protected TagStructureContext tagStructureContext;
    private SequenceId documentId;
    private LinkedHashMap<PdfPage, List<PdfLinkAnnotation>> linkAnnotations = new LinkedHashMap();
    Map<PdfIndirectReference, byte[]> serializedObjectsCache = new HashMap<PdfIndirectReference, byte[]>();
    MemoryLimitsAwareHandler memoryLimitsAwareHandler = null;
    private EncryptedEmbeddedStreamsHandler encryptedEmbeddedStreamsHandler;

    public PdfDocument(PdfReader reader) {
        this(reader, new DocumentProperties());
    }

    public PdfDocument(PdfReader reader, DocumentProperties properties) {
        if (reader == null) {
            throw new IllegalArgumentException("The reader in PdfDocument constructor can not be null.");
        }
        this.documentId = new SequenceId();
        this.reader = reader;
        this.properties = new StampingProperties();
        this.properties.setEventCountingMetaInfo(properties.metaInfo);
        this.open(null);
    }

    public PdfDocument(PdfWriter writer) {
        this(writer, new DocumentProperties());
    }

    public PdfDocument(PdfWriter writer, DocumentProperties properties) {
        if (writer == null) {
            throw new IllegalArgumentException("The writer in PdfDocument constructor can not be null.");
        }
        this.documentId = new SequenceId();
        this.writer = writer;
        this.properties = new StampingProperties();
        this.properties.setEventCountingMetaInfo(properties.metaInfo);
        this.open(writer.properties.pdfVersion);
    }

    public PdfDocument(PdfReader reader, PdfWriter writer) {
        this(reader, writer, new StampingProperties());
    }

    public PdfDocument(PdfReader reader, PdfWriter writer, StampingProperties properties) {
        Logger logger;
        if (reader == null) {
            throw new IllegalArgumentException("The reader in PdfDocument constructor can not be null.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("The writer in PdfDocument constructor can not be null.");
        }
        this.documentId = new SequenceId();
        this.reader = reader;
        this.writer = writer;
        this.properties = properties;
        boolean writerHasEncryption = this.writerHasEncryption();
        if (properties.appendMode && writerHasEncryption) {
            logger = LoggerFactory.getLogger(PdfDocument.class);
            logger.warn("Writer encryption will be ignored, because append mode is used. Document will preserve the original encryption (or will stay unencrypted)");
        }
        if (properties.preserveEncryption && writerHasEncryption) {
            logger = LoggerFactory.getLogger(PdfDocument.class);
            logger.warn("Writer encryption will be ignored, because preservation of encryption is enabled. Document will preserve the original encryption (or will stay unencrypted)");
        }
        this.open(writer.properties.pdfVersion);
    }

    protected void setXmpMetadata(byte[] xmpMetadata) {
        this.xmpMetadata = xmpMetadata;
    }

    public void setXmpMetadata(XMPMeta xmpMeta, SerializeOptions serializeOptions) throws XMPException {
        this.setXmpMetadata(XMPMetaFactory.serializeToBuffer(xmpMeta, serializeOptions));
    }

    public void setXmpMetadata(XMPMeta xmpMeta) throws XMPException {
        SerializeOptions serializeOptions = new SerializeOptions();
        serializeOptions.setPadding(2000);
        this.setXmpMetadata(xmpMeta, serializeOptions);
    }

    public byte[] getXmpMetadata() {
        return this.getXmpMetadata(false);
    }

    public byte[] getXmpMetadata(boolean createNew) {
        if (this.xmpMetadata == null && createNew) {
            XMPMeta xmpMeta = XMPMetaFactory.create();
            xmpMeta.setObjectName("xmpmeta");
            xmpMeta.setObjectName("");
            this.addCustomMetadataExtensions(xmpMeta);
            try {
                xmpMeta.setProperty("http://purl.org/dc/elements/1.1/", "format", "application/pdf");
                this.setXmpMetadata(xmpMeta);
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return this.xmpMetadata;
    }

    public PdfObject getPdfObject(int objNum) {
        this.checkClosingStatus();
        PdfIndirectReference reference = this.xref.get(objNum);
        if (reference == null) {
            return null;
        }
        return reference.getRefersTo();
    }

    public int getNumberOfPdfObjects() {
        return this.xref.size();
    }

    public PdfPage getPage(int pageNum) {
        this.checkClosingStatus();
        return this.catalog.getPageTree().getPage(pageNum);
    }

    public PdfPage getPage(PdfDictionary pageDictionary) {
        this.checkClosingStatus();
        return this.catalog.getPageTree().getPage(pageDictionary);
    }

    public PdfPage getFirstPage() {
        this.checkClosingStatus();
        return this.getPage(1);
    }

    public PdfPage getLastPage() {
        return this.getPage(this.getNumberOfPages());
    }

    public void markStreamAsEmbeddedFile(PdfStream stream) {
        this.encryptedEmbeddedStreamsHandler.storeEmbeddedStream(stream);
    }

    public PdfPage addNewPage() {
        return this.addNewPage(this.getDefaultPageSize());
    }

    public PdfPage addNewPage(PageSize pageSize) {
        this.checkClosingStatus();
        PdfPage page = this.getPageFactory().createPdfPage(this, pageSize);
        this.checkAndAddPage(page);
        this.dispatchEvent(new PdfDocumentEvent("StartPdfPage", page));
        this.dispatchEvent(new PdfDocumentEvent("InsertPdfPage", page));
        return page;
    }

    public PdfPage addNewPage(int index) {
        return this.addNewPage(index, this.getDefaultPageSize());
    }

    public PdfPage addNewPage(int index, PageSize pageSize) {
        this.checkClosingStatus();
        PdfPage page = this.getPageFactory().createPdfPage(this, pageSize);
        this.checkAndAddPage(index, page);
        this.dispatchEvent(new PdfDocumentEvent("StartPdfPage", page));
        this.dispatchEvent(new PdfDocumentEvent("InsertPdfPage", page));
        return page;
    }

    public PdfPage addPage(PdfPage page) {
        this.checkClosingStatus();
        this.checkAndAddPage(page);
        this.dispatchEvent(new PdfDocumentEvent("InsertPdfPage", page));
        return page;
    }

    public PdfPage addPage(int index, PdfPage page) {
        this.checkClosingStatus();
        this.checkAndAddPage(index, page);
        this.dispatchEvent(new PdfDocumentEvent("InsertPdfPage", page));
        return page;
    }

    public int getNumberOfPages() {
        this.checkClosingStatus();
        return this.catalog.getPageTree().getNumberOfPages();
    }

    public int getPageNumber(PdfPage page) {
        this.checkClosingStatus();
        return this.catalog.getPageTree().getPageNumber(page);
    }

    public int getPageNumber(PdfDictionary pageDictionary) {
        return this.catalog.getPageTree().getPageNumber(pageDictionary);
    }

    public boolean movePage(PdfPage page, int insertBefore) {
        this.checkClosingStatus();
        int pageNum = this.getPageNumber(page);
        if (pageNum > 0) {
            this.movePage(pageNum, insertBefore);
            return true;
        }
        return false;
    }

    public void movePage(int pageNumber, int insertBefore) {
        this.checkClosingStatus();
        if (insertBefore < 1 || insertBefore > this.getNumberOfPages() + 1) {
            throw new IndexOutOfBoundsException(MessageFormatUtil.format("Requested page number {0} is out of bounds.", insertBefore));
        }
        PdfPage page = this.getPage(pageNumber);
        if (this.isTagged()) {
            this.getStructTreeRoot().move(page, insertBefore);
            this.getTagStructureContext().normalizeDocumentRootTag();
        }
        PdfPage removedPage = this.catalog.getPageTree().removePage(pageNumber);
        if (insertBefore > pageNumber) {
            --insertBefore;
        }
        this.catalog.getPageTree().addPage(insertBefore, removedPage);
    }

    public boolean removePage(PdfPage page) {
        this.checkClosingStatus();
        int pageNum = this.getPageNumber(page);
        if (pageNum >= 1) {
            this.removePage(pageNum);
            return true;
        }
        return false;
    }

    public void removePage(int pageNum) {
        this.checkClosingStatus();
        PdfPage removedPage = this.getPage(pageNum);
        if (removedPage != null && removedPage.isFlushed() && (this.isTagged() || this.hasAcroForm())) {
            throw new PdfException("Flushed page cannot be removed from a document which is tagged or has an AcroForm");
        }
        if (removedPage != null) {
            this.catalog.removeOutlines(removedPage);
            this.removeUnusedWidgetsFromFields(removedPage);
            if (this.isTagged()) {
                this.getTagStructureContext().removePageTags(removedPage);
            }
            if (!removedPage.isFlushed()) {
                ((PdfDictionary)removedPage.getPdfObject()).remove(PdfName.Parent);
                ((PdfDictionary)removedPage.getPdfObject()).getIndirectReference().setFree();
            }
            this.dispatchEvent(new PdfDocumentEvent("RemovePdfPage", removedPage));
        }
        this.catalog.getPageTree().removePage(pageNum);
    }

    public PdfDocumentInfo getDocumentInfo() {
        this.checkClosingStatus();
        if (this.info == null) {
            PdfObject infoDict = this.trailer.get(PdfName.Info);
            this.info = new PdfDocumentInfo(infoDict instanceof PdfDictionary ? (PdfDictionary)infoDict : new PdfDictionary(), this);
            XmpMetaInfoConverter.appendMetadataToInfo(this.xmpMetadata, this.info);
        }
        return this.info;
    }

    public PdfString getOriginalDocumentId() {
        return this.originalDocumentId;
    }

    public PdfString getModifiedDocumentId() {
        return this.modifiedDocumentId;
    }

    public PageSize getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public void setDefaultPageSize(PageSize pageSize) {
        this.defaultPageSize = pageSize;
    }

    @Override
    public void addEventHandler(String type, IEventHandler handler) {
        this.eventDispatcher.addEventHandler(type, handler);
    }

    @Override
    public void dispatchEvent(Event event) {
        this.eventDispatcher.dispatchEvent(event);
    }

    @Override
    public void dispatchEvent(Event event, boolean delayed) {
        this.eventDispatcher.dispatchEvent(event, delayed);
    }

    @Override
    public boolean hasEventHandler(String type) {
        return this.eventDispatcher.hasEventHandler(type);
    }

    @Override
    public void removeEventHandler(String type, IEventHandler handler) {
        this.eventDispatcher.removeEventHandler(type, handler);
    }

    @Override
    public void removeAllHandlers() {
        this.eventDispatcher.removeAllHandlers();
    }

    public PdfWriter getWriter() {
        this.checkClosingStatus();
        return this.writer;
    }

    public PdfReader getReader() {
        this.checkClosingStatus();
        return this.reader;
    }

    public boolean isAppendMode() {
        this.checkClosingStatus();
        return this.properties.appendMode;
    }

    public PdfIndirectReference createNextIndirectReference() {
        this.checkClosingStatus();
        return this.xref.createNextIndirectReference(this);
    }

    public PdfVersion getPdfVersion() {
        return this.pdfVersion;
    }

    public PdfCatalog getCatalog() {
        this.checkClosingStatus();
        return this.catalog;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.isClosing = true;
        try {
            if (this.writer != null) {
                if (this.catalog.isFlushed()) {
                    throw new PdfException("Cannot close document with already flushed PDF Catalog.");
                }
                EventManager manager = EventManager.getInstance();
                manager.onEvent(new NumberOfPagesStatisticsEvent(this.catalog.getPageTree().getNumberOfPages(), ITextCoreProductData.getInstance()));
                manager.onEvent(new FlushPdfDocumentEvent(this));
                this.updateXmpMetadata();
                if (this.pdfVersion.compareTo(PdfVersion.PDF_2_0) >= 0) {
                    for (PdfName deprecatedKey : PdfDocumentInfo.PDF20_DEPRECATED_KEYS) {
                        this.getDocumentInfo().getPdfObject().remove(deprecatedKey);
                    }
                }
                if (this.getXmpMetadata() != null) {
                    PdfStream xmp = ((PdfDictionary)this.catalog.getPdfObject()).getAsStream(PdfName.Metadata);
                    if (this.isAppendMode() && xmp != null && !xmp.isFlushed() && xmp.getIndirectReference() != null) {
                        xmp.setData(this.xmpMetadata);
                        xmp.setModified();
                    } else {
                        xmp = (PdfStream)new PdfStream().makeIndirect(this);
                        xmp.getOutputStream().write(this.xmpMetadata);
                        ((PdfDictionary)this.catalog.getPdfObject()).put(PdfName.Metadata, xmp);
                        this.catalog.setModified();
                    }
                    xmp.put(PdfName.Type, PdfName.Metadata);
                    xmp.put(PdfName.Subtype, PdfName.XML);
                    if (this.writer.crypto != null && !this.writer.crypto.isMetadataEncrypted()) {
                        PdfArray ar = new PdfArray();
                        ar.add(PdfName.Crypt);
                        xmp.put(PdfName.Filter, ar);
                    }
                }
                this.checkIsoConformance();
                if (this.getNumberOfPages() == 0) {
                    this.addNewPage();
                }
                PdfObject crypto = null;
                HashSet<PdfIndirectReference> forbiddenToFlush = new HashSet<PdfIndirectReference>();
                if (this.properties.appendMode) {
                    if (this.structTreeRoot != null) {
                        this.tryFlushTagStructure(true);
                    }
                    if (this.catalog.isOCPropertiesMayHaveChanged() && ((PdfDictionary)this.catalog.getOCProperties(false).getPdfObject()).isModified()) {
                        this.catalog.getOCProperties(false).flush();
                    }
                    if (this.catalog.pageLabels != null) {
                        this.catalog.put(PdfName.PageLabels, this.catalog.pageLabels.buildTree());
                    }
                    for (Map.Entry<PdfName, PdfNameTree> entry : this.catalog.nameTrees.entrySet()) {
                        PdfNameTree tree = entry.getValue();
                        if (!tree.isModified()) continue;
                        this.ensureTreeRootAddedToNames(tree.buildTree().makeIndirect(this), entry.getKey());
                    }
                    PdfObject pageRoot = this.catalog.getPageTree().generateTree();
                    if (((PdfDictionary)this.catalog.getPdfObject()).isModified() || pageRoot.isModified()) {
                        this.catalog.put(PdfName.Pages, pageRoot);
                        ((PdfDictionary)this.catalog.getPdfObject()).flush(false);
                    }
                    if (this.getDocumentInfo().getPdfObject().isModified()) {
                        this.getDocumentInfo().getPdfObject().flush(false);
                    }
                    this.flushFonts();
                    if (this.writer.crypto != null) {
                        assert (this.reader.decrypt.getPdfObject() == this.writer.crypto.getPdfObject()) : "Conflict with source encryption";
                        crypto = (PdfObject)this.reader.decrypt.getPdfObject();
                        if (crypto.getIndirectReference() != null) {
                            forbiddenToFlush.add(crypto.getIndirectReference());
                        }
                    }
                    this.writer.flushModifiedWaitingObjects(forbiddenToFlush);
                    for (int i = 0; i < this.xref.size(); ++i) {
                        PdfIndirectReference indirectReference = this.xref.get(i);
                        if (indirectReference == null || indirectReference.isFree() || !indirectReference.checkState((short)8) || indirectReference.checkState((short)1) || forbiddenToFlush.contains(indirectReference)) continue;
                        indirectReference.setFree();
                    }
                } else {
                    if (this.catalog.isOCPropertiesMayHaveChanged()) {
                        ((PdfDictionary)this.catalog.getPdfObject()).put(PdfName.OCProperties, (PdfObject)this.catalog.getOCProperties(false).getPdfObject());
                        this.catalog.getOCProperties(false).flush();
                    }
                    if (this.catalog.pageLabels != null) {
                        this.catalog.put(PdfName.PageLabels, this.catalog.pageLabels.buildTree());
                    }
                    ((PdfDictionary)this.catalog.getPdfObject()).put(PdfName.Pages, this.catalog.getPageTree().generateTree());
                    for (Map.Entry<PdfName, PdfNameTree> entry : this.catalog.nameTrees.entrySet()) {
                        PdfNameTree tree = entry.getValue();
                        if (!tree.isModified()) continue;
                        this.ensureTreeRootAddedToNames(tree.buildTree().makeIndirect(this), entry.getKey());
                    }
                    for (int pageNum = 1; pageNum <= this.getNumberOfPages(); ++pageNum) {
                        PdfPage page = this.getPage(pageNum);
                        if (page == null) continue;
                        page.flush();
                    }
                    if (this.structTreeRoot != null) {
                        this.tryFlushTagStructure(false);
                    }
                    ((PdfDictionary)this.catalog.getPdfObject()).flush(false);
                    this.getDocumentInfo().getPdfObject().flush(false);
                    this.flushFonts();
                    if (this.writer.crypto != null) {
                        crypto = this.writer.crypto.getPdfObject();
                        crypto.makeIndirect(this);
                        forbiddenToFlush.add(crypto.getIndirectReference());
                    }
                    this.writer.flushWaitingObjects(forbiddenToFlush);
                    for (int i = 0; i < this.xref.size(); ++i) {
                        PdfObject object;
                        PdfIndirectReference indirectReference = this.xref.get(i);
                        if (indirectReference == null || indirectReference.isFree() || indirectReference.checkState((short)1) || forbiddenToFlush.contains(indirectReference)) continue;
                        if (this.isFlushUnusedObjects() && !indirectReference.checkState((short)16) && (object = indirectReference.getRefersTo(false)) != null) {
                            object.flush();
                            continue;
                        }
                        indirectReference.setFree();
                    }
                }
                this.writer.crypto = null;
                if (!this.properties.appendMode && crypto != null) {
                    crypto.flush(false);
                }
                this.trailer.put(PdfName.Root, (PdfObject)this.catalog.getPdfObject());
                this.trailer.put(PdfName.Info, this.getDocumentInfo().getPdfObject());
                PdfObject fileId = PdfEncryption.createInfoId(ByteUtils.getIsoBytes(this.originalDocumentId.getValue()), ByteUtils.getIsoBytes(this.modifiedDocumentId.getValue()));
                this.xref.writeXrefTableAndTrailer(this, fileId, crypto);
                this.writer.flush();
                if (this.writer.getOutputStream() instanceof CountOutputStream) {
                    long amountOfBytes = ((CountOutputStream)this.writer.getOutputStream()).getAmountOfWrittenBytes();
                    manager.onEvent(new SizeOfPdfStatisticsEvent(amountOfBytes, ITextCoreProductData.getInstance()));
                }
            }
            this.catalog.getPageTree().clearPageRefs();
            this.removeAllHandlers();
        }
        catch (IOException e) {
            throw new PdfException("Cannot close document.", e, this);
        }
        finally {
            Logger logger;
            if (this.writer != null && this.isCloseWriter()) {
                try {
                    this.writer.close();
                }
                catch (Exception e) {
                    logger = LoggerFactory.getLogger(PdfDocument.class);
                    logger.error("PdfWriter closing failed due to the error occurred!", e);
                }
            }
            if (this.reader != null && this.isCloseReader()) {
                try {
                    this.reader.close();
                }
                catch (Exception e) {
                    logger = LoggerFactory.getLogger(PdfDocument.class);
                    logger.error("PdfReader closing failed due to the error occurred!", e);
                }
            }
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isTagged() {
        return this.structTreeRoot != null;
    }

    public PdfDocument setTagged() {
        this.checkClosingStatus();
        if (this.structTreeRoot == null) {
            this.structTreeRoot = new PdfStructTreeRoot(this);
            ((PdfDictionary)this.catalog.getPdfObject()).put(PdfName.StructTreeRoot, (PdfObject)this.structTreeRoot.getPdfObject());
            this.updateValueInMarkInfoDict(PdfName.Marked, PdfBoolean.TRUE);
            this.structParentIndex = 0;
        }
        return this;
    }

    public PdfStructTreeRoot getStructTreeRoot() {
        return this.structTreeRoot;
    }

    public int getNextStructParentIndex() {
        int n;
        if (this.structParentIndex < 0) {
            n = -1;
        } else {
            int n2 = this.structParentIndex;
            n = n2;
            this.structParentIndex = n2 + 1;
        }
        return n;
    }

    public TagStructureContext getTagStructureContext() {
        this.checkClosingStatus();
        if (this.tagStructureContext == null) {
            if (!this.isTagged()) {
                throw new PdfException("Must be a tagged document.");
            }
            this.initTagStructureContext();
        }
        return this.tagStructureContext;
    }

    public List<PdfPage> copyPagesTo(int pageFrom, int pageTo, PdfDocument toDocument, int insertBeforePage) {
        return this.copyPagesTo(pageFrom, pageTo, toDocument, insertBeforePage, null);
    }

    public List<PdfPage> copyPagesTo(int pageFrom, int pageTo, PdfDocument toDocument, int insertBeforePage, IPdfPageExtraCopier copier) {
        ArrayList<Integer> pages = new ArrayList<Integer>();
        for (int i = pageFrom; i <= pageTo; ++i) {
            pages.add(i);
        }
        return this.copyPagesTo(pages, toDocument, insertBeforePage, copier);
    }

    public List<PdfPage> copyPagesTo(int pageFrom, int pageTo, PdfDocument toDocument) {
        return this.copyPagesTo(pageFrom, pageTo, toDocument, null);
    }

    public List<PdfPage> copyPagesTo(int pageFrom, int pageTo, PdfDocument toDocument, IPdfPageExtraCopier copier) {
        return this.copyPagesTo(pageFrom, pageTo, toDocument, toDocument.getNumberOfPages() + 1, copier);
    }

    public List<PdfPage> copyPagesTo(List<Integer> pagesToCopy, PdfDocument toDocument, int insertBeforePage) {
        return this.copyPagesTo(pagesToCopy, toDocument, insertBeforePage, null);
    }

    public List<PdfPage> copyPagesTo(List<Integer> pagesToCopy, PdfDocument toDocument, int insertBeforePage, IPdfPageExtraCopier copier) {
        if (pagesToCopy.isEmpty()) {
            return Collections.emptyList();
        }
        this.checkClosingStatus();
        ArrayList<PdfPage> copiedPages = new ArrayList<PdfPage>();
        LinkedHashMap<PdfPage, PdfPage> page2page = new LinkedHashMap<PdfPage, PdfPage>();
        HashSet<PdfOutline> outlinesToCopy = new HashSet<PdfOutline>();
        ArrayList rangesOfPagesWithIncreasingNumbers = new ArrayList();
        int lastCopiedPageNum = pagesToCopy.get(0);
        int pageInsertIndex = insertBeforePage;
        boolean insertInBetween = insertBeforePage < toDocument.getNumberOfPages() + 1;
        for (Integer n : pagesToCopy) {
            List<PdfOutline> pageOutlines;
            PdfPage page = this.getPage(n);
            PdfPage newPage = page.copyTo(toDocument, copier);
            copiedPages.add(newPage);
            page2page.put(page, newPage);
            if (lastCopiedPageNum >= n) {
                rangesOfPagesWithIncreasingNumbers.add(new HashMap());
            }
            int lastRangeInd = rangesOfPagesWithIncreasingNumbers.size() - 1;
            ((Map)rangesOfPagesWithIncreasingNumbers.get(lastRangeInd)).put(page, newPage);
            if (insertInBetween) {
                toDocument.addPage(pageInsertIndex, newPage);
            } else {
                toDocument.addPage(newPage);
            }
            ++pageInsertIndex;
            if (toDocument.hasOutlines() && (pageOutlines = page.getOutlines(false)) != null) {
                outlinesToCopy.addAll(pageOutlines);
            }
            lastCopiedPageNum = n;
        }
        this.copyLinkAnnotations(toDocument, page2page);
        if (this.getCatalog() != null && ((PdfDictionary)this.getCatalog().getPdfObject()).getAsDictionary(PdfName.OCProperties) != null) {
            OcgPropertiesCopier.copyOCGProperties(this, toDocument, page2page);
        }
        if (toDocument.isTagged()) {
            if (this.isTagged()) {
                try {
                    for (Map map : rangesOfPagesWithIncreasingNumbers) {
                        if (insertInBetween) {
                            this.getStructTreeRoot().copyTo(toDocument, insertBeforePage, map);
                        } else {
                            this.getStructTreeRoot().copyTo(toDocument, map);
                        }
                        insertBeforePage += map.size();
                    }
                    toDocument.getTagStructureContext().normalizeDocumentRootTag();
                }
                catch (Exception ex) {
                    throw new PdfException("Tag structure copying failed: it might be corrupted in one of the documents.", ex);
                }
            } else {
                Logger logger = LoggerFactory.getLogger(PdfDocument.class);
                logger.warn("Not tagged pages are copied to the tagged document. Destination document now may contain not tagged content.");
            }
        }
        if (this.catalog.isOutlineMode()) {
            this.copyOutlines(outlinesToCopy, toDocument, page2page);
        }
        return copiedPages;
    }

    public List<PdfPage> copyPagesTo(List<Integer> pagesToCopy, PdfDocument toDocument) {
        return this.copyPagesTo(pagesToCopy, toDocument, null);
    }

    public List<PdfPage> copyPagesTo(List<Integer> pagesToCopy, PdfDocument toDocument, IPdfPageExtraCopier copier) {
        return this.copyPagesTo(pagesToCopy, toDocument, toDocument.getNumberOfPages() + 1, copier);
    }

    public void flushCopiedObjects(PdfDocument sourceDoc) {
        if (this.getWriter() != null) {
            this.getWriter().flushCopiedObjects(sourceDoc.getDocumentId());
        }
    }

    public boolean isCloseReader() {
        return this.closeReader;
    }

    public void setCloseReader(boolean closeReader) {
        this.checkClosingStatus();
        this.closeReader = closeReader;
    }

    public boolean isCloseWriter() {
        return this.closeWriter;
    }

    public void setCloseWriter(boolean closeWriter) {
        this.checkClosingStatus();
        this.closeWriter = closeWriter;
    }

    public boolean isFlushUnusedObjects() {
        return this.flushUnusedObjects;
    }

    public void setFlushUnusedObjects(boolean flushUnusedObjects) {
        this.checkClosingStatus();
        this.flushUnusedObjects = flushUnusedObjects;
    }

    public PdfOutline getOutlines(boolean updateOutlines) {
        this.checkClosingStatus();
        return this.catalog.getOutlines(updateOutlines);
    }

    public void initializeOutlines() {
        this.checkClosingStatus();
        this.getOutlines(false);
    }

    public void addNamedDestination(String key, PdfObject value) {
        this.checkClosingStatus();
        if (value.isArray() && ((PdfArray)value).get(0).isNumber()) {
            LoggerFactory.getLogger(PdfDocument.class).warn("When destination's not associated with a Remote or Embedded Go-To action, it shall specify page dictionary instead of page number. Otherwise destination might be considered invalid");
        }
        this.catalog.addNamedDestination(key, value);
    }

    public List<PdfIndirectReference> listIndirectReferences() {
        this.checkClosingStatus();
        ArrayList<PdfIndirectReference> indRefs = new ArrayList<PdfIndirectReference>(this.xref.size());
        for (int i = 0; i < this.xref.size(); ++i) {
            PdfIndirectReference indref = this.xref.get(i);
            if (indref == null) continue;
            indRefs.add(indref);
        }
        return indRefs;
    }

    public PdfDictionary getTrailer() {
        this.checkClosingStatus();
        return this.trailer;
    }

    public void addOutputIntent(PdfOutputIntent outputIntent) {
        this.checkClosingStatus();
        if (outputIntent == null) {
            return;
        }
        PdfArray outputIntents = ((PdfDictionary)this.catalog.getPdfObject()).getAsArray(PdfName.OutputIntents);
        if (outputIntents == null) {
            outputIntents = new PdfArray();
            this.catalog.put(PdfName.OutputIntents, outputIntents);
        }
        outputIntents.add((PdfObject)outputIntent.getPdfObject());
    }

    public void checkIsoConformance(Object obj, IsoKey key) {
    }

    public void checkIsoConformance(Object obj, IsoKey key, PdfResources resources, PdfStream contentStream) {
    }

    public void checkShowTextIsoConformance(CanvasGraphicsState gState, PdfResources resources) {
    }

    public void addFileAttachment(String key, PdfFileSpec fs) {
        this.checkClosingStatus();
        this.catalog.addNameToNameTree(key, (PdfObject)fs.getPdfObject(), PdfName.EmbeddedFiles);
    }

    public void addAssociatedFile(String description, PdfFileSpec fs) {
        PdfArray afArray;
        if (null == ((PdfDictionary)fs.getPdfObject()).get(PdfName.AFRelationship)) {
            Logger logger = LoggerFactory.getLogger(PdfDocument.class);
            logger.error("For associated files their associated file specification dictionaries shall include the AFRelationship key.");
        }
        if ((afArray = ((PdfDictionary)this.catalog.getPdfObject()).getAsArray(PdfName.AF)) == null) {
            afArray = (PdfArray)new PdfArray().makeIndirect(this);
            this.catalog.put(PdfName.AF, afArray);
        }
        afArray.add((PdfObject)fs.getPdfObject());
        this.addFileAttachment(description, fs);
    }

    public PdfArray getAssociatedFiles() {
        this.checkClosingStatus();
        return ((PdfDictionary)this.catalog.getPdfObject()).getAsArray(PdfName.AF);
    }

    public PdfEncryptedPayloadDocument getEncryptedPayloadDocument() {
        if (this.getReader() != null && this.getReader().isEncrypted()) {
            return null;
        }
        PdfCollection collection = this.getCatalog().getCollection();
        if (collection != null && collection.isViewHidden()) {
            PdfString documentName = collection.getInitialDocument();
            PdfNameTree embeddedFiles = this.getCatalog().getNameTree(PdfName.EmbeddedFiles);
            String documentNameUnicode = documentName.toUnicodeString();
            PdfObject fileSpecObject = embeddedFiles.getNames().get(documentNameUnicode);
            if (fileSpecObject != null && fileSpecObject.isDictionary()) {
                try {
                    PdfFileSpec fileSpec = PdfEncryptedPayloadFileSpecFactory.wrap((PdfDictionary)fileSpecObject);
                    if (fileSpec != null) {
                        PdfDictionary embeddedDictionary = ((PdfDictionary)fileSpec.getPdfObject()).getAsDictionary(PdfName.EF);
                        PdfStream stream = embeddedDictionary.getAsStream(PdfName.UF);
                        if (stream == null) {
                            stream = embeddedDictionary.getAsStream(PdfName.F);
                        }
                        if (stream != null) {
                            return new PdfEncryptedPayloadDocument(stream, fileSpec, documentNameUnicode);
                        }
                    }
                }
                catch (PdfException e) {
                    LoggerFactory.getLogger(this.getClass()).error(e.getMessage());
                }
            }
        }
        return null;
    }

    public void setEncryptedPayload(PdfFileSpec fs) {
        PdfEncryptedPayload encryptedPayload;
        if (this.getWriter() == null) {
            throw new PdfException("Cannot set encrypted payload to a document opened in read only mode.");
        }
        if (this.writerHasEncryption()) {
            throw new PdfException("Cannot set encrypted payload to an encrypted document.");
        }
        if (!PdfName.EncryptedPayload.equals(((PdfDictionary)fs.getPdfObject()).get(PdfName.AFRelationship))) {
            LoggerFactory.getLogger(this.getClass()).error("Encrypted payload file spec shall have 'AFRelationship' filed equal to 'EncryptedPayload'");
        }
        if ((encryptedPayload = PdfEncryptedPayload.extractFrom(fs)) == null) {
            throw new PdfException("Encrypted payload file spec shall have encrypted payload dictionary.");
        }
        PdfCollection collection = this.getCatalog().getCollection();
        if (collection != null) {
            LoggerFactory.getLogger(this.getClass()).warn("Collection dictionary already exists. It will be modified.");
        } else {
            collection = new PdfCollection();
            this.getCatalog().setCollection(collection);
        }
        collection.setView(2);
        String displayName = PdfEncryptedPayloadFileSpecFactory.generateFileDisplay(encryptedPayload);
        collection.setInitialDocument(displayName);
        this.addAssociatedFile(displayName, fs);
    }

    public String[] getPageLabels() {
        if (this.catalog.getPageLabelsTree(false) == null) {
            return null;
        }
        Map<Integer, PdfObject> pageLabels = this.catalog.getPageLabelsTree(false).getNumbers();
        if (pageLabels.size() == 0) {
            return null;
        }
        String[] labelStrings = new String[this.getNumberOfPages()];
        int pageCount = 1;
        String prefix = "";
        String type = "D";
        for (int i = 0; i < this.getNumberOfPages(); ++i) {
            if (pageLabels.containsKey(i)) {
                PdfDictionary labelDictionary = (PdfDictionary)pageLabels.get(i);
                PdfNumber pageRange = labelDictionary.getAsNumber(PdfName.St);
                pageCount = pageRange != null ? pageRange.intValue() : 1;
                PdfString p = labelDictionary.getAsString(PdfName.P);
                prefix = p != null ? p.toUnicodeString() : "";
                PdfName t = labelDictionary.getAsName(PdfName.S);
                type = t != null ? t.getValue() : "e";
            }
            switch (type) {
                case "R": {
                    labelStrings[i] = prefix + RomanNumbering.toRomanUpperCase(pageCount);
                    break;
                }
                case "r": {
                    labelStrings[i] = prefix + RomanNumbering.toRomanLowerCase(pageCount);
                    break;
                }
                case "A": {
                    labelStrings[i] = prefix + EnglishAlphabetNumbering.toLatinAlphabetNumberUpperCase(pageCount);
                    break;
                }
                case "a": {
                    labelStrings[i] = prefix + EnglishAlphabetNumbering.toLatinAlphabetNumberLowerCase(pageCount);
                    break;
                }
                case "e": {
                    labelStrings[i] = prefix;
                    break;
                }
                default: {
                    labelStrings[i] = prefix + pageCount;
                }
            }
            ++pageCount;
        }
        return labelStrings;
    }

    public boolean hasOutlines() {
        return this.catalog.hasOutlines();
    }

    public void setUserProperties(boolean userProperties) {
        PdfBoolean userPropsVal = userProperties ? PdfBoolean.TRUE : PdfBoolean.FALSE;
        this.updateValueInMarkInfoDict(PdfName.UserProperties, userPropsVal);
    }

    public PdfFont getFont(PdfDictionary dictionary) {
        PdfIndirectReference indirectReference = dictionary.getIndirectReference();
        if (indirectReference != null && this.documentFonts.containsKey(indirectReference)) {
            return this.documentFonts.get(indirectReference);
        }
        return this.addFont(PdfFontFactory.createFont(dictionary));
    }

    public PdfFont getDefaultFont() {
        if (this.defaultFont == null) {
            try {
                this.defaultFont = PdfFontFactory.createFont();
                if (this.writer != null) {
                    this.defaultFont.makeIndirect(this);
                }
            }
            catch (IOException e) {
                Logger logger = LoggerFactory.getLogger(PdfDocument.class);
                logger.error("Exception while creating default font (Helvetica, WinAnsi)", e);
                this.defaultFont = null;
            }
        }
        return this.defaultFont;
    }

    public PdfFont addFont(PdfFont font) {
        font.makeIndirect(this);
        font.setForbidRelease();
        this.documentFonts.put(((PdfDictionary)font.getPdfObject()).getIndirectReference(), font);
        return font;
    }

    public boolean registerProduct(ProductData productData) {
        return this.fingerPrint.registerProduct(productData);
    }

    public FingerPrint getFingerPrint() {
        return this.fingerPrint;
    }

    public PdfFont findFont(String fontProgram, String encoding) {
        for (PdfFont font : this.documentFonts.values()) {
            if (font.isFlushed() || !font.isBuiltWith(fontProgram, encoding)) continue;
            return font;
        }
        return null;
    }

    public long getDocumentId() {
        return this.documentId.getId();
    }

    public SequenceId getDocumentIdWrapper() {
        return this.documentId;
    }

    PdfXrefTable getXref() {
        return this.xref;
    }

    boolean isDocumentFont(PdfIndirectReference indRef) {
        return indRef != null && this.documentFonts.containsKey(indRef);
    }

    protected void initTagStructureContext() {
        this.tagStructureContext = new TagStructureContext(this);
    }

    protected void storeLinkAnnotation(PdfPage page, PdfLinkAnnotation annotation) {
        List<PdfLinkAnnotation> pageAnnotations = this.linkAnnotations.get(page);
        if (pageAnnotations == null) {
            pageAnnotations = new ArrayList<PdfLinkAnnotation>();
            this.linkAnnotations.put(page, pageAnnotations);
        }
        pageAnnotations.add(annotation);
    }

    protected void checkIsoConformance() {
    }

    protected void markObjectAsMustBeFlushed(PdfObject pdfObject) {
        if (pdfObject.getIndirectReference() != null) {
            pdfObject.getIndirectReference().setState((short)32);
        }
    }

    protected void flushObject(PdfObject pdfObject, boolean canBeInObjStm) throws IOException {
        this.writer.flushObject(pdfObject, canBeInObjStm);
    }

    protected void open(PdfVersion newPdfVersion) {
        this.fingerPrint = new FingerPrint();
        this.encryptedEmbeddedStreamsHandler = new EncryptedEmbeddedStreamsHandler(this);
        try {
            ITextCoreProductEvent event = ITextCoreProductEvent.createProcessPdfEvent(this.getDocumentIdWrapper(), this.properties.metaInfo, this.writer == null ? EventConfirmationType.ON_DEMAND : EventConfirmationType.ON_CLOSE);
            EventManager.getInstance().onEvent(event);
            boolean embeddedStreamsSavedOnReading = false;
            if (this.reader != null) {
                PdfDictionary str;
                if (this.reader.pdfDocument != null) {
                    throw new PdfException("Given PdfReader instance has already been utilized. The PdfReader cannot be reused, please create a new instance.");
                }
                this.reader.pdfDocument = this;
                this.memoryLimitsAwareHandler = this.reader.properties.memoryLimitsAwareHandler;
                if (null == this.memoryLimitsAwareHandler) {
                    this.memoryLimitsAwareHandler = new MemoryLimitsAwareHandler(this.reader.tokens.getSafeFile().length());
                }
                this.reader.readPdf();
                if (this.reader.decrypt != null && this.reader.decrypt.isEmbeddedFilesOnly()) {
                    this.encryptedEmbeddedStreamsHandler.storeAllEmbeddedStreams();
                    embeddedStreamsSavedOnReading = true;
                }
                this.pdfVersion = this.reader.headerPdfVersion;
                this.trailer = new PdfDictionary(this.reader.trailer);
                this.readDocumentIds();
                this.catalog = new PdfCatalog((PdfDictionary)this.trailer.get(PdfName.Root, true));
                this.updatePdfVersionFromCatalog();
                PdfStream xmpMetadataStream = ((PdfDictionary)this.catalog.getPdfObject()).getAsStream(PdfName.Metadata);
                if (xmpMetadataStream != null) {
                    this.xmpMetadata = xmpMetadataStream.getBytes();
                    if (!this.getClass().equals(PdfDocument.class)) {
                        this.reader.getPdfAConformanceLevel();
                        this.getDocumentInfo();
                    }
                }
                if ((str = ((PdfDictionary)this.catalog.getPdfObject()).getAsDictionary(PdfName.StructTreeRoot)) != null) {
                    this.tryInitTagStructure(str);
                }
                if (this.properties.appendMode && (this.reader.hasRebuiltXref() || this.reader.hasFixedXref())) {
                    throw new PdfException("Append mode requires a document without errors, even if recovery is possible.");
                }
            }
            this.xref.initFreeReferencesList(this);
            if (this.writer != null) {
                if (this.reader != null && this.reader.hasXrefStm() && this.writer.properties.isFullCompression == null) {
                    this.writer.properties.isFullCompression = true;
                }
                if (this.reader != null && !this.reader.isOpenedWithFullPermission()) {
                    throw new BadPasswordException("PdfReader is not opened with owner password");
                }
                if (this.reader != null && this.properties.preserveEncryption) {
                    this.writer.crypto = this.reader.decrypt;
                }
                this.writer.document = this;
                if (this.reader == null) {
                    this.catalog = new PdfCatalog(this);
                    this.info = new PdfDocumentInfo(this).addCreationDate();
                }
                this.getDocumentInfo().addModDate();
                this.trailer = new PdfDictionary();
                this.trailer.put(PdfName.Root, ((PdfDictionary)this.catalog.getPdfObject()).getIndirectReference());
                this.trailer.put(PdfName.Info, this.getDocumentInfo().getPdfObject().getIndirectReference());
                if (this.reader != null && this.reader.trailer.containsKey(PdfName.ID)) {
                    this.trailer.put(PdfName.ID, this.reader.trailer.get(PdfName.ID));
                }
                if (this.writer.properties != null) {
                    PdfString readerModifiedId = this.modifiedDocumentId;
                    if (this.writer.properties.initialDocumentId != null && (this.reader == null || this.reader.decrypt == null || !this.properties.appendMode && !this.properties.preserveEncryption)) {
                        this.originalDocumentId = this.writer.properties.initialDocumentId;
                    }
                    if (this.writer.properties.modifiedDocumentId != null) {
                        this.modifiedDocumentId = this.writer.properties.modifiedDocumentId;
                    }
                    if (this.originalDocumentId == null && this.modifiedDocumentId != null) {
                        this.originalDocumentId = this.modifiedDocumentId;
                    }
                    if (this.modifiedDocumentId == null) {
                        if (this.originalDocumentId == null) {
                            this.originalDocumentId = new PdfString(PdfEncryption.generateNewDocumentId());
                        }
                        this.modifiedDocumentId = this.originalDocumentId;
                    }
                    if (this.writer.properties.modifiedDocumentId == null && this.modifiedDocumentId.equals(readerModifiedId)) {
                        this.modifiedDocumentId = new PdfString(PdfEncryption.generateNewDocumentId());
                    }
                }
                assert (this.originalDocumentId != null);
                assert (this.modifiedDocumentId != null);
            }
            if (this.properties.appendMode) {
                int n;
                assert (this.reader != null);
                RandomAccessFileOrArray file = this.reader.tokens.getSafeFile();
                byte[] buffer = new byte[8192];
                while ((n = file.read(buffer)) > 0) {
                    this.writer.write(buffer, 0, n);
                }
                file.close();
                this.writer.write(10);
                PdfDocument.overrideFullCompressionInWriterProperties(this.writer.properties, this.reader.hasXrefStm());
                this.writer.crypto = this.reader.decrypt;
                if (newPdfVersion != null && this.pdfVersion.compareTo(PdfVersion.PDF_1_4) >= 0 && newPdfVersion.compareTo(this.reader.headerPdfVersion) > 0) {
                    this.catalog.put(PdfName.Version, newPdfVersion.toPdfName());
                    this.catalog.setModified();
                    this.pdfVersion = newPdfVersion;
                }
            } else if (this.writer != null) {
                if (newPdfVersion != null) {
                    this.pdfVersion = newPdfVersion;
                }
                this.writer.writeHeader();
                if (this.writer.crypto == null) {
                    this.writer.initCryptoIfSpecified(this.pdfVersion);
                }
                if (this.writer.crypto != null) {
                    PdfNumber r;
                    if (!embeddedStreamsSavedOnReading && this.writer.crypto.isEmbeddedFilesOnly()) {
                        this.encryptedEmbeddedStreamsHandler.storeAllEmbeddedStreams();
                    }
                    if (this.writer.crypto.getCryptoMode() < 3) {
                        VersionConforming.validatePdfVersionForDeprecatedFeatureLogWarn(this, PdfVersion.PDF_2_0, "Encryption algorithms STANDARD_ENCRYPTION_40, STANDARD_ENCRYPTION_128 and ENCRYPTION_AES_128 (see com.itextpdf.kernel.pdf.EncryptionConstants) are deprecated in PDF 2.0. It is highly recommended not to use it.");
                    } else if (this.writer.crypto.getCryptoMode() == 3 && (r = ((PdfDictionary)this.writer.crypto.getPdfObject()).getAsNumber(PdfName.R)) != null && r.intValue() == 5) {
                        VersionConforming.validatePdfVersionForDeprecatedFeatureLogWarn(this, PdfVersion.PDF_2_0, "It seems that PDF 1.7 document encrypted with AES256 was updated to PDF 2.0 version and StampingProperties#preserveEncryption flag was set: encryption shall be updated via WriterProperties#setStandardEncryption method. Standard security handler was found with revision 5, which is deprecated and shall not be used in PDF 2.0 documents.");
                    }
                }
            }
            if (EventConfirmationType.ON_DEMAND == event.getConfirmationType()) {
                EventManager.getInstance().onEvent(new ConfirmEvent(event));
            }
        }
        catch (IOException e) {
            throw new PdfException("Cannot open document.", e, this);
        }
    }

    protected void addCustomMetadataExtensions(XMPMeta xmpMeta) {
    }

    protected void updateXmpMetadata() {
        try {
            if (this.xmpMetadata != null || this.writer.properties.addXmpMetadata || this.pdfVersion.compareTo(PdfVersion.PDF_2_0) >= 0) {
                this.setXmpMetadata(this.updateDefaultXmpMetadata());
            }
        }
        catch (XMPException e) {
            Logger logger = LoggerFactory.getLogger(PdfDocument.class);
            logger.error("Exception while updating XmpMetadata", e);
        }
    }

    protected XMPMeta updateDefaultXmpMetadata() throws XMPException {
        XMPMeta xmpMeta = XMPMetaFactory.parseFromBuffer(this.getXmpMetadata(true));
        XmpMetaInfoConverter.appendDocumentInfoToMetadata(this.getDocumentInfo(), xmpMeta);
        if (this.isTagged() && this.writer.properties.addUAXmpMetadata && !PdfDocument.isXmpMetaHasProperty(xmpMeta, "http://www.aiim.org/pdfua/ns/id/", "part")) {
            xmpMeta.setPropertyInteger("http://www.aiim.org/pdfua/ns/id/", "part", 1, new PropertyOptions(0x40000000));
        }
        return xmpMeta;
    }

    protected Collection<PdfFont> getDocumentFonts() {
        return this.documentFonts.values();
    }

    protected void flushFonts() {
        if (this.properties.appendMode) {
            for (PdfFont font : this.getDocumentFonts()) {
                if (!((PdfDictionary)font.getPdfObject()).checkState((short)64) && !((PdfDictionary)font.getPdfObject()).getIndirectReference().checkState((short)8)) continue;
                font.flush();
            }
        } else {
            for (PdfFont font : this.getDocumentFonts()) {
                font.flush();
            }
        }
    }

    protected void checkAndAddPage(int index, PdfPage page) {
        if (page.isFlushed()) {
            throw new PdfException("Flushed page cannot be added or inserted.", page);
        }
        if (page.getDocument() != null && this != page.getDocument()) {
            throw new PdfException("The passed page belongs to document {0} (page {1} of the document) and therefore cannot be added to this document ({2}).").setMessageParams(page.getDocument(), page.getDocument().getPageNumber(page), this);
        }
        this.catalog.getPageTree().addPage(index, page);
    }

    protected void checkAndAddPage(PdfPage page) {
        if (page.isFlushed()) {
            throw new PdfException("Flushed page cannot be added or inserted.", page);
        }
        if (page.getDocument() != null && this != page.getDocument()) {
            throw new PdfException("The passed page belongs to document {0} (page {1} of the document) and therefore cannot be added to this document ({2}).").setMessageParams(page.getDocument(), page.getDocument().getPageNumber(page), this);
        }
        this.catalog.getPageTree().addPage(page);
    }

    protected void checkClosingStatus() {
        if (this.closed) {
            throw new PdfException("Document was closed. It is impossible to execute action.");
        }
    }

    protected IPdfPageFactory getPageFactory() {
        return pdfPageFactory;
    }

    boolean doesStreamBelongToEmbeddedFile(PdfStream stream) {
        return this.encryptedEmbeddedStreamsHandler.isStreamStoredAsEmbedded(stream);
    }

    boolean hasAcroForm() {
        return ((PdfDictionary)this.getCatalog().getPdfObject()).containsKey(PdfName.AcroForm);
    }

    protected void tryInitTagStructure(PdfDictionary str) {
        try {
            this.structTreeRoot = new PdfStructTreeRoot(str, this);
            this.structParentIndex = this.getStructTreeRoot().getParentTreeNextKey();
        }
        catch (Exception ex) {
            this.structTreeRoot = null;
            this.structParentIndex = -1;
            Logger logger = LoggerFactory.getLogger(PdfDocument.class);
            logger.error("Tag structure initialization failed, tag structure is ignored, it might be corrupted.", ex);
        }
    }

    private void tryFlushTagStructure(boolean isAppendMode) {
        try {
            if (this.tagStructureContext != null) {
                this.tagStructureContext.prepareToDocumentClosing();
            }
            if (!isAppendMode || ((PdfDictionary)this.structTreeRoot.getPdfObject()).isModified()) {
                this.structTreeRoot.flush();
            }
        }
        catch (Exception ex) {
            throw new PdfException("Tag structure flushing failed: it might be corrupted.", ex);
        }
    }

    private void updateValueInMarkInfoDict(PdfName key, PdfObject value) {
        PdfDictionary markInfo = ((PdfDictionary)this.catalog.getPdfObject()).getAsDictionary(PdfName.MarkInfo);
        if (markInfo == null) {
            markInfo = new PdfDictionary();
            ((PdfDictionary)this.catalog.getPdfObject()).put(PdfName.MarkInfo, markInfo);
        }
        markInfo.put(key, value);
    }

    private void removeUnusedWidgetsFromFields(PdfPage page) {
        if (page.isFlushed()) {
            return;
        }
        List<PdfAnnotation> annots = page.getAnnotations();
        for (PdfAnnotation annot : annots) {
            if (!annot.getSubtype().equals(PdfName.Widget)) continue;
            ((PdfWidgetAnnotation)annot).releaseFormFieldFromWidgetAnnotation();
        }
    }

    private void copyLinkAnnotations(PdfDocument toDocument, Map<PdfPage, PdfPage> page2page) {
        ArrayList<PdfName> excludedKeys = new ArrayList<PdfName>();
        excludedKeys.add(PdfName.Dest);
        excludedKeys.add(PdfName.A);
        for (Map.Entry<PdfPage, List<PdfLinkAnnotation>> entry : this.linkAnnotations.entrySet()) {
            for (PdfLinkAnnotation annot : entry.getValue()) {
                boolean toCopyAnnot = true;
                PdfDestination copiedDest = null;
                PdfDictionary copiedAction = null;
                PdfObject dest = annot.getDestinationObject();
                if (dest != null) {
                    copiedDest = this.getCatalog().copyDestination(dest, page2page, toDocument);
                    toCopyAnnot = copiedDest != null;
                } else {
                    PdfDictionary action = annot.getAction();
                    if (action != null) {
                        if (PdfName.GoTo.equals(action.get(PdfName.S))) {
                            copiedAction = action.copyTo(toDocument, Arrays.asList(PdfName.D), false);
                            PdfDestination goToDest = this.getCatalog().copyDestination(action.get(PdfName.D), page2page, toDocument);
                            if (goToDest != null) {
                                copiedAction.put(PdfName.D, (PdfObject)goToDest.getPdfObject());
                            } else {
                                toCopyAnnot = false;
                            }
                        } else {
                            copiedAction = (PdfDictionary)action.copyTo(toDocument, false);
                        }
                    }
                }
                if (!toCopyAnnot) continue;
                PdfLinkAnnotation newAnnot = (PdfLinkAnnotation)PdfAnnotation.makeAnnotation(((PdfDictionary)annot.getPdfObject()).copyTo(toDocument, excludedKeys, true));
                if (copiedDest != null) {
                    newAnnot.setDestination(copiedDest);
                }
                if (copiedAction != null) {
                    newAnnot.setAction(copiedAction);
                }
                entry.getKey().addAnnotation(-1, newAnnot, false);
            }
        }
        this.linkAnnotations.clear();
    }

    private void copyOutlines(Set<PdfOutline> outlines, PdfDocument toDocument, Map<PdfPage, PdfPage> page2page) {
        HashSet<PdfOutline> outlinesToCopy = new HashSet<PdfOutline>();
        outlinesToCopy.addAll(outlines);
        for (PdfOutline outline : outlines) {
            this.getAllOutlinesToCopy(outline, outlinesToCopy);
        }
        PdfOutline rootOutline = toDocument.getOutlines(false);
        if (rootOutline == null) {
            rootOutline = new PdfOutline(toDocument);
            rootOutline.setTitle("Outlines");
        }
        this.cloneOutlines(outlinesToCopy, rootOutline, this.getOutlines(false), page2page, toDocument);
    }

    private void getAllOutlinesToCopy(PdfOutline outline, Set<PdfOutline> outlinesToCopy) {
        PdfOutline parent = outline.getParent();
        if ("Outlines".equals(parent.getTitle()) || outlinesToCopy.contains(parent)) {
            return;
        }
        outlinesToCopy.add(parent);
        this.getAllOutlinesToCopy(parent, outlinesToCopy);
    }

    private void cloneOutlines(Set<PdfOutline> outlinesToCopy, PdfOutline newParent, PdfOutline oldParent, Map<PdfPage, PdfPage> page2page, PdfDocument toDocument) {
        if (null == oldParent) {
            return;
        }
        for (PdfOutline outline : oldParent.getAllChildren()) {
            Color copiedColor;
            Integer copiedStyle;
            if (!outlinesToCopy.contains(outline)) continue;
            PdfDestination copiedDest = null;
            if (null != outline.getDestination()) {
                Object destObjToCopy = outline.getDestination().getPdfObject();
                copiedDest = this.getCatalog().copyDestination((PdfObject)destObjToCopy, page2page, toDocument);
            }
            PdfOutline child = newParent.addOutline(outline.getTitle());
            if (copiedDest != null) {
                child.addDestination(copiedDest);
            }
            if ((copiedStyle = outline.getStyle()) != null) {
                child.setStyle(copiedStyle);
            }
            if ((copiedColor = outline.getColor()) != null) {
                child.setColor(copiedColor);
            }
            child.setOpen(outline.isOpen());
            this.cloneOutlines(outlinesToCopy, child, outline, page2page, toDocument);
        }
    }

    private void ensureTreeRootAddedToNames(PdfObject treeRoot, PdfName treeType) {
        PdfDictionary names = ((PdfDictionary)this.catalog.getPdfObject()).getAsDictionary(PdfName.Names);
        if (names == null) {
            names = new PdfDictionary();
            this.catalog.put(PdfName.Names, names);
            names.makeIndirect(this);
        }
        names.put(treeType, treeRoot);
        names.setModified();
    }

    private boolean writerHasEncryption() {
        return this.writer.properties.isStandardEncryptionUsed() || this.writer.properties.isPublicKeyEncryptionUsed();
    }

    private void updatePdfVersionFromCatalog() {
        if (((PdfDictionary)this.catalog.getPdfObject()).containsKey(PdfName.Version)) {
            try {
                PdfVersion catalogVersion = PdfVersion.fromPdfName(((PdfDictionary)this.catalog.getPdfObject()).getAsName(PdfName.Version));
                if (catalogVersion.compareTo(this.pdfVersion) > 0) {
                    this.pdfVersion = catalogVersion;
                }
            }
            catch (IllegalArgumentException e) {
                this.processReadingError("The document version specified in catalog is corrupted");
            }
        }
    }

    private void readDocumentIds() {
        PdfArray id = this.reader.trailer.getAsArray(PdfName.ID);
        if (id != null) {
            if (id.size() == 2) {
                this.originalDocumentId = id.getAsString(0);
                this.modifiedDocumentId = id.getAsString(1);
            }
            if (this.originalDocumentId == null || this.modifiedDocumentId == null) {
                this.processReadingError("The document original and/or modified id is corrupted");
            }
        }
    }

    private void processReadingError(String errorMessage) {
        if (!PdfReader.StrictnessLevel.CONSERVATIVE.isStricter(this.reader.getStrictnessLevel())) {
            throw new PdfException(errorMessage);
        }
        Logger logger = LoggerFactory.getLogger(PdfDocument.class);
        logger.error(errorMessage);
    }

    private static void overrideFullCompressionInWriterProperties(WriterProperties properties, boolean readerHasXrefStream) {
        if (Boolean.TRUE == properties.isFullCompression && !readerHasXrefStream) {
            Logger logger = LoggerFactory.getLogger(PdfDocument.class);
            logger.warn("Full compression mode requested in append mode but the original document has cross-reference table, not cross-reference stream. Falling back to cross-reference table in appended document and switching full compression off");
        } else if (Boolean.FALSE == properties.isFullCompression && readerHasXrefStream) {
            Logger logger = LoggerFactory.getLogger(PdfDocument.class);
            logger.warn("Full compression mode was requested to be switched off in append mode but the original document has cross-reference stream, not cross-reference table. Falling back to cross-reference stream in appended document and switching full compression on");
        }
        properties.isFullCompression = readerHasXrefStream;
    }

    private static boolean isXmpMetaHasProperty(XMPMeta xmpMeta, String schemaNS, String propName) throws XMPException {
        return xmpMeta.getProperty(schemaNS, propName) != null;
    }
}

