/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.events.PdfDocumentEvent;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.IPdfPageExtraCopier;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.MemoryLimitsAwareHandler;
import com.itextpdf.kernel.pdf.MemoryLimitsAwareOutputStream;
import com.itextpdf.kernel.pdf.PageLabelNumberingStyle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfOutline;
import com.itextpdf.kernel.pdf.PdfOutputIntent;
import com.itextpdf.kernel.pdf.PdfPages;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.kernel.xmp.options.SerializeOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfPage
extends PdfObjectWrapper<PdfDictionary> {
    private PdfResources resources = null;
    private int mcid = -1;
    PdfPages parentPages;
    private static final List<PdfName> PAGE_EXCLUDED_KEYS = new ArrayList<PdfName>(Arrays.asList(PdfName.Parent, PdfName.Annots, PdfName.StructParents, PdfName.B));
    private static final List<PdfName> XOBJECT_EXCLUDED_KEYS = new ArrayList<PdfName>(Arrays.asList(PdfName.MediaBox, PdfName.CropBox, PdfName.TrimBox, PdfName.Contents));
    private boolean ignorePageRotationForContent = false;
    private boolean pageRotationInverseMatrixWritten = false;

    protected PdfPage(PdfDictionary pdfObject) {
        super(pdfObject);
        this.setForbidRelease();
        PdfPage.ensureObjectIsAddedToDocument(pdfObject);
    }

    protected PdfPage(PdfDocument pdfDocument, PageSize pageSize) {
        this((PdfDictionary)new PdfDictionary().makeIndirect(pdfDocument));
        PdfStream contentStream = (PdfStream)new PdfStream().makeIndirect(pdfDocument);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Contents, contentStream);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Page);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.MediaBox, new PdfArray(pageSize));
        ((PdfDictionary)this.getPdfObject()).put(PdfName.TrimBox, new PdfArray(pageSize));
        if (pdfDocument.isTagged()) {
            this.setTabOrder(PdfName.S);
        }
    }

    protected PdfPage(PdfDocument pdfDocument) {
        this(pdfDocument, pdfDocument.getDefaultPageSize());
    }

    public Rectangle getPageSize() {
        return this.getMediaBox();
    }

    public Rectangle getPageSizeWithRotation() {
        PageSize rect = new PageSize(this.getPageSize());
        for (int rotation = this.getRotation(); rotation > 0; rotation -= 90) {
            rect = rect.rotate();
        }
        return rect;
    }

    public int getRotation() {
        PdfNumber rotate = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.Rotate);
        int rotateValue = 0;
        if (rotate == null) {
            rotate = (PdfNumber)this.getInheritedValue(PdfName.Rotate, 8);
        }
        if (rotate != null) {
            rotateValue = rotate.intValue();
        }
        return (rotateValue %= 360) < 0 ? rotateValue + 360 : rotateValue;
    }

    public PdfPage setRotation(int degAngle) {
        this.put(PdfName.Rotate, new PdfNumber(degAngle));
        return this;
    }

    public PdfStream getContentStream(int index) {
        int count = this.getContentStreamCount();
        if (index >= count || index < 0) {
            throw new IndexOutOfBoundsException(MessageFormatUtil.format("Index: {0}, Size: {1}", index, count));
        }
        PdfObject contents = ((PdfDictionary)this.getPdfObject()).get(PdfName.Contents);
        if (contents instanceof PdfStream) {
            return (PdfStream)contents;
        }
        if (contents instanceof PdfArray) {
            PdfArray a = (PdfArray)contents;
            return a.getAsStream(index);
        }
        return null;
    }

    public int getContentStreamCount() {
        PdfObject contents = ((PdfDictionary)this.getPdfObject()).get(PdfName.Contents);
        if (contents instanceof PdfStream) {
            return 1;
        }
        if (contents instanceof PdfArray) {
            return ((PdfArray)contents).size();
        }
        return 0;
    }

    public PdfStream getFirstContentStream() {
        if (this.getContentStreamCount() > 0) {
            return this.getContentStream(0);
        }
        return null;
    }

    public PdfStream getLastContentStream() {
        int count = this.getContentStreamCount();
        if (count > 0) {
            return this.getContentStream(count - 1);
        }
        return null;
    }

    public PdfStream newContentStreamBefore() {
        return this.newContentStream(true);
    }

    public PdfStream newContentStreamAfter() {
        return this.newContentStream(false);
    }

    public PdfResources getResources() {
        return this.getResources(true);
    }

    PdfResources getResources(boolean initResourcesField) {
        if (this.resources == null && initResourcesField) {
            this.initResources(true);
        }
        return this.resources;
    }

    PdfDictionary initResources(boolean initResourcesField) {
        boolean readOnly = false;
        PdfDictionary resources = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Resources);
        if (resources == null && (resources = (PdfDictionary)this.getInheritedValue(PdfName.Resources, 3)) != null) {
            readOnly = true;
        }
        if (resources == null) {
            resources = new PdfDictionary();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Resources, resources);
        }
        if (initResourcesField) {
            this.resources = new PdfResources(resources);
            this.resources.setReadOnly(readOnly);
        }
        return resources;
    }

    public PdfPage setResources(PdfResources pdfResources) {
        this.put(PdfName.Resources, (PdfObject)pdfResources.getPdfObject());
        this.resources = pdfResources;
        return this;
    }

    public PdfPage setXmpMetadata(byte[] xmpMetadata) throws IOException {
        PdfStream xmp = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        xmp.getOutputStream().write(xmpMetadata);
        xmp.put(PdfName.Type, PdfName.Metadata);
        xmp.put(PdfName.Subtype, PdfName.XML);
        this.put(PdfName.Metadata, xmp);
        return this;
    }

    public PdfPage setXmpMetadata(XMPMeta xmpMeta, SerializeOptions serializeOptions) throws XMPException, IOException {
        return this.setXmpMetadata(XMPMetaFactory.serializeToBuffer(xmpMeta, serializeOptions));
    }

    public PdfPage setXmpMetadata(XMPMeta xmpMeta) throws XMPException, IOException {
        SerializeOptions serializeOptions = new SerializeOptions();
        serializeOptions.setPadding(2000);
        return this.setXmpMetadata(xmpMeta, serializeOptions);
    }

    public PdfStream getXmpMetadata() {
        return ((PdfDictionary)this.getPdfObject()).getAsStream(PdfName.Metadata);
    }

    public PdfPage copyTo(PdfDocument toDocument) {
        return this.copyTo(toDocument, null);
    }

    public PdfPage copyTo(PdfDocument toDocument, IPdfPageExtraCopier copier) {
        PdfDictionary dictionary = ((PdfDictionary)this.getPdfObject()).copyTo(toDocument, PAGE_EXCLUDED_KEYS, true);
        PdfPage page = this.getDocument().getPageFactory().createPdfPage(dictionary);
        this.copyInheritedProperties(page, toDocument);
        for (PdfAnnotation annot : this.getAnnotations()) {
            if (PdfName.Link.equals(annot.getSubtype())) {
                this.getDocument().storeLinkAnnotation(page, (PdfLinkAnnotation)annot);
                continue;
            }
            PdfAnnotation newAnnot = PdfAnnotation.makeAnnotation(((PdfDictionary)annot.getPdfObject()).copyTo(toDocument, Arrays.asList(PdfName.P, PdfName.Parent), true));
            if (PdfName.Widget.equals(annot.getSubtype())) {
                this.rebuildFormFieldParent((PdfDictionary)annot.getPdfObject(), (PdfDictionary)newAnnot.getPdfObject(), toDocument);
            }
            page.addAnnotation(-1, newAnnot, false);
        }
        if (copier != null) {
            copier.copy(this, page);
        } else if (!toDocument.getWriter().isUserWarnedAboutAcroFormCopying && this.getDocument().hasAcroForm()) {
            Logger logger = LoggerFactory.getLogger(PdfPage.class);
            logger.warn("Source document has AcroForm dictionary. The pages you are going to copy may have FormFields, but they will not be copied, because you have not used any IPdfPageExtraCopier");
            toDocument.getWriter().isUserWarnedAboutAcroFormCopying = true;
        }
        return page;
    }

    public PdfFormXObject copyAsFormXObject(PdfDocument toDocument) throws IOException {
        PdfFormXObject xObject = new PdfFormXObject(this.getCropBox());
        for (PdfName key : ((PdfDictionary)this.getPdfObject()).keySet()) {
            if (XOBJECT_EXCLUDED_KEYS.contains(key)) continue;
            PdfObject obj = ((PdfDictionary)this.getPdfObject()).get(key);
            if (((PdfStream)xObject.getPdfObject()).containsKey(key)) continue;
            PdfObject copyObj = obj.copyTo(toDocument, false);
            ((PdfStream)xObject.getPdfObject()).put(key, copyObj);
        }
        ((PdfStream)xObject.getPdfObject()).getOutputStream().write(this.getContentBytes());
        if (!((PdfStream)xObject.getPdfObject()).containsKey(PdfName.Resources)) {
            PdfObject copyResource = ((PdfDictionary)this.getResources().getPdfObject()).copyTo(toDocument, true);
            ((PdfStream)xObject.getPdfObject()).put(PdfName.Resources, copyResource);
        }
        return xObject;
    }

    public PdfDocument getDocument() {
        if (((PdfDictionary)this.getPdfObject()).getIndirectReference() != null) {
            return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
        }
        return null;
    }

    @Override
    public void flush() {
        this.flush(false);
    }

    public void flush(boolean flushResourcesContentStreams) {
        PdfObject contentsObj;
        PdfStream thumb;
        PdfArray annots;
        if (this.isFlushed()) {
            return;
        }
        this.getDocument().dispatchEvent(new PdfDocumentEvent("EndPdfPage", this));
        if (this.getDocument().isTagged() && !this.getDocument().getStructTreeRoot().isFlushed()) {
            this.tryFlushPageTags();
        }
        if (this.resources == null) {
            this.initResources(false);
        } else if (this.resources.isModified() && !this.resources.isReadOnly()) {
            this.put(PdfName.Resources, (PdfObject)this.resources.getPdfObject());
        }
        if (flushResourcesContentStreams) {
            this.getDocument().checkIsoConformance(this, IsoKey.PAGE);
            this.flushResourcesContentStreams();
        }
        if ((annots = this.getAnnots(false)) != null && !annots.isFlushed()) {
            for (int i = 0; i < annots.size(); ++i) {
                PdfObject a = annots.get(i);
                if (a == null) continue;
                a.makeIndirect(this.getDocument()).flush();
            }
        }
        if ((thumb = ((PdfDictionary)this.getPdfObject()).getAsStream(PdfName.Thumb)) != null) {
            thumb.flush();
        }
        if ((contentsObj = ((PdfDictionary)this.getPdfObject()).get(PdfName.Contents)) != null && !contentsObj.isFlushed()) {
            int contentStreamCount = this.getContentStreamCount();
            for (int i = 0; i < contentStreamCount; ++i) {
                PdfStream contentStream = this.getContentStream(i);
                if (contentStream == null) continue;
                contentStream.flush(false);
            }
        }
        this.releaseInstanceFields();
        super.flush();
    }

    public Rectangle getMediaBox() {
        PdfArray mediaBox = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.MediaBox);
        if (mediaBox == null) {
            mediaBox = (PdfArray)this.getInheritedValue(PdfName.MediaBox, 1);
        }
        if (mediaBox == null) {
            throw new PdfException("Invalid PDF. There is no media box attribute for page or its parents.");
        }
        int mediaBoxSize = mediaBox.size();
        if (mediaBoxSize != 4) {
            Logger logger;
            if (mediaBoxSize > 4 && (logger = LoggerFactory.getLogger(PdfPage.class)).isErrorEnabled()) {
                logger.error(MessageFormatUtil.format("Wrong media box size: {0}. The arguments beyond the 4th will be ignored", mediaBoxSize));
            }
            if (mediaBoxSize < 4) {
                throw new PdfException("Wrong media box size: {0}. Need at least 4 arguments").setMessageParams(mediaBox.size());
            }
        }
        PdfNumber llx = mediaBox.getAsNumber(0);
        PdfNumber lly = mediaBox.getAsNumber(1);
        PdfNumber urx = mediaBox.getAsNumber(2);
        PdfNumber ury = mediaBox.getAsNumber(3);
        if (llx == null || lly == null || urx == null || ury == null) {
            throw new PdfException("Tne media box object has incorrect values.");
        }
        return new Rectangle(Math.min(llx.floatValue(), urx.floatValue()), Math.min(lly.floatValue(), ury.floatValue()), Math.abs(urx.floatValue() - llx.floatValue()), Math.abs(ury.floatValue() - lly.floatValue()));
    }

    public PdfPage setMediaBox(Rectangle rectangle) {
        this.put(PdfName.MediaBox, new PdfArray(rectangle));
        return this;
    }

    public Rectangle getCropBox() {
        PdfArray cropBox = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.CropBox);
        if (cropBox == null && (cropBox = (PdfArray)this.getInheritedValue(PdfName.CropBox, 1)) == null) {
            return this.getMediaBox();
        }
        return cropBox.toRectangle();
    }

    public PdfPage setCropBox(Rectangle rectangle) {
        this.put(PdfName.CropBox, new PdfArray(rectangle));
        return this;
    }

    public PdfPage setBleedBox(Rectangle rectangle) {
        this.put(PdfName.BleedBox, new PdfArray(rectangle));
        return this;
    }

    public Rectangle getBleedBox() {
        Rectangle bleedBox = ((PdfDictionary)this.getPdfObject()).getAsRectangle(PdfName.BleedBox);
        return bleedBox == null ? this.getCropBox() : bleedBox;
    }

    public PdfPage setArtBox(Rectangle rectangle) {
        if (((PdfDictionary)this.getPdfObject()).getAsRectangle(PdfName.TrimBox) != null) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.TrimBox);
            Logger logger = LoggerFactory.getLogger(PdfPage.class);
            logger.warn("Only one of artbox or trimbox can exist on the page. The trimbox will be deleted");
        }
        this.put(PdfName.ArtBox, new PdfArray(rectangle));
        return this;
    }

    public Rectangle getArtBox() {
        Rectangle artBox = ((PdfDictionary)this.getPdfObject()).getAsRectangle(PdfName.ArtBox);
        return artBox == null ? this.getCropBox() : artBox;
    }

    public PdfPage setTrimBox(Rectangle rectangle) {
        if (((PdfDictionary)this.getPdfObject()).getAsRectangle(PdfName.ArtBox) != null) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.ArtBox);
            Logger logger = LoggerFactory.getLogger(PdfPage.class);
            logger.warn("Only one of artbox or trimbox can exist on the page. The trimbox will be deleted");
        }
        this.put(PdfName.TrimBox, new PdfArray(rectangle));
        return this;
    }

    public Rectangle getTrimBox() {
        Rectangle trimBox = ((PdfDictionary)this.getPdfObject()).getAsRectangle(PdfName.TrimBox);
        return trimBox == null ? this.getCropBox() : trimBox;
    }

    public byte[] getContentBytes() {
        try {
            MemoryLimitsAwareHandler handler = this.getDocument().memoryLimitsAwareHandler;
            long usedMemory = null == handler ? -1L : handler.getAllMemoryUsedForDecompression();
            MemoryLimitsAwareOutputStream baos = new MemoryLimitsAwareOutputStream();
            int streamCount = this.getContentStreamCount();
            for (int i = 0; i < streamCount; ++i) {
                byte[] streamBytes = this.getStreamBytes(i);
                if (null != handler && usedMemory < handler.getAllMemoryUsedForDecompression()) {
                    baos.setMaxStreamSize(handler.getMaxSizeOfSingleDecompressedPdfStream());
                }
                baos.write(streamBytes);
                if (0 == streamBytes.length || Character.isWhitespace((char)streamBytes[streamBytes.length - 1])) continue;
                baos.write(10);
            }
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new PdfException("Cannot get content bytes.", ioe, this);
        }
    }

    public byte[] getStreamBytes(int index) {
        return this.getContentStream(index).getBytes();
    }

    public int getNextMcid() {
        if (!this.getDocument().isTagged()) {
            throw new PdfException("Must be a tagged document.");
        }
        if (this.mcid == -1) {
            PdfStructTreeRoot structTreeRoot = this.getDocument().getStructTreeRoot();
            this.mcid = structTreeRoot.getNextMcidForPage(this);
        }
        return this.mcid++;
    }

    public int getStructParentIndex() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.StructParents) != null ? ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.StructParents).intValue() : -1;
    }

    public PdfPage setAdditionalAction(PdfName key, PdfAction action) {
        PdfAction.setAdditionalAction(this, key, action);
        return this;
    }

    public List<PdfAnnotation> getAnnotations() {
        ArrayList<PdfAnnotation> annotations = new ArrayList<PdfAnnotation>();
        PdfArray annots = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Annots);
        if (annots != null) {
            for (int i = 0; i < annots.size(); ++i) {
                PdfAnnotation annotation;
                PdfDictionary annot = annots.getAsDictionary(i);
                if (annot == null || (annotation = PdfAnnotation.makeAnnotation(annot)) == null) continue;
                boolean hasBeenNotModified = annot.getIndirectReference() != null && !annot.getIndirectReference().checkState((short)8);
                annotations.add(annotation.setPage(this));
                if (!hasBeenNotModified) continue;
                annot.getIndirectReference().clearState((short)8);
                annot.clearState((short)128);
            }
        }
        return annotations;
    }

    public boolean containsAnnotation(PdfAnnotation annotation) {
        for (PdfAnnotation a : this.getAnnotations()) {
            if (!((PdfDictionary)a.getPdfObject()).equals(annotation.getPdfObject())) continue;
            return true;
        }
        return false;
    }

    public PdfPage addAnnotation(PdfAnnotation annotation) {
        return this.addAnnotation(-1, annotation, true);
    }

    public PdfPage addAnnotation(int index, PdfAnnotation annotation, boolean tagAnnotation) {
        if (this.getDocument().isTagged()) {
            if (tagAnnotation) {
                TagTreePointer tagPointer = this.getDocument().getTagStructureContext().getAutoTaggingPointer();
                PdfPage prevPage = tagPointer.getCurrentPage();
                tagPointer.setPageForTagging(this).addAnnotationTag(annotation);
                if (prevPage != null) {
                    tagPointer.setPageForTagging(prevPage);
                }
            }
            if (this.getTabOrder() == null) {
                this.setTabOrder(PdfName.S);
            }
        }
        PdfArray annots = this.getAnnots(true);
        if (index == -1) {
            annots.add((PdfObject)annotation.setPage(this).getPdfObject());
        } else {
            annots.add(index, (PdfObject)annotation.setPage(this).getPdfObject());
        }
        if (annots.getIndirectReference() == null) {
            this.setModified();
        } else {
            annots.setModified();
        }
        return this;
    }

    public PdfPage removeAnnotation(PdfAnnotation annotation) {
        TagTreePointer tagPointer;
        PdfArray annots = this.getAnnots(false);
        if (annots != null) {
            annots.remove((PdfObject)annotation.getPdfObject());
            if (annots.isEmpty()) {
                ((PdfDictionary)this.getPdfObject()).remove(PdfName.Annots);
                this.setModified();
            } else if (annots.getIndirectReference() == null) {
                this.setModified();
            }
        }
        if (this.getDocument().isTagged() && (tagPointer = this.getDocument().getTagStructureContext().removeAnnotationTag(annotation)) != null) {
            boolean standardAnnotTagRole;
            boolean bl = standardAnnotTagRole = "Annot".equals(tagPointer.getRole()) || "Form".equals(tagPointer.getRole());
            if (tagPointer.getKidsRoles().size() == 0 && standardAnnotTagRole) {
                tagPointer.removeTag();
            }
        }
        return this;
    }

    public int getAnnotsSize() {
        PdfArray annots = this.getAnnots(false);
        if (annots == null) {
            return 0;
        }
        return annots.size();
    }

    public List<PdfOutline> getOutlines(boolean updateOutlines) {
        this.getDocument().getOutlines(updateOutlines);
        return this.getDocument().getCatalog().getPagesWithOutlines().get(this.getPdfObject());
    }

    public boolean isIgnorePageRotationForContent() {
        return this.ignorePageRotationForContent;
    }

    public PdfPage setIgnorePageRotationForContent(boolean ignorePageRotationForContent) {
        this.ignorePageRotationForContent = ignorePageRotationForContent;
        return this;
    }

    public PdfPage setPageLabel(PageLabelNumberingStyle numberingStyle, String labelPrefix) {
        return this.setPageLabel(numberingStyle, labelPrefix, 1);
    }

    public PdfPage setPageLabel(PageLabelNumberingStyle numberingStyle, String labelPrefix, int firstPage) {
        if (firstPage < 1) {
            throw new PdfException("In a page label the page numbers must be greater or equal to 1.");
        }
        PdfDictionary pageLabel = new PdfDictionary();
        if (numberingStyle != null) {
            switch (numberingStyle) {
                case DECIMAL_ARABIC_NUMERALS: {
                    pageLabel.put(PdfName.S, PdfName.D);
                    break;
                }
                case UPPERCASE_ROMAN_NUMERALS: {
                    pageLabel.put(PdfName.S, PdfName.R);
                    break;
                }
                case LOWERCASE_ROMAN_NUMERALS: {
                    pageLabel.put(PdfName.S, PdfName.r);
                    break;
                }
                case UPPERCASE_LETTERS: {
                    pageLabel.put(PdfName.S, PdfName.A);
                    break;
                }
                case LOWERCASE_LETTERS: {
                    pageLabel.put(PdfName.S, PdfName.a);
                    break;
                }
            }
        }
        if (labelPrefix != null) {
            pageLabel.put(PdfName.P, new PdfString(labelPrefix));
        }
        if (firstPage != 1) {
            pageLabel.put(PdfName.St, new PdfNumber(firstPage));
        }
        this.getDocument().getCatalog().getPageLabelsTree(true).addEntry(this.getDocument().getPageNumber(this) - 1, pageLabel);
        return this;
    }

    public PdfPage setTabOrder(PdfName tabOrder) {
        this.put(PdfName.Tabs, tabOrder);
        return this;
    }

    public PdfName getTabOrder() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Tabs);
    }

    public PdfPage setThumbnailImage(PdfImageXObject thumb) {
        return this.put(PdfName.Thumb, (PdfObject)thumb.getPdfObject());
    }

    public PdfImageXObject getThumbnailImage() {
        PdfStream thumbStream = ((PdfDictionary)this.getPdfObject()).getAsStream(PdfName.Thumb);
        return thumbStream != null ? new PdfImageXObject(thumbStream) : null;
    }

    public PdfPage addOutputIntent(PdfOutputIntent outputIntent) {
        if (outputIntent == null) {
            return this;
        }
        PdfArray outputIntents = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.OutputIntents);
        if (outputIntents == null) {
            outputIntents = new PdfArray();
            this.put(PdfName.OutputIntents, outputIntents);
        }
        outputIntents.add((PdfObject)outputIntent.getPdfObject());
        return this;
    }

    public PdfPage put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        this.setModified();
        return this;
    }

    public boolean isPageRotationInverseMatrixWritten() {
        return this.pageRotationInverseMatrixWritten;
    }

    public void setPageRotationInverseMatrixWritten() {
        this.pageRotationInverseMatrixWritten = true;
    }

    public void addAssociatedFile(String description, PdfFileSpec fs) {
        PdfArray afArray;
        if (null == ((PdfDictionary)fs.getPdfObject()).get(PdfName.AFRelationship)) {
            Logger logger = LoggerFactory.getLogger(PdfPage.class);
            logger.error("For associated files their associated file specification dictionaries shall include the AFRelationship key.");
        }
        if (null != description) {
            this.getDocument().getCatalog().addNameToNameTree(description, (PdfObject)fs.getPdfObject(), PdfName.EmbeddedFiles);
        }
        if ((afArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.AF)) == null) {
            afArray = new PdfArray();
            this.put(PdfName.AF, afArray);
        }
        afArray.add((PdfObject)fs.getPdfObject());
    }

    public void addAssociatedFile(PdfFileSpec fs) {
        this.addAssociatedFile(null, fs);
    }

    public PdfArray getAssociatedFiles(boolean create) {
        PdfArray afArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.AF);
        if (afArray == null && create) {
            afArray = new PdfArray();
            this.put(PdfName.AF, afArray);
        }
        return afArray;
    }

    void tryFlushPageTags() {
        try {
            if (!this.getDocument().isClosing) {
                this.getDocument().getTagStructureContext().flushPageTags(this);
            }
            this.getDocument().getStructTreeRoot().savePageStructParentIndexIfNeeded(this);
        }
        catch (Exception ex) {
            throw new PdfException("Tag structure flushing failed: it might be corrupted.", ex);
        }
    }

    void releaseInstanceFields() {
        this.resources = null;
        this.parentPages = null;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private PdfArray getAnnots(boolean create) {
        PdfArray annots = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Annots);
        if (annots == null && create) {
            annots = new PdfArray();
            this.put(PdfName.Annots, annots);
        }
        return annots;
    }

    private PdfObject getInheritedValue(PdfName pdfName, int type) {
        PdfObject val;
        if (this.parentPages == null) {
            this.parentPages = this.getDocument().getCatalog().getPageTree().findPageParent(this);
        }
        return (val = PdfPage.getInheritedValue(this.parentPages, pdfName)) != null && val.getType() == type ? val : null;
    }

    private static PdfObject getInheritedValue(PdfPages parentPages, PdfName pdfName) {
        if (parentPages != null) {
            PdfDictionary parentDictionary = (PdfDictionary)parentPages.getPdfObject();
            PdfObject value = parentDictionary.get(pdfName);
            if (value != null) {
                return value;
            }
            return PdfPage.getInheritedValue(parentPages.getParent(), pdfName);
        }
        return null;
    }

    private PdfStream newContentStream(boolean before) {
        PdfArray array;
        PdfObject contents = ((PdfDictionary)this.getPdfObject()).get(PdfName.Contents);
        if (contents instanceof PdfStream) {
            array = new PdfArray();
            if (contents.getIndirectReference() != null) {
                array.add(contents.getIndirectReference());
            } else {
                array.add(contents);
            }
            this.put(PdfName.Contents, array);
        } else {
            array = contents instanceof PdfArray ? (PdfArray)contents : null;
        }
        PdfStream contentStream = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        if (array != null) {
            if (before) {
                array.add(0, contentStream);
            } else {
                array.add(contentStream);
            }
            if (array.getIndirectReference() != null) {
                array.setModified();
            } else {
                this.setModified();
            }
        } else {
            this.put(PdfName.Contents, contentStream);
        }
        return contentStream;
    }

    private void flushResourcesContentStreams() {
        this.flushResourcesContentStreams((PdfDictionary)this.getResources().getPdfObject());
        PdfArray annots = this.getAnnots(false);
        if (annots != null && !annots.isFlushed()) {
            for (int i = 0; i < annots.size(); ++i) {
                PdfDictionary apDict = annots.getAsDictionary(i).getAsDictionary(PdfName.AP);
                if (apDict == null) continue;
                this.flushAppearanceStreams(apDict);
            }
        }
    }

    private void flushResourcesContentStreams(PdfDictionary resources) {
        if (resources != null && !resources.isFlushed()) {
            this.flushWithResources(resources.getAsDictionary(PdfName.XObject));
            this.flushWithResources(resources.getAsDictionary(PdfName.Pattern));
            this.flushWithResources(resources.getAsDictionary(PdfName.Shading));
        }
    }

    private void flushWithResources(PdfDictionary objsCollection) {
        if (objsCollection == null || objsCollection.isFlushed()) {
            return;
        }
        for (PdfObject obj : objsCollection.values()) {
            if (obj.isFlushed()) continue;
            this.flushResourcesContentStreams(((PdfDictionary)obj).getAsDictionary(PdfName.Resources));
            this.flushMustBeIndirectObject(obj);
        }
    }

    private void flushAppearanceStreams(PdfDictionary appearanceStreamsDict) {
        if (appearanceStreamsDict.isFlushed()) {
            return;
        }
        for (PdfObject val : appearanceStreamsDict.values()) {
            if (!(val instanceof PdfDictionary)) continue;
            PdfDictionary ap = (PdfDictionary)val;
            if (ap.isDictionary()) {
                this.flushAppearanceStreams(ap);
                continue;
            }
            if (!ap.isStream()) continue;
            this.flushMustBeIndirectObject(ap);
        }
    }

    private void flushMustBeIndirectObject(PdfObject obj) {
        obj.makeIndirect(this.getDocument()).flush();
    }

    private void copyInheritedProperties(PdfPage copyPdfPage, PdfDocument pdfDocument) {
        PdfNumber rotate;
        PdfArray cropBox;
        if (((PdfDictionary)copyPdfPage.getPdfObject()).get(PdfName.Resources) == null) {
            PdfObject copyResource = pdfDocument.getWriter().copyObject((PdfObject)this.getResources().getPdfObject(), pdfDocument, false);
            ((PdfDictionary)copyPdfPage.getPdfObject()).put(PdfName.Resources, copyResource);
        }
        if (((PdfDictionary)copyPdfPage.getPdfObject()).get(PdfName.MediaBox) == null) {
            copyPdfPage.setMediaBox(this.getMediaBox());
        }
        if (((PdfDictionary)copyPdfPage.getPdfObject()).get(PdfName.CropBox) == null && (cropBox = (PdfArray)this.getInheritedValue(PdfName.CropBox, 1)) != null) {
            copyPdfPage.put(PdfName.CropBox, cropBox.copyTo(pdfDocument));
        }
        if (((PdfDictionary)copyPdfPage.getPdfObject()).get(PdfName.Rotate) == null && (rotate = (PdfNumber)this.getInheritedValue(PdfName.Rotate, 8)) != null) {
            copyPdfPage.put(PdfName.Rotate, rotate.copyTo(pdfDocument));
        }
    }

    private void rebuildFormFieldParent(PdfDictionary field, PdfDictionary newField, PdfDocument toDocument) {
        if (newField.containsKey(PdfName.Parent)) {
            return;
        }
        PdfDictionary oldParent = field.getAsDictionary(PdfName.Parent);
        if (oldParent != null) {
            PdfDictionary newParent = oldParent.copyTo(toDocument, Arrays.asList(PdfName.P, PdfName.Kids, PdfName.Parent), false);
            if (newParent.isFlushed()) {
                newParent = oldParent.copyTo(toDocument, Arrays.asList(PdfName.P, PdfName.Kids, PdfName.Parent), true);
            }
            this.rebuildFormFieldParent(oldParent, newParent, toDocument);
            PdfArray kids = newParent.getAsArray(PdfName.Kids);
            if (kids == null) {
                newParent.put(PdfName.Kids, new PdfArray());
            }
            newField.put(PdfName.Parent, newParent);
        }
    }

    static {
        XOBJECT_EXCLUDED_KEYS.addAll(PAGE_EXCLUDED_KEYS);
    }
}

