/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.kernel.pdf.CountOutputStream;
import com.itextpdf.kernel.pdf.EncryptionProperties;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfEncryption;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectStream;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfPrimitiveObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.PdfXrefTable;
import com.itextpdf.kernel.pdf.SerializedObjectContent;
import com.itextpdf.kernel.pdf.SmartModePdfObjectsSerializer;
import com.itextpdf.kernel.pdf.WriterProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfWriter
extends PdfOutputStream {
    private static final byte[] obj = ByteUtils.getIsoBytes(" obj\n");
    private static final byte[] endobj = ByteUtils.getIsoBytes("\nendobj\n");
    protected WriterProperties properties;
    PdfObjectStream objectStream = null;
    private Map<PdfIndirectReference, PdfIndirectReference> copiedObjects = new LinkedHashMap<PdfIndirectReference, PdfIndirectReference>();
    private SmartModePdfObjectsSerializer smartModeSerializer = new SmartModePdfObjectsSerializer();
    protected boolean isUserWarnedAboutAcroFormCopying;

    public PdfWriter(File file) throws FileNotFoundException {
        this(file.getAbsolutePath());
    }

    public PdfWriter(OutputStream os) {
        this(os, new WriterProperties());
    }

    public PdfWriter(OutputStream os, WriterProperties properties) {
        super(new CountOutputStream(FileUtil.wrapWithBufferedOutputStream(os)));
        this.properties = properties;
    }

    public PdfWriter(String filename) throws FileNotFoundException {
        this(filename, new WriterProperties());
    }

    public PdfWriter(String filename, WriterProperties properties) throws FileNotFoundException {
        this(FileUtil.getBufferedOutputStream(filename), properties);
    }

    public boolean isFullCompression() {
        return this.properties.isFullCompression != null ? this.properties.isFullCompression : false;
    }

    public int getCompressionLevel() {
        return this.properties.compressionLevel;
    }

    public PdfWriter setCompressionLevel(int compressionLevel) {
        this.properties.setCompressionLevel(compressionLevel);
        return this;
    }

    public PdfWriter setSmartMode(boolean smartMode) {
        this.properties.smartMode = smartMode;
        return this;
    }

    PdfObjectStream getObjectStream() {
        if (!this.isFullCompression()) {
            return null;
        }
        if (this.objectStream == null) {
            this.objectStream = new PdfObjectStream(this.document);
        } else if (this.objectStream.getSize() == 200) {
            this.objectStream.flush();
            this.objectStream = new PdfObjectStream(this.objectStream);
        }
        return this.objectStream;
    }

    protected void initCryptoIfSpecified(PdfVersion version) {
        EncryptionProperties encryptProps = this.properties.encryptionProperties;
        if (this.properties.isStandardEncryptionUsed()) {
            this.crypto = new PdfEncryption(encryptProps.userPassword, encryptProps.ownerPassword, encryptProps.standardEncryptPermissions, encryptProps.encryptionAlgorithm, ByteUtils.getIsoBytes(this.document.getOriginalDocumentId().getValue()), version);
        } else if (this.properties.isPublicKeyEncryptionUsed()) {
            this.crypto = new PdfEncryption(encryptProps.publicCertificates, encryptProps.publicKeyEncryptPermissions, encryptProps.encryptionAlgorithm, version);
        }
    }

    protected void flushObject(PdfObject pdfObject, boolean canBeInObjStm) {
        PdfIndirectReference indirectReference = pdfObject.getIndirectReference();
        if (this.isFullCompression() && canBeInObjStm) {
            PdfObjectStream objectStream = this.getObjectStream();
            objectStream.addObject(pdfObject);
        } else {
            indirectReference.setOffset(this.getCurrentPos());
            this.writeToBody(pdfObject);
        }
        indirectReference.setState((short)1).clearState((short)32);
        switch (pdfObject.getType()) {
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                ((PdfPrimitiveObject)pdfObject).content = null;
                break;
            }
            case 1: {
                PdfArray array = (PdfArray)pdfObject;
                this.markArrayContentToFlush(array);
                array.releaseContent();
                break;
            }
            case 3: 
            case 9: {
                PdfDictionary dictionary = (PdfDictionary)pdfObject;
                this.markDictionaryContentToFlush(dictionary);
                dictionary.releaseContent();
                break;
            }
            case 5: {
                this.markObjectToFlush(((PdfIndirectReference)pdfObject).getRefersTo(false));
            }
        }
    }

    protected PdfObject copyObject(PdfObject obj, PdfDocument documentTo, boolean allowDuplicating) {
        PdfIndirectReference objectRef;
        PdfIndirectReference copiedIndirectReference;
        boolean tryToFindDuplicate;
        if (obj instanceof PdfIndirectReference) {
            obj = ((PdfIndirectReference)obj).getRefersTo();
        }
        if (obj == null) {
            obj = PdfNull.PDF_NULL;
        }
        if (PdfWriter.checkTypeOfPdfDictionary(obj, PdfName.Catalog)) {
            Logger logger = LoggerFactory.getLogger(PdfReader.class);
            logger.warn("Make copy of Catalog dictionary is forbidden.");
            obj = PdfNull.PDF_NULL;
        }
        PdfIndirectReference indirectReference = obj.getIndirectReference();
        boolean bl = tryToFindDuplicate = !allowDuplicating && indirectReference != null;
        if (tryToFindDuplicate && (copiedIndirectReference = this.copiedObjects.get(indirectReference)) != null) {
            return copiedIndirectReference.getRefersTo();
        }
        SerializedObjectContent serializedContent = null;
        if (this.properties.smartMode && tryToFindDuplicate && !PdfWriter.checkTypeOfPdfDictionary(obj, PdfName.Page) && (objectRef = this.smartModeSerializer.getSavedSerializedObject(serializedContent = this.smartModeSerializer.serializeObject(obj))) != null) {
            this.copiedObjects.put(indirectReference, objectRef);
            return objectRef.refersTo;
        }
        PdfObject newObject = obj.newInstance();
        if (indirectReference != null) {
            PdfIndirectReference indRef = newObject.makeIndirect(documentTo).getIndirectReference();
            if (serializedContent != null) {
                this.smartModeSerializer.saveSerializedObject(serializedContent, indRef);
            }
            this.copiedObjects.put(indirectReference, indRef);
        }
        newObject.copyContent(obj, documentTo);
        return newObject;
    }

    protected void writeToBody(PdfObject pdfObj) {
        if (this.crypto != null) {
            this.crypto.setHashKeyForNextObject(pdfObj.getIndirectReference().getObjNumber(), pdfObj.getIndirectReference().getGenNumber());
        }
        ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)this.writeInteger(pdfObj.getIndirectReference().getObjNumber())).writeSpace()).writeInteger(pdfObj.getIndirectReference().getGenNumber())).writeBytes(obj);
        this.write(pdfObj);
        this.writeBytes(endobj);
    }

    protected void writeHeader() {
        ((PdfOutputStream)((PdfOutputStream)this.writeByte(37)).writeString(this.document.getPdfVersion().toString())).writeString("\n%\u00e2\u00e3\u00cf\u00d3\n");
    }

    protected void flushWaitingObjects(Set<PdfIndirectReference> forbiddenToFlush) {
        PdfXrefTable xref = this.document.getXref();
        boolean needFlush = true;
        while (needFlush) {
            needFlush = false;
            for (int i = 1; i < xref.size(); ++i) {
                PdfObject obj;
                PdfIndirectReference indirectReference = xref.get(i);
                if (indirectReference == null || indirectReference.isFree() || !indirectReference.checkState((short)32) || forbiddenToFlush.contains(indirectReference) || (obj = indirectReference.getRefersTo(false)) == null) continue;
                obj.flush();
                needFlush = true;
            }
        }
        if (this.objectStream != null && this.objectStream.getSize() > 0) {
            this.objectStream.flush();
            this.objectStream = null;
        }
    }

    protected void flushModifiedWaitingObjects(Set<PdfIndirectReference> forbiddenToFlush) {
        PdfXrefTable xref = this.document.getXref();
        for (int i = 1; i < xref.size(); ++i) {
            PdfObject obj;
            boolean isModified;
            PdfIndirectReference indirectReference = xref.get(i);
            if (null == indirectReference || indirectReference.isFree() || forbiddenToFlush.contains(indirectReference) || !(isModified = indirectReference.checkState((short)8)) || (obj = indirectReference.getRefersTo(false)) == null || obj.equals(this.objectStream)) continue;
            obj.flush();
        }
        if (this.objectStream != null && this.objectStream.getSize() > 0) {
            this.objectStream.flush();
            this.objectStream = null;
        }
    }

    void flushCopiedObjects(long docId) {
        ArrayList<PdfIndirectReference> remove = new ArrayList<PdfIndirectReference>();
        for (Map.Entry<PdfIndirectReference, PdfIndirectReference> copiedObject : this.copiedObjects.entrySet()) {
            PdfDocument document = copiedObject.getKey().getDocument();
            if (document == null || document.getDocumentId() != docId || copiedObject.getValue().refersTo == null) continue;
            copiedObject.getValue().refersTo.flush();
            remove.add(copiedObject.getKey());
        }
        for (PdfIndirectReference ird : remove) {
            this.copiedObjects.remove(ird);
        }
    }

    private void markArrayContentToFlush(PdfArray array) {
        for (int i = 0; i < array.size(); ++i) {
            this.markObjectToFlush(array.get(i, false));
        }
    }

    private void markDictionaryContentToFlush(PdfDictionary dictionary) {
        for (PdfObject item : dictionary.values(false)) {
            this.markObjectToFlush(item);
        }
    }

    private void markObjectToFlush(PdfObject pdfObject) {
        if (pdfObject != null) {
            PdfIndirectReference indirectReference = pdfObject.getIndirectReference();
            if (indirectReference != null) {
                if (!indirectReference.checkState((short)1)) {
                    indirectReference.setState((short)32);
                }
            } else if (pdfObject.getType() == 5) {
                if (!pdfObject.checkState((short)1)) {
                    pdfObject.setState((short)32);
                }
            } else if (pdfObject.getType() == 1) {
                this.markArrayContentToFlush((PdfArray)pdfObject);
            } else if (pdfObject.getType() == 3) {
                this.markDictionaryContentToFlush((PdfDictionary)pdfObject);
            }
        }
    }

    private static boolean checkTypeOfPdfDictionary(PdfObject dictionary, PdfName expectedType) {
        return dictionary.isDictionary() && expectedType.equals(((PdfDictionary)dictionary).getAsName(PdfName.Type));
    }
}

