/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.actions.data.ProductData;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.kernel.actions.data.ITextCoreProductData;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfXrefTable {
    private static final int INITIAL_CAPACITY = 32;
    private static final int MAX_GENERATION = 65535;
    private static final byte[] freeXRefEntry = ByteUtils.getIsoBytes("f \n");
    private static final byte[] inUseXRefEntry = ByteUtils.getIsoBytes("n \n");
    private PdfIndirectReference[] xref;
    private int count = 0;
    private boolean readingCompleted;
    private final TreeMap<Integer, PdfIndirectReference> freeReferencesLinkedList;

    public PdfXrefTable() {
        this(32);
    }

    public PdfXrefTable(int capacity) {
        if (capacity < 1) {
            capacity = 32;
        }
        this.xref = new PdfIndirectReference[capacity];
        this.freeReferencesLinkedList = new TreeMap();
        this.add((PdfIndirectReference)new PdfIndirectReference(null, 0, 65535, 0L).setState((short)2));
    }

    public PdfIndirectReference add(PdfIndirectReference reference) {
        if (reference == null) {
            return null;
        }
        int objNr = reference.getObjNumber();
        this.count = Math.max(this.count, objNr);
        this.ensureCount(objNr);
        this.xref[objNr] = reference;
        return reference;
    }

    public int size() {
        return this.count + 1;
    }

    public int getCountOfIndirectObjects() {
        int countOfIndirectObjects = 0;
        for (PdfIndirectReference ref : this.xref) {
            if (ref == null || ref.isFree()) continue;
            ++countOfIndirectObjects;
        }
        return countOfIndirectObjects;
    }

    public PdfIndirectReference get(int index) {
        if (index > this.count) {
            return null;
        }
        return this.xref[index];
    }

    void markReadingCompleted() {
        this.readingCompleted = true;
    }

    boolean isReadingCompleted() {
        return this.readingCompleted;
    }

    void initFreeReferencesList(PdfDocument pdfDocument) {
        this.freeReferencesLinkedList.clear();
        this.xref[0].setState((short)2);
        TreeSet<Integer> freeReferences = new TreeSet<Integer>();
        for (int i = 1; i < this.size(); ++i) {
            PdfIndirectReference ref = this.xref[i];
            if (ref != null && !ref.isFree()) continue;
            freeReferences.add(i);
        }
        PdfIndirectReference prevFreeRef = this.xref[0];
        while (!freeReferences.isEmpty()) {
            int currFreeRefObjNr = -1;
            if (prevFreeRef.getOffset() <= Integer.MAX_VALUE) {
                currFreeRefObjNr = (int)prevFreeRef.getOffset();
            }
            if (!freeReferences.contains(currFreeRefObjNr) || this.xref[currFreeRefObjNr] == null) break;
            this.freeReferencesLinkedList.put(currFreeRefObjNr, prevFreeRef);
            prevFreeRef = this.xref[currFreeRefObjNr];
            freeReferences.remove(currFreeRefObjNr);
        }
        while (!freeReferences.isEmpty()) {
            int next = (Integer)freeReferences.pollFirst();
            if (this.xref[next] == null) {
                if (pdfDocument.properties.appendMode) continue;
                this.xref[next] = (PdfIndirectReference)new PdfIndirectReference(pdfDocument, next, 0).setState((short)2).setState((short)8);
            } else if (this.xref[next].getGenNumber() == 65535 && this.xref[next].getOffset() == 0L) continue;
            if (prevFreeRef.getOffset() != (long)next) {
                ((PdfIndirectReference)prevFreeRef.setState((short)8)).setOffset(next);
            }
            this.freeReferencesLinkedList.put(next, prevFreeRef);
            prevFreeRef = this.xref[next];
        }
        if (prevFreeRef.getOffset() != 0L) {
            ((PdfIndirectReference)prevFreeRef.setState((short)8)).setOffset(0L);
        }
        this.freeReferencesLinkedList.put(0, prevFreeRef);
    }

    PdfIndirectReference createNewIndirectReference(PdfDocument document) {
        PdfIndirectReference reference = new PdfIndirectReference(document, ++this.count);
        this.add(reference);
        return (PdfIndirectReference)reference.setState((short)8);
    }

    protected PdfIndirectReference createNextIndirectReference(PdfDocument document) {
        PdfIndirectReference reference = new PdfIndirectReference(document, ++this.count);
        this.add(reference);
        return (PdfIndirectReference)reference.setState((short)8);
    }

    protected void freeReference(PdfIndirectReference reference) {
        if (reference.isFree()) {
            return;
        }
        if (reference.checkState((short)32)) {
            Logger logger = LoggerFactory.getLogger(PdfXrefTable.class);
            logger.error("An attempt is made to free an indirect reference which was already used in the flushed object. Indirect reference wasn't freed.");
            return;
        }
        if (reference.checkState((short)1)) {
            Logger logger = LoggerFactory.getLogger(PdfXrefTable.class);
            logger.error("An attempt is made to free already flushed indirect object reference. Indirect reference wasn't freed.");
            return;
        }
        reference.setState((short)2).setState((short)8);
        this.appendNewRefToFreeList(reference);
        if (reference.getGenNumber() < 65535) {
            ++reference.genNr;
        }
    }

    protected void setCapacity(int capacity) {
        if (capacity > this.xref.length) {
            this.extendXref(capacity);
        }
    }

    protected void writeXrefTableAndTrailer(PdfDocument document, PdfObject fileId, PdfObject crypto) throws IOException {
        boolean needsRegularXref;
        List<Integer> sections;
        boolean noModifiedObjects;
        PdfWriter writer = document.getWriter();
        if (!document.properties.appendMode) {
            PdfIndirectReference lastRef;
            for (int i = this.count; i > 0 && ((lastRef = this.xref[i]) == null || lastRef.isFree()); --i) {
                this.removeFreeRefFromList(i);
                --this.count;
            }
        }
        PdfStream xrefStream = null;
        if (writer.isFullCompression()) {
            xrefStream = new PdfStream();
            xrefStream.makeIndirect(document);
        }
        boolean bl = noModifiedObjects = (sections = this.createSections(document, false)).size() == 0 || xrefStream != null && sections.size() == 2 && sections.get(0) == this.count && sections.get(1) == 1;
        if (document.properties.appendMode && noModifiedObjects) {
            this.xref = null;
            return;
        }
        document.checkIsoConformance(this, IsoKey.XREF_TABLE);
        long startxref = writer.getCurrentPos();
        long xRefStmPos = -1L;
        if (xrefStream != null) {
            xrefStream.put(PdfName.Type, PdfName.XRef);
            xrefStream.put(PdfName.ID, fileId);
            if (crypto != null) {
                xrefStream.put(PdfName.Encrypt, crypto);
            }
            xrefStream.put(PdfName.Size, new PdfNumber(this.size()));
            int offsetSize = this.getOffsetSize(Math.max(startxref, (long)this.size()));
            xrefStream.put(PdfName.W, new PdfArray(Arrays.asList(new PdfNumber(1), new PdfNumber(offsetSize), new PdfNumber(2))));
            xrefStream.put(PdfName.Info, document.getDocumentInfo().getPdfObject());
            xrefStream.put(PdfName.Root, (PdfObject)document.getCatalog().getPdfObject());
            PdfArray index = new PdfArray();
            for (Integer section : sections) {
                index.add(new PdfNumber(section));
            }
            if (document.properties.appendMode && !document.reader.hybridXref) {
                PdfNumber lastXref = new PdfNumber(document.reader.getLastXref());
                xrefStream.put(PdfName.Prev, lastXref);
            }
            xrefStream.put(PdfName.Index, index);
            xrefStream.getIndirectReference().setOffset(startxref);
            PdfXrefTable xrefTable = document.getXref();
            for (int k = 0; k < sections.size(); k += 2) {
                int first = sections.get(k);
                int len = sections.get(k + 1);
                for (int i = first; i < first + len; ++i) {
                    PdfIndirectReference reference = xrefTable.get(i);
                    if (reference.isFree()) {
                        xrefStream.getOutputStream().write(0);
                        xrefStream.getOutputStream().write(reference.getOffset(), offsetSize);
                        xrefStream.getOutputStream().write(reference.getGenNumber(), 2);
                        continue;
                    }
                    if (reference.getObjStreamNumber() == 0) {
                        xrefStream.getOutputStream().write(1);
                        xrefStream.getOutputStream().write(reference.getOffset(), offsetSize);
                        xrefStream.getOutputStream().write(reference.getGenNumber(), 2);
                        continue;
                    }
                    xrefStream.getOutputStream().write(2);
                    xrefStream.getOutputStream().write(reference.getObjStreamNumber(), offsetSize);
                    xrefStream.getOutputStream().write(reference.getIndex(), 2);
                }
            }
            xrefStream.flush();
            xRefStmPos = startxref;
        }
        boolean bl2 = needsRegularXref = !writer.isFullCompression() || document.properties.appendMode && document.reader.hybridXref;
        if (needsRegularXref) {
            startxref = writer.getCurrentPos();
            writer.writeString("xref\n");
            PdfXrefTable xrefTable = document.getXref();
            if (xRefStmPos != -1L) {
                sections = this.createSections(document, true);
            }
            for (int k = 0; k < sections.size(); k += 2) {
                int first = sections.get(k);
                int len = sections.get(k + 1);
                ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)writer.writeInteger(first)).writeSpace()).writeInteger(len)).writeByte((byte)10);
                for (int i = first; i < first + len; ++i) {
                    PdfIndirectReference reference = xrefTable.get(i);
                    StringBuilder off = new StringBuilder("0000000000").append(reference.getOffset());
                    StringBuilder gen = new StringBuilder("00000").append(reference.getGenNumber());
                    ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)writer.writeString(off.substring(off.length() - 10, off.length()))).writeSpace()).writeString(gen.substring(gen.length() - 5, gen.length()))).writeSpace();
                    if (reference.isFree()) {
                        writer.writeBytes(freeXRefEntry);
                        continue;
                    }
                    writer.writeBytes(inUseXRefEntry);
                }
            }
            PdfDictionary trailer = document.getTrailer();
            trailer.remove(PdfName.W);
            trailer.remove(PdfName.Index);
            trailer.remove(PdfName.Type);
            trailer.remove(PdfName.Length);
            trailer.put(PdfName.Size, new PdfNumber(this.size()));
            trailer.put(PdfName.ID, fileId);
            if (xRefStmPos != -1L) {
                trailer.put(PdfName.XRefStm, new PdfNumber(xRefStmPos));
            }
            if (crypto != null) {
                trailer.put(PdfName.Encrypt, crypto);
            }
            writer.writeString("trailer\n");
            if (document.properties.appendMode) {
                PdfNumber lastXref = new PdfNumber(document.reader.getLastXref());
                trailer.put(PdfName.Prev, lastXref);
            }
            writer.write(document.getTrailer());
            writer.write(10);
        }
        PdfXrefTable.writeKeyInfo(document);
        ((PdfOutputStream)((PdfOutputStream)writer.writeString("startxref\n")).writeLong(startxref)).writeString("\n%%EOF\n");
        this.xref = null;
        this.freeReferencesLinkedList.clear();
    }

    void clear() {
        for (int i = 1; i <= this.count; ++i) {
            if (this.xref[i] != null && this.xref[i].isFree()) continue;
            this.xref[i] = null;
        }
        this.count = 1;
    }

    private List<Integer> createSections(PdfDocument document, boolean dropObjectsFromObjectStream) {
        ArrayList<Integer> sections = new ArrayList<Integer>();
        int first = 0;
        int len = 0;
        for (int i = 0; i < this.size(); ++i) {
            PdfIndirectReference reference = this.xref[i];
            if (document.properties.appendMode && reference != null && (!reference.checkState((short)8) || dropObjectsFromObjectStream && reference.getObjStreamNumber() != 0)) {
                reference = null;
            }
            if (reference == null) {
                if (len > 0) {
                    sections.add(first);
                    sections.add(len);
                }
                len = 0;
                continue;
            }
            if (len > 0) {
                ++len;
                continue;
            }
            first = i;
            len = 1;
        }
        if (len > 0) {
            sections.add(first);
            sections.add(len);
        }
        return sections;
    }

    private int getOffsetSize(long startxref) {
        int size;
        assert (startxref >= 0L && startxref < 0x10000000000L);
        long mask = 0xFF00000000L;
        for (size = 5; size > 1 && (mask & startxref) == 0L; --size) {
            mask >>= 8;
        }
        return size;
    }

    protected static void writeKeyInfo(PdfDocument document) {
        PdfWriter writer = document.getWriter();
        Collection<ProductData> products = document.getFingerPrint().getProducts();
        if (products.isEmpty()) {
            writer.writeString(MessageFormatUtil.format("%iText-{0}-no-registered-products\n", ITextCoreProductData.getInstance().getVersion()));
        } else {
            for (ProductData productData : products) {
                writer.writeString(MessageFormatUtil.format("%iText-{0}-{1}\n", productData.getPublicProductName(), productData.getVersion()));
            }
        }
    }

    private void appendNewRefToFreeList(PdfIndirectReference reference) {
        reference.setOffset(0L);
        if (this.freeReferencesLinkedList.isEmpty()) {
            assert (false);
            return;
        }
        PdfIndirectReference lastFreeRef = this.freeReferencesLinkedList.get(0);
        ((PdfIndirectReference)lastFreeRef.setState((short)8)).setOffset(reference.getObjNumber());
        this.freeReferencesLinkedList.put(reference.getObjNumber(), lastFreeRef);
        this.freeReferencesLinkedList.put(0, reference);
    }

    private PdfIndirectReference removeFreeRefFromList(int freeRefObjNr) {
        PdfIndirectReference freeRef;
        if (this.freeReferencesLinkedList.isEmpty()) {
            assert (false);
            return null;
        }
        if (freeRefObjNr == 0) {
            return null;
        }
        if (freeRefObjNr < 0) {
            Integer leastFreeRefObjNum = null;
            for (Map.Entry<Integer, PdfIndirectReference> entry : this.freeReferencesLinkedList.entrySet()) {
                if (entry.getKey() <= 0 || this.xref[entry.getKey()].getGenNumber() >= 65535) continue;
                leastFreeRefObjNum = entry.getKey();
                break;
            }
            if (leastFreeRefObjNum == null) {
                return null;
            }
            freeRefObjNr = leastFreeRefObjNum;
        }
        if (!(freeRef = this.xref[freeRefObjNr]).isFree()) {
            return null;
        }
        PdfIndirectReference prevFreeRef = this.freeReferencesLinkedList.remove(freeRef.getObjNumber());
        if (prevFreeRef != null) {
            this.freeReferencesLinkedList.put((int)freeRef.getOffset(), prevFreeRef);
            ((PdfIndirectReference)prevFreeRef.setState((short)8)).setOffset(freeRef.getOffset());
        }
        return freeRef;
    }

    private void ensureCount(int count) {
        if (count >= this.xref.length) {
            this.extendXref(count << 1);
        }
    }

    private void extendXref(int capacity) {
        PdfIndirectReference[] newXref = new PdfIndirectReference[capacity];
        System.arraycopy(this.xref, 0, newXref, 0, this.xref.length);
        this.xref = newXref;
    }
}

