/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups;

import com.itextpdf.kernel.actions.data.ITextCoreProductData;
import com.itextpdf.kernel.utils.CompareTool;
import com.itextpdf.rups.controller.RupsController;
import com.itextpdf.rups.view.icons.FrameIconUtil;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Rups {
    private RupsController controller = null;
    private volatile CompareTool.CompareResult lastCompareResult = null;

    protected Rups() {
    }

    protected void setController(RupsController controller) {
        this.controller = controller;
    }

    public static void startNewApplication(final File f, final int onCloseOperation) {
        final Rups rups = new Rups();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Rups.initFrameDim(frame);
                RupsController controller = new RupsController(frame.getSize(), frame, false);
                Rups.initApplication(frame, controller, onCloseOperation);
                rups.setController(controller);
                if (null != f && f.canRead()) {
                    rups.loadDocumentFromFile(f, false);
                }
            }
        });
    }

    public void loadDocumentFromFile(final File f, final boolean readOnly) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rups.this.controller.loadFile(f, readOnly);
            }
        });
    }

    static void initApplication(JFrame frame, RupsController controller, int onCloseOperation) {
        frame.setTitle("iText RUPS " + ITextCoreProductData.getInstance().getVersion());
        frame.setIconImages(FrameIconUtil.loadFrameIcons());
        frame.setDefaultCloseOperation(onCloseOperation);
        frame.setJMenuBar(controller.getMenuBar());
        frame.getContentPane().add(controller.getMasterComponent(), "Center");
        frame.setVisible(true);
    }

    static void initFrameDim(JFrame frame) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setSize((int)(screen.getWidth() * 0.9), (int)(screen.getHeight() * 0.9));
        frame.setLocation((int)(screen.getWidth() * 0.05), (int)(screen.getHeight() * 0.05));
        frame.setResizable(true);
    }
}

