/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.controller;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.utils.CompareTool;
import com.itextpdf.kernel.utils.objectpathitems.ArrayPathItem;
import com.itextpdf.kernel.utils.objectpathitems.DictPathItem;
import com.itextpdf.kernel.utils.objectpathitems.IndirectPathItem;
import com.itextpdf.kernel.utils.objectpathitems.LocalPathItem;
import com.itextpdf.kernel.utils.objectpathitems.ObjectPath;
import com.itextpdf.rups.event.NodeAddArrayChildEvent;
import com.itextpdf.rups.event.NodeAddDictChildEvent;
import com.itextpdf.rups.event.NodeDeleteArrayChildEvent;
import com.itextpdf.rups.event.NodeDeleteDictChildEvent;
import com.itextpdf.rups.event.OpenPlainTextEvent;
import com.itextpdf.rups.event.OpenStructureEvent;
import com.itextpdf.rups.event.RupsEvent;
import com.itextpdf.rups.io.listeners.PdfTreeNavigationListener;
import com.itextpdf.rups.model.ObjectLoader;
import com.itextpdf.rups.model.PdfSyntaxParser;
import com.itextpdf.rups.model.TreeNodeFactory;
import com.itextpdf.rups.view.DebugView;
import com.itextpdf.rups.view.PageSelectionListener;
import com.itextpdf.rups.view.contextmenu.PdfTreeContextMenu;
import com.itextpdf.rups.view.contextmenu.PdfTreeContextMenuMouseListener;
import com.itextpdf.rups.view.icons.IconTreeNode;
import com.itextpdf.rups.view.itext.FormTree;
import com.itextpdf.rups.view.itext.OutlineTree;
import com.itextpdf.rups.view.itext.PagesTable;
import com.itextpdf.rups.view.itext.PdfObjectPanel;
import com.itextpdf.rups.view.itext.PdfTree;
import com.itextpdf.rups.view.itext.PlainText;
import com.itextpdf.rups.view.itext.StructureTree;
import com.itextpdf.rups.view.itext.SyntaxHighlightedStreamPane;
import com.itextpdf.rups.view.itext.XRefTable;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import java.awt.Color;
import java.awt.event.KeyListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PdfReaderController
extends Observable
implements Observer {
    protected PdfTree pdfTree;
    protected JTabbedPane navigationTabs;
    protected PagesTable pages;
    protected OutlineTree outlines;
    protected StructureTree structure;
    protected FormTree form;
    protected XRefTable xref;
    protected PdfObjectPanel objectPanel;
    protected JTabbedPane editorTabs;
    protected SyntaxHighlightedStreamPane streamPane;
    protected TreeNodeFactory nodes;
    protected PlainText text;
    private Stack<IconTreeNode> highlights = new Stack();
    private PdfSyntaxParser parser = new PdfSyntaxParser();

    public PdfReaderController(TreeSelectionListener treeSelectionListener, PageSelectionListener pageSelectionListener, boolean pluginMode) {
        this.pdfTree = new PdfTree();
        this.pdfTree.addTreeSelectionListener(treeSelectionListener);
        JPopupMenu menu = PdfTreeContextMenu.getPopupMenu(this.pdfTree);
        this.pdfTree.setComponentPopupMenu(menu);
        this.pdfTree.addMouseListener(new PdfTreeContextMenuMouseListener(menu, this.pdfTree));
        this.addObserver(this.pdfTree);
        this.pages = new PagesTable(this, pageSelectionListener);
        this.addObserver(this.pages);
        this.outlines = new OutlineTree(this);
        this.addObserver(this.outlines);
        this.structure = new StructureTree(this);
        this.addObserver(this.structure);
        this.form = new FormTree(this);
        this.addObserver(this.form);
        this.xref = new XRefTable(this);
        this.addObserver(this.xref);
        this.text = new PlainText();
        this.addObserver(this.text);
        this.navigationTabs = new JTabbedPane();
        this.navigationTabs.addTab("Pages", null, new JScrollPane(this.pages), "Pages");
        this.navigationTabs.addTab("Outlines", null, new JScrollPane(this.outlines), "Outlines (Bookmarks)");
        this.navigationTabs.addTab("Structure", null, new JScrollPane(this.structure), "Structure tree");
        this.navigationTabs.addTab("Form", null, new JScrollPane(this.form), "Interactive Form");
        this.navigationTabs.addTab("XFA", null, new JScrollPane(this.form.getXfaTree()), "Tree view of the XFA form");
        this.navigationTabs.addTab("XRef", null, new JScrollPane(this.xref), "Cross-reference table");
        this.navigationTabs.addTab("PlainText", null, new JScrollPane(this.text), "Plain text representation of the PDF");
        this.navigationTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PdfReaderController.this.navigationTabs.getSelectedIndex() != -1) {
                    String title = PdfReaderController.this.navigationTabs.getTitleAt(PdfReaderController.this.navigationTabs.getSelectedIndex());
                    if ("Structure".equals(title)) {
                        PdfReaderController.this.structure.update(PdfReaderController.this, new OpenStructureEvent());
                    } else if ("PlainText".equals(title)) {
                        PdfReaderController.this.text.update(PdfReaderController.this, new OpenPlainTextEvent());
                    }
                }
            }
        });
        this.objectPanel = new PdfObjectPanel(pluginMode, this.parser);
        this.addObserver(this.objectPanel);
        this.objectPanel.addObserver(this);
        this.streamPane = new SyntaxHighlightedStreamPane(this, pluginMode);
        this.addObserver(this.streamPane);
        JScrollPane debug = new JScrollPane(DebugView.getInstance().getTextArea());
        this.editorTabs = new JTabbedPane();
        this.editorTabs.addTab("Stream", null, this.streamPane, "Stream");
        this.editorTabs.addTab("XFA", null, this.form.getXfaTextArea(), "XFA Form XML file");
        this.editorTabs.addTab("Debug info", null, debug, "Various debug-specific information");
    }

    public PdfTree getPdfTree() {
        return this.pdfTree;
    }

    public JTabbedPane getNavigationTabs() {
        return this.navigationTabs;
    }

    public JPanel getObjectPanel() {
        return this.objectPanel.getPanel();
    }

    public JTabbedPane getEditorTabs() {
        return this.editorTabs;
    }

    public SyntaxHighlightedStreamPane getStreamPane() {
        return this.streamPane;
    }

    public PdfSyntaxParser getParser() {
        return this.parser;
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (observable != null && obj instanceof RupsEvent) {
            RupsEvent event = (RupsEvent)obj;
            switch (event.getType()) {
                case 2: {
                    this.nodes = null;
                    this.setChanged();
                    super.notifyObservers(event);
                    break;
                }
                case 5: {
                    this.highlightChanges((CompareTool.CompareResult)event.getContent());
                    this.pdfTree.repaint();
                    break;
                }
                case 1: {
                    ObjectLoader loader = (ObjectLoader)event.getContent();
                    this.nodes = loader.getNodes();
                    PdfTrailerTreeNode root = this.pdfTree.getRoot();
                    root.setTrailer(loader.getFile().getPdfDocument().getTrailer());
                    root.setUserObject("PDF Object Tree (" + loader.getLoaderName() + ")");
                    this.nodes.expandNode(root);
                    this.navigationTabs.setSelectedIndex(0);
                    this.setChanged();
                    super.notifyObservers(event);
                    break;
                }
                case 7: {
                    PdfObjectTreeNode node = (PdfObjectTreeNode)event.getContent();
                    this.nodes.expandNode(node);
                    if (node.isRecursive()) {
                        KeyListener[] listeners;
                        boolean keyboardNav = false;
                        for (KeyListener listener : listeners = this.pdfTree.getKeyListeners()) {
                            if (!(listener instanceof PdfTreeNavigationListener)) continue;
                            keyboardNav = ((PdfTreeNavigationListener)listener).isLastActionKeyboardNavigation();
                        }
                        if (!keyboardNav) {
                            this.pdfTree.selectNode(node.getAncestor());
                            return;
                        }
                    }
                    this.render(node);
                    break;
                }
                case 12: {
                    this.deleteTreeNodeDictChild(((NodeDeleteDictChildEvent.Content)event.getContent()).parent, ((NodeDeleteDictChildEvent.Content)event.getContent()).key);
                    break;
                }
                case 11: {
                    this.addTreeNodeDictChild(((NodeAddDictChildEvent.Content)event.getContent()).parent, ((NodeAddDictChildEvent.Content)event.getContent()).key, ((NodeAddDictChildEvent.Content)event.getContent()).index);
                    break;
                }
                case 13: {
                    this.addTreeNodeArrayChild(((NodeAddArrayChildEvent.Content)event.getContent()).parent, ((NodeAddArrayChildEvent.Content)event.getContent()).index);
                    break;
                }
                case 14: {
                    this.deleteTreeChild(((NodeDeleteArrayChildEvent.Content)event.getContent()).parent, ((NodeDeleteArrayChildEvent.Content)event.getContent()).index);
                    break;
                }
                case 16: {
                    this.nodes.addNewIndirectObject((PdfObject)event.getContent());
                    this.setChanged();
                    this.notifyObservers(event);
                }
            }
        }
    }

    public void selectNode(PdfObjectTreeNode node) {
        this.pdfTree.clearSelection();
        this.pdfTree.selectNode(node);
    }

    public void selectNode(int objectNumber) {
        this.selectNode(this.nodes.getNode(objectNumber));
    }

    public void render(PdfObjectTreeNode node) {
        PdfObject object = node.getPdfObject();
        if (object instanceof PdfStream) {
            this.editorTabs.setSelectedComponent(this.streamPane);
        } else {
            this.editorTabs.setSelectedIndex(this.editorTabs.getComponentCount() - 1);
        }
        this.objectPanel.render(node, this.parser);
        this.streamPane.render(node);
    }

    public void gotoPage(int pageNumber) {
        if (this.pages == null || this.pages.getSelectedRow() == --pageNumber) {
            return;
        }
        if (pageNumber < this.pages.getRowCount()) {
            this.pages.setRowSelectionInterval(pageNumber, pageNumber);
        }
    }

    protected void highlightChanges(CompareTool.CompareResult compareResult) {
        this.clearHighlights();
        if (compareResult == null) {
            return;
        }
        for (ObjectPath path : compareResult.getDifferences().keySet()) {
            PdfObjectTreeNode currentNode;
            Stack<IndirectPathItem> indirectPath = path.getIndirectPath();
            while (!indirectPath.empty()) {
                IndirectPathItem indirectPathItem = indirectPath.pop();
                currentNode = this.nodes.getNode(indirectPathItem.getOutObject().getObjNumber());
                if (currentNode == null) continue;
                this.nodes.expandNode(currentNode);
            }
            Stack<LocalPathItem> localPath = path.getLocalPath();
            currentNode = this.nodes.getNode(path.getBaseOutObject().getObjNumber());
            while (!localPath.empty() && currentNode != null) {
                this.nodes.expandNode(currentNode);
                LocalPathItem item = localPath.pop();
                if (item instanceof DictPathItem) {
                    currentNode = this.nodes.getChildNode(currentNode, ((DictPathItem)item).getKey());
                    continue;
                }
                if (!(item instanceof ArrayPathItem)) continue;
                int index = ((ArrayPathItem)item).getIndex();
                currentNode = (PdfObjectTreeNode)currentNode.getChildAt(index);
            }
            if (currentNode == null) continue;
            this.pdfTree.expandPath(new TreePath(currentNode.getPath()));
            currentNode.setCustomTextColor(Color.ORANGE);
            this.highlights.add(currentNode);
        }
    }

    protected void clearHighlights() {
        while (!this.highlights.empty()) {
            this.highlights.pop().restoreDefaultTextColor();
        }
    }

    public int deleteTreeNodeDictChild(PdfObjectTreeNode parent, PdfName key) {
        PdfObjectTreeNode child = parent.getDictionaryChildNode(key);
        int index = parent.getIndex(child);
        return this.deleteTreeChild(parent, index);
    }

    public int addTreeNodeDictChild(PdfObjectTreeNode parent, PdfName key, int index) {
        PdfObjectTreeNode child = PdfObjectTreeNode.getInstance((PdfDictionary)parent.getPdfObject(), key);
        return this.addTreeNodeChild(parent, child, index);
    }

    public int addTreeNodeArrayChild(PdfObjectTreeNode parent, int index) {
        PdfObjectTreeNode child = PdfObjectTreeNode.getInstance(((PdfArray)parent.getPdfObject()).get(index, false));
        return this.addTreeNodeChild(parent, child, index);
    }

    public int deleteTreeChild(PdfObjectTreeNode parent, int index) {
        parent.remove(index);
        ((DefaultTreeModel)this.pdfTree.getModel()).reload(parent);
        return index;
    }

    public int addTreeNodeChild(PdfObjectTreeNode parent, PdfObjectTreeNode child, int index) {
        parent.insert(child, index);
        this.nodes.expandNode(child);
        ((DefaultTreeModel)this.pdfTree.getModel()).reload(parent);
        return index;
    }
}

