/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.controller;

import com.itextpdf.kernel.actions.data.ITextCoreProductData;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.utils.CompareTool;
import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.event.CloseDocumentEvent;
import com.itextpdf.rups.event.PostCompareEvent;
import com.itextpdf.rups.event.PostNewIndirectObjectEvent;
import com.itextpdf.rups.event.RootNodeClickedEvent;
import com.itextpdf.rups.event.RupsEvent;
import com.itextpdf.rups.event.TreeNodeClickedEvent;
import com.itextpdf.rups.model.LoggerHelper;
import com.itextpdf.rups.model.ObjectLoader;
import com.itextpdf.rups.model.PdfFile;
import com.itextpdf.rups.model.ProgressDialog;
import com.itextpdf.rups.view.Console;
import com.itextpdf.rups.view.NewIndirectPdfObjectDialog;
import com.itextpdf.rups.view.PageSelectionListener;
import com.itextpdf.rups.view.RupsMenuBar;
import com.itextpdf.rups.view.contextmenu.ConsoleContextMenu;
import com.itextpdf.rups.view.contextmenu.ContextMenuMouseListener;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class RupsController
extends Observable
implements TreeSelectionListener,
PageSelectionListener,
Observer {
    protected PdfFile pdfFile;
    protected StringBuilder rawText = new StringBuilder();
    protected PdfReaderController readerController;
    protected RupsMenuBar menuBar;
    protected JSplitPane masterComponent;
    protected JPanel masterPanel;
    protected JPanel treePanel;
    protected Frame ownedFrame;
    private boolean pluginMode;
    private ObjectLoader loader;

    public RupsController(Dimension dimension, Frame frame, boolean pluginMode) {
        this.pluginMode = pluginMode;
        this.ownedFrame = frame;
        this.menuBar = new RupsMenuBar(this);
        this.addObserver(this.menuBar);
        Console console = Console.getInstance();
        this.addObserver(console);
        console.addObserver(this);
        this.readerController = new PdfReaderController(this, this, pluginMode);
        this.addObserver(this.readerController);
        this.masterPanel = new JPanel(new BorderLayout());
        this.masterComponent = new JSplitPane();
        this.masterComponent.setOrientation(0);
        this.masterComponent.setDividerLocation((int)(dimension.getHeight() * 0.7));
        this.masterComponent.setDividerSize(2);
        JSplitPane content = new JSplitPane();
        this.masterComponent.add((Component)content, "top");
        JSplitPane info = new JSplitPane();
        this.masterComponent.add((Component)info, "bottom");
        content.setOrientation(1);
        content.setDividerLocation((int)(dimension.getWidth() * 0.6));
        content.setDividerSize(1);
        this.treePanel = new JPanel(new BorderLayout());
        this.treePanel.add((Component)new JScrollPane(this.readerController.getPdfTree()), "Center");
        content.add((Component)this.treePanel, "left");
        content.add((Component)this.readerController.getNavigationTabs(), "right");
        info.setDividerLocation((int)(dimension.getWidth() * 0.3));
        info.setDividerSize(1);
        info.add((Component)this.readerController.getObjectPanel(), "left");
        JTabbedPane editorPane = this.readerController.getEditorTabs();
        JScrollPane cons = new JScrollPane(console.getTextArea());
        console.getTextArea().addMouseListener(new ContextMenuMouseListener(ConsoleContextMenu.getPopupMenu(console.getTextArea()), console.getTextArea()));
        editorPane.addTab("Console", null, cons, "Console window (System.out/System.err)");
        editorPane.setSelectedComponent(cons);
        info.add((Component)editorPane, "right");
        if (!pluginMode) {
            this.masterComponent.setDropTarget(new DropTarget(){

                @Override
                public synchronized void drop(DropTargetDropEvent dtde) {
                    dtde.acceptDrop(1);
                    Transferable t = dtde.getTransferable();
                    LinkedList<File> files = null;
                    try {
                        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            files = (LinkedList<File>)t.getTransferData(DataFlavor.javaFileListFlavor);
                        }
                        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            String urls = (String)t.getTransferData(DataFlavor.stringFlavor);
                            files = new LinkedList<File>();
                            StringTokenizer tokens = new StringTokenizer(urls);
                            while (tokens.hasMoreTokens()) {
                                String urlString = tokens.nextToken();
                                URL url = new URL(urlString);
                                files.add(new File(URLDecoder.decode(url.getFile(), "UTF-8")));
                            }
                        }
                        if (files == null || files.size() != 1) {
                            JOptionPane.showMessageDialog(RupsController.this.masterComponent, "You can only open one file!", "Error", 0);
                        } else {
                            RupsController.this.loadFile((File)files.get(0), false);
                        }
                    }
                    catch (HeadlessException | UnsupportedFlavorException | IOException e) {
                        JOptionPane.showMessageDialog(RupsController.this.masterComponent, "Error opening file: " + e.getMessage(), "Error", 0);
                    }
                    dtde.dropComplete(true);
                }
            });
        }
        this.masterPanel.add((Component)this.masterComponent, "Center");
    }

    public RupsController(Dimension dimension, File f, Frame frame, boolean pluginMode) {
        this(dimension, frame, pluginMode);
        this.loadFile(f, false);
    }

    public RupsMenuBar getMenuBar() {
        return this.menuBar;
    }

    public Component getMasterComponent() {
        return this.masterPanel;
    }

    public Component getTreePanel() {
        return this.treePanel;
    }

    @Override
    public void update(Observable o, Object arg) {
        RupsEvent event;
        if (o == null && arg instanceof RupsEvent) {
            event = (RupsEvent)arg;
            switch (event.getType()) {
                case 2: {
                    this.closeRoutine();
                    break;
                }
                case 0: {
                    this.loadFile((File)event.getContent(), false);
                    break;
                }
                case 3: {
                    this.saveFile((File)event.getContent());
                    break;
                }
                case 4: {
                    this.highlightChanges(null);
                    CompareTool.CompareResult result = this.compareWithFile((File)event.getContent());
                    this.highlightChanges(result);
                    break;
                }
                case 1: {
                    this.setChanged();
                    super.notifyObservers(event);
                    break;
                }
                case 15: {
                    this.showNewIndirectDialog();
                }
            }
        }
        if (o != null && arg instanceof RupsEvent && 10 == (event = (RupsEvent)arg).getType()) {
            this.readerController.getEditorTabs().setSelectedIndex(this.readerController.getEditorTabs().getComponentCount() - 1);
        }
    }

    public void loadFile(File file, boolean readOnly) {
        try {
            byte[] contents = this.readFileToByteArray(file);
            this.loadRawContent(contents, file.getName(), file.getParentFile(), readOnly);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.masterComponent, ioe.getMessage(), "Dialog", 0);
        }
    }

    public void loadFileFromStream(InputStream is, String fileName, File directory, boolean readOnly) {
        try {
            byte[] contents = this.readStreamToByteArray(is);
            this.loadRawContent(contents, fileName, directory, readOnly);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.masterComponent, ioe.getMessage(), "Dialog", 0);
        }
    }

    public void loadRawContent(byte[] contents, String fileName, File directory, boolean readOnly) {
        this.closeRoutine();
        try {
            this.pdfFile = new PdfFile(contents, readOnly);
            this.pdfFile.setFilename(fileName);
            this.pdfFile.setDirectory(directory);
            this.startObjectLoader();
            if (!this.pluginMode) {
                String directoryPath = directory == null ? "" : directory.getCanonicalPath() + File.separator;
                this.ownedFrame.setTitle("iText RUPS - " + directoryPath + fileName + " - " + ITextCoreProductData.getInstance().getVersion());
            }
            this.readerController.getParser().setDocument(this.pdfFile.getPdfDocument());
        }
        catch (com.itextpdf.io.exceptions.IOException | PdfException | IOException ioe) {
            JOptionPane.showMessageDialog(this.masterComponent, ioe.getMessage(), "Dialog", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFileToByteArray(File file) throws IOException {
        byte[] res;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            res = this.readStreamToByteArray(inputStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                LoggerHelper.error("Can't close stream", (Exception)e, this.getClass());
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readStreamToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            int read;
            while ((read = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, read);
            }
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                LoggerHelper.error("Can't close stream", (Exception)e, this.getClass());
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File file) {
        FileOutputStream fos = null;
        try {
            int choice;
            if (!file.getName().endsWith(".pdf")) {
                file = new File(file.getPath() + ".pdf");
            }
            if (file.exists() && ((choice = JOptionPane.showConfirmDialog(this.masterComponent, "File already exists, would you like to overwrite file?", "Warning", 1)) == 1 || choice == 2)) {
                return;
            }
            ByteArrayOutputStream bos = this.pdfFile.getByteArrayOutputStream();
            this.pdfFile.getPdfDocument().setFlushUnusedObjects(false);
            this.closeRoutine();
            if (bos != null) {
                bos.close();
                fos = new FileOutputStream(file);
                bos.writeTo(fos);
            }
            JOptionPane.showMessageDialog(this.masterComponent, "File saved.", "Dialog", 1);
            this.loadFile(file, false);
        }
        catch (com.itextpdf.io.exceptions.IOException | PdfException | IOException de) {
            JOptionPane.showMessageDialog(this.masterComponent, de.getMessage(), "Dialog", 0);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LoggerHelper.error("Can't close stream", (Exception)e, this.getClass());
            }
        }
    }

    public void closeRoutine() {
        this.loader = null;
        PdfDocument docToClose = null;
        if (this.pdfFile != null && this.pdfFile.getPdfDocument() != null) {
            docToClose = this.pdfFile.getPdfDocument();
        }
        this.pdfFile = null;
        this.setChanged();
        super.notifyObservers(new CloseDocumentEvent());
        if (docToClose != null) {
            docToClose.close();
        }
        if (!this.pluginMode) {
            this.ownedFrame.setTitle("iText RUPS " + ITextCoreProductData.getInstance().getVersion());
        }
        this.readerController.getParser().setDocument(null);
    }

    public CompareTool.CompareResult compareWithDocument(PdfDocument document) {
        if (this.getPdfFile() == null || this.getPdfFile().getPdfDocument() == null) {
            LoggerHelper.warn("There is no open document. Nothing to compare with", this.getClass());
        } else if (document == null) {
            LoggerHelper.warn("Compared document is null", this.getClass());
        } else if (document.isClosed()) {
            LoggerHelper.warn("Compared document is closed", this.getClass());
        } else {
            CompareTool compareTool = new CompareTool().setCompareByContentErrorsLimit(100).disableCachedPagesComparison();
            return compareTool.compareByCatalog(this.getPdfFile().getPdfDocument(), document);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public CompareTool.CompareResult compareWithFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public CompareTool.CompareResult compareWithStream(InputStream is) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void highlightChanges(CompareTool.CompareResult compareResult) {
        this.readerController.update(this, new PostCompareEvent(compareResult));
        if (compareResult != null) {
            if (compareResult.isOk()) {
                LoggerHelper.info("Documents are equal", this.getClass());
            } else {
                LoggerHelper.info(compareResult.getReport(), this.getClass());
            }
        }
    }

    private void startObjectLoader() {
        final ProgressDialog dialog = new ProgressDialog(this.getMasterComponent(), "Reading PDF document...", this.ownedFrame, this.pluginMode);
        if (!this.pluginMode) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dialog.setVisible(true);
                }
            });
        }
        this.loader = new ObjectLoader(this, this.pdfFile, this.pdfFile.getFilename(), dialog);
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        Object selectednode = this.readerController.getPdfTree().getLastSelectedPathComponent();
        if (selectednode instanceof PdfTrailerTreeNode) {
            if (!this.pluginMode) {
                this.menuBar.update(this, new RootNodeClickedEvent());
            }
            this.readerController.getPdfTree().clearSelection();
            return;
        }
        if (selectednode instanceof PdfObjectTreeNode) {
            this.readerController.update(this, new TreeNodeClickedEvent((PdfObjectTreeNode)selectednode));
        }
    }

    @Override
    public int gotoPage(int pageNumber) {
        this.readerController.gotoPage(pageNumber);
        return pageNumber;
    }

    public PdfFile getPdfFile() {
        return this.pdfFile;
    }

    private void showNewIndirectDialog() {
        NewIndirectPdfObjectDialog dialog = new NewIndirectPdfObjectDialog(this.ownedFrame, "Create new indirect object", this.readerController.getParser());
        dialog.setVisible(true);
        if (dialog.getResult() != null) {
            this.setChanged();
            this.notifyObservers(new PostNewIndirectObjectEvent(dialog.getResult()));
        }
    }
}

