/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.swing.JTextArea;

public class TextAreaOutputStream
extends OutputStream {
    protected JTextArea text;

    public TextAreaOutputStream(JTextArea text) {
        this.text = text;
        this.clear();
    }

    public void clear() {
        this.text.setText("");
    }

    @Override
    public void write(int i) {
        byte[] b = new byte[]{(byte)i};
        this.write(b, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        String snippet = new String(b, off, len, StandardCharsets.UTF_8);
        this.text.append(snippet);
    }

    @Override
    public void write(byte[] b) throws IOException {
        int bytesread;
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        byte[] snippet = new byte[1024];
        while ((bytesread = bais.read(snippet)) > 0) {
            this.write(snippet, 0, bytesread);
        }
    }
}

