/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.model;

import com.itextpdf.io.util.IntHashtable;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.rups.model.LoggerHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class IndirectObjectFactory {
    protected PdfDocument document;
    protected int current;
    protected int n;
    protected ArrayList<PdfObject> objects = new ArrayList();
    protected IntHashtable idxToRef = new IntHashtable();
    protected IntHashtable refToIdx = new IntHashtable();
    protected ArrayList<Boolean> isLoaded = new ArrayList();
    private static final String METHOD_NAME = "checkState";
    private static final String FIELD_NAME = "FORBID_RELEASE";
    private static Method checkStateMethod;
    private static Field forbidReleaseField;

    public IndirectObjectFactory(PdfDocument document) {
        this.document = document;
        this.current = -1;
        this.n = document.getNumberOfPdfObjects();
    }

    public int getCurrent() {
        return this.current;
    }

    public int getXRefMaximum() {
        return this.n;
    }

    public boolean storeNextObject() {
        while (this.current < this.n) {
            ++this.current;
            PdfObject object = null;
            try {
                object = this.document.getPdfObject(this.current);
            }
            catch (PdfException ignored) {
                LoggerHelper.info("Attempt to read the object failed. The object number is: " + this.current, this.getClass());
            }
            if (object == null) continue;
            int idx = this.size();
            this.idxToRef.put(idx, this.current);
            this.refToIdx.put(this.current, idx);
            this.store(object);
            return true;
        }
        return false;
    }

    private void store(PdfObject object) {
        PdfDictionary dict;
        if (object.isDictionary() && PdfName.Page.equals((dict = (PdfDictionary)object).get(PdfName.Type, false))) {
            this.objects.add(dict);
            this.isLoaded.add(true);
            return;
        }
        this.isLoaded.add(object.isNull());
        if (this.canRelease(object)) {
            object.release();
            this.objects.add(PdfNull.PDF_NULL);
        } else {
            this.objects.add(object);
        }
    }

    public int size() {
        return this.objects.size();
    }

    public int getIndexByRef(int ref) {
        return this.refToIdx.get(ref);
    }

    public int getRefByIndex(int i) {
        return this.idxToRef.get(i);
    }

    public PdfObject getObjectByIndex(int i) {
        return this.getObjectByReference(this.getRefByIndex(i));
    }

    public PdfObject getObjectByReference(int ref) {
        return this.objects.get(this.getIndexByRef(ref));
    }

    public boolean isLoadedByIndex(int i) {
        return this.isLoaded.get(i);
    }

    public boolean isLoadedByReference(int ref) {
        return this.isLoaded.get(this.getIndexByRef(ref));
    }

    public PdfObject loadObjectByReference(int ref) {
        PdfObject object = this.getObjectByReference(ref);
        int idx = this.getIndexByRef(ref);
        if (object instanceof PdfNull && !this.isLoaded.get(idx).booleanValue()) {
            object = this.document.getPdfObject(ref);
            this.objects.set(idx, object);
            this.isLoaded.set(idx, true);
        }
        return object;
    }

    private boolean canRelease(PdfObject obj) {
        try {
            return (Boolean)checkStateMethod.invoke((Object)obj, forbidReleaseField.get(obj)) == false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException any) {
            return true;
        }
    }

    void addNewIndirectObject(PdfObject object) {
        object.makeIndirect(this.document);
        ++this.n;
        int idx = this.size();
        this.idxToRef.put(idx, object.getIndirectReference().getObjNumber());
        this.refToIdx.put(object.getIndirectReference().getObjNumber(), idx);
        this.objects.add(object);
        LoggerHelper.info("New indirect object was successfully created. Its object number is: " + object.getIndirectReference().getObjNumber(), this.getClass());
    }

    static {
        try {
            checkStateMethod = PdfObject.class.getDeclaredMethod(METHOD_NAME, Short.TYPE);
            checkStateMethod.setAccessible(true);
            forbidReleaseField = PdfObject.class.getDeclaredField(FIELD_NAME);
            forbidReleaseField.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }
}

