/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.model;

import com.itextpdf.rups.event.PostOpenDocumentEvent;
import com.itextpdf.rups.model.BackgroundTask;
import com.itextpdf.rups.model.ErrorDialogPane;
import com.itextpdf.rups.model.IndirectObjectFactory;
import com.itextpdf.rups.model.LoggerHelper;
import com.itextpdf.rups.model.PdfFile;
import com.itextpdf.rups.model.ProgressDialog;
import com.itextpdf.rups.model.TreeNodeFactory;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class ObjectLoader
extends BackgroundTask {
    protected Observer observer;
    protected PdfFile file;
    protected IndirectObjectFactory objects;
    protected TreeNodeFactory nodes;
    private String loaderName;
    private ProgressDialog progress;

    public ObjectLoader(Observer observer, PdfFile file, String loaderName, ProgressDialog progress) {
        this.observer = observer;
        this.file = file;
        this.loaderName = loaderName;
        this.progress = progress;
        this.start();
    }

    public PdfFile getFile() {
        return this.file;
    }

    public IndirectObjectFactory getObjects() {
        return this.objects;
    }

    public TreeNodeFactory getNodes() {
        return this.nodes;
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    @Override
    public void doTask() {
        this.objects = new IndirectObjectFactory(this.file.getPdfDocument());
        final int n = this.objects.getXRefMaximum();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ObjectLoader.this.progress.setMessage("Reading the Cross-Reference table");
                ObjectLoader.this.progress.setTotal(n);
            }
        });
        while (this.objects.storeNextObject()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ObjectLoader.this.progress.setValue(ObjectLoader.this.objects.getCurrent());
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ObjectLoader.this.progress.setTotal(0);
            }
        });
        this.nodes = new TreeNodeFactory(this.objects);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ObjectLoader.this.progress.setMessage("Updating GUI");
            }
        });
    }

    @Override
    public void finished() {
        try {
            this.observer.update(null, new PostOpenDocumentEvent(this));
        }
        catch (Exception ex) {
            ErrorDialogPane.showErrorDialog(this.progress, ex);
            LoggerHelper.error(ex.getLocalizedMessage(), ex, this.getClass());
        }
        this.progress.setVisible(false);
    }
}

