/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.model;

import com.ibm.icu.text.StringPrep;
import com.ibm.icu.text.StringPrepParseException;
import com.itextpdf.kernel.exceptions.BadPasswordException;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.ReaderProperties;
import com.itextpdf.rups.model.Permissions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class PdfFile {
    protected File directory = null;
    protected String filename = null;
    protected PdfDocument document = null;
    protected Permissions permissions = null;
    protected byte[] rawContent = null;
    protected ByteArrayOutputStream baos = null;
    protected boolean readOnly = false;
    public static final int MAX_PASSWORD_BYTE_LENGTH = 127;

    public PdfFile(File file) throws IOException, PdfException {
        if (file == null) {
            throw new IOException("No file selected.");
        }
        this.directory = file.getParentFile();
        this.filename = file.getName();
        try {
            this.readFile(new FileInputStream(file), false, this.readOnly);
        }
        catch (BadPasswordException bpe) {
            this.readFile(new FileInputStream(file), true, this.readOnly);
        }
    }

    public PdfFile(byte[] file, boolean readOnly) throws IOException, PdfException {
        this.rawContent = file;
        try {
            this.readFile(new ByteArrayInputStream(file), false, readOnly);
        }
        catch (BadPasswordException bpe) {
            this.readFile(new ByteArrayInputStream(file), true, readOnly);
        }
    }

    private static byte[] preparePasswordForOpen(String inputPassword) {
        String prepped;
        StringPrep prep = StringPrep.getInstance(10);
        try {
            prepped = prep.prepare(inputPassword, 1);
        }
        catch (StringPrepParseException e) {
            throw new PdfException("Failed to process password", e);
        }
        byte[] resultingBytes = prepped.getBytes(StandardCharsets.UTF_8);
        if (resultingBytes.length <= 127) {
            return resultingBytes;
        }
        byte[] trimmed = new byte[127];
        System.arraycopy(resultingBytes, 0, trimmed, 0, trimmed.length);
        return trimmed;
    }

    private static byte[] requestPassword() {
        final JPasswordField passwordField = new JPasswordField(32);
        JOptionPane pane = new JOptionPane((Object)passwordField, 3, 2){

            @Override
            public void selectInitialValue() {
                passwordField.requestFocusInWindow();
            }
        };
        pane.createDialog(null, "Enter the User or Owner Password of this PDF file").setVisible(true);
        String passwordString = new String(passwordField.getPassword());
        return PdfFile.preparePasswordForOpen(passwordString);
    }

    protected void readFile(InputStream fis, boolean checkPass, boolean readOnly) throws IOException, PdfException {
        byte[] password;
        this.permissions = new Permissions();
        ReaderProperties readerProps = new ReaderProperties();
        if (checkPass) {
            password = PdfFile.requestPassword();
            readerProps.setPassword(password);
        } else {
            password = null;
        }
        PdfReader reader = new PdfReader(fis, readerProps);
        this.baos = new ByteArrayOutputStream();
        if (readOnly) {
            this.document = new PdfDocument(reader);
        } else {
            PdfWriter writer = new PdfWriter(this.baos);
            this.document = new PdfDocument(reader, writer);
        }
        if (reader.isEncrypted()) {
            this.permissions.setEncrypted(true);
            this.permissions.setCryptoMode(reader.getCryptoMode());
            this.permissions.setPermissions((int)reader.getPermissions());
            if (password != null) {
                if (reader.isOpenedWithFullPermission()) {
                    this.permissions.setOwnerPassword(password);
                    this.permissions.setUserPassword(reader.computeUserPassword());
                } else {
                    JOptionPane.showMessageDialog(null, "You opened the document using the user password instead of the owner password.");
                }
            }
        } else {
            this.permissions.setEncrypted(false);
        }
    }

    public PdfDocument getPdfDocument() {
        return this.document;
    }

    public String getFilename() {
        return this.filename;
    }

    public File getDirectory() {
        return this.directory;
    }

    public String getRawContent() {
        try {
            return new String(this.rawContent, "Cp1252");
        }
        catch (UnsupportedEncodingException e) {
            return "Wrong Encoding";
        }
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        return this.baos;
    }
}

