/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.model;

import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.canvas.parser.util.PdfCanvasParser;
import com.itextpdf.rups.model.LoggerHelper;
import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class PdfSyntaxParser {
    private int openArraysCount = 0;
    private int openDictionaryCount = 0;
    private PdfDocument document;
    private boolean isValid = true;
    private List<PdfLiteral> unrecognizedChunks = new LinkedList<PdfLiteral>();

    public void setDocument(PdfDocument document) {
        this.document = document;
    }

    public PdfObject parseString(String s, Component requester) {
        return this.parseString(s, requester, false);
    }

    public PdfObject parseString(String s) {
        return this.parseString(s, null, true);
    }

    private PdfObject parseString(String s, Component requester, boolean failOnError) {
        PdfObject result;
        this.isValid = true;
        this.unrecognizedChunks.clear();
        this.openArraysCount = 0;
        this.openDictionaryCount = 0;
        byte[] bytesToParse = s.getBytes();
        RandomAccessSourceFactory factory = new RandomAccessSourceFactory();
        PdfTokenizer tokenizer = new PdfTokenizer(new RandomAccessFileOrArray(factory.createSource(bytesToParse)));
        UnderlineParser parser = new UnderlineParser(tokenizer);
        try {
            int input;
            result = parser.readObject();
            if (parser.nextValidToken()) {
                LoggerHelper.warn("The input string was truncated.", this.getClass());
            }
            if (this.openArraysCount != 0) {
                throw new RuntimeException("Incorrect sequence of array brackets");
            }
            if (this.openDictionaryCount != 0) {
                throw new RuntimeException("Incorrect sequence of dictionary brackets");
            }
            if (!this.isValid && ((input = JOptionPane.showConfirmDialog(requester, this.getUnknownValues() + "Do you want to keep those chunks as Literals?", "Unrecognized chunks in the input!", 0, 2)) != 0 || failOnError)) {
                result = null;
            }
        }
        catch (IOException | RuntimeException any) {
            LoggerHelper.warn("Error while parsing pdf syntax", any, this.getClass());
            result = null;
        }
        return result;
    }

    private String getUnknownValues() {
        StringBuilder builder = new StringBuilder();
        for (PdfLiteral literal : this.unrecognizedChunks) {
            builder.append(literal.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    private void addUnknownValue(PdfLiteral value) {
        LoggerHelper.warn("Unexpected chunk of pdf syntax : " + value, this.getClass());
        this.unrecognizedChunks.add(value);
        this.isValid = false;
    }

    private class UnderlineParser
    extends PdfCanvasParser {
        private PdfObject tempObject;

        public UnderlineParser(PdfTokenizer tokenizer) {
            super(tokenizer);
        }

        @Override
        public PdfObject readObject() throws IOException {
            this.tempObject = super.readObject();
            if (this.tempObject.getType() == 4) {
                PdfTokenizer.TokenType type = this.getTokeniser().getTokenType();
                switch (type) {
                    case StartArray: 
                    case EndArray: 
                    case StartDic: 
                    case EndDic: {
                        break;
                    }
                    case Ref: {
                        if (PdfSyntaxParser.this.document == null) {
                            throw new RuntimeException("Trying to edit references when no document was specified.");
                        }
                        return PdfSyntaxParser.this.document.getPdfObject(this.getTokeniser().getObjNr()).getIndirectReference();
                    }
                    default: {
                        if (this.getTokeniser().tokenValueEqualsTo(PdfTokenizer.Null)) {
                            return PdfNull.PDF_NULL;
                        }
                        if (this.getTokeniser().tokenValueEqualsTo(PdfTokenizer.True)) {
                            return PdfBoolean.TRUE;
                        }
                        if (this.getTokeniser().tokenValueEqualsTo(PdfTokenizer.False)) {
                            return new PdfBoolean(false);
                        }
                        PdfSyntaxParser.this.addUnknownValue((PdfLiteral)this.tempObject);
                    }
                }
            }
            return this.tempObject;
        }

        @Override
        public boolean nextValidToken() throws IOException {
            this.getTokeniser().nextValidToken();
            switch (this.getTokeniser().getTokenType()) {
                case StartArray: {
                    ++PdfSyntaxParser.this.openArraysCount;
                    break;
                }
                case EndArray: {
                    --PdfSyntaxParser.this.openArraysCount;
                    break;
                }
                case StartDic: {
                    ++PdfSyntaxParser.this.openDictionaryCount;
                    break;
                }
                case EndDic: {
                    --PdfSyntaxParser.this.openDictionaryCount;
                    break;
                }
                case Obj: 
                case EndObj: {
                    throw new RuntimeException((Object)((Object)this.getTokeniser().getTokenType()) + " - the chunk of this type not allowed here.");
                }
                case EndOfFile: {
                    return false;
                }
            }
            return true;
        }
    }
}

