/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.model;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;

public class PdfSyntaxUtils {
    public static synchronized String getSyntaxString(PdfObject object) {
        StringBuilder stringBuilder = new StringBuilder();
        PdfSyntaxUtils.safeAppendSyntaxString(object, stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendSyntaxString(PdfString string, StringBuilder stringBuilder) {
        stringBuilder.append("(").append(string.toUnicodeString()).append(")");
    }

    private static void appendSyntaxString(PdfIndirectReference reference, StringBuilder stringBuilder) {
        stringBuilder.append(reference.getObjNumber()).append(" ").append(reference.getGenNumber()).append(" R");
    }

    private static void appendSyntaxString(PdfArray array, StringBuilder stringBuilder) {
        stringBuilder.append("[ ");
        for (int i = 0; i < array.size(); ++i) {
            PdfSyntaxUtils.safeAppendSyntaxString(array.get(i, false), stringBuilder);
            stringBuilder.append(" ");
        }
        stringBuilder.append("]");
    }

    private static void appendSyntaxString(PdfDictionary dictionary, StringBuilder stringBuilder) {
        stringBuilder.append("<< ");
        for (PdfName key : dictionary.keySet()) {
            PdfSyntaxUtils.safeAppendSyntaxString(key, stringBuilder);
            stringBuilder.append(" ");
            PdfSyntaxUtils.safeAppendSyntaxString(dictionary.get(key, false), stringBuilder);
            stringBuilder.append(" ");
        }
        stringBuilder.append(">>");
    }

    private static void appendSyntaxString(PdfObject object, StringBuilder stringBuilder) {
        stringBuilder.append(object.toString());
    }

    private static void safeAppendSyntaxString(PdfObject object, StringBuilder stringBuilder) {
        if (object != null) {
            switch (object.getType()) {
                case 3: 
                case 9: {
                    PdfSyntaxUtils.appendSyntaxString((PdfDictionary)object, stringBuilder);
                    break;
                }
                case 1: {
                    PdfSyntaxUtils.appendSyntaxString((PdfArray)object, stringBuilder);
                    break;
                }
                case 10: {
                    PdfSyntaxUtils.appendSyntaxString((PdfString)object, stringBuilder);
                    break;
                }
                case 5: {
                    PdfSyntaxUtils.appendSyntaxString((PdfIndirectReference)object, stringBuilder);
                    break;
                }
                default: {
                    PdfSyntaxUtils.appendSyntaxString(object, stringBuilder);
                }
            }
        }
    }
}

