/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.model;

public class Permissions {
    protected boolean encrypted = true;
    protected byte[] ownerPassword = null;
    protected byte[] userPassword = null;
    protected int permissions = 0;
    protected int cryptoMode = 0;

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public byte[] getOwnerPassword() {
        return this.ownerPassword;
    }

    public void setOwnerPassword(byte[] ownerPassword) {
        this.ownerPassword = ownerPassword;
    }

    public byte[] getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(byte[] userPassword) {
        this.userPassword = userPassword;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public void setPermissions(int permissions) {
        this.permissions = permissions;
    }

    public int getCryptoMode() {
        return this.cryptoMode;
    }

    public void setCryptoMode(int cryptoMode) {
        this.cryptoMode = cryptoMode;
    }

    public boolean isAllowPrinting() {
        if (!this.encrypted) {
            return true;
        }
        return (0x804 & this.permissions) == 2052;
    }

    public boolean isAllowModifyContents(boolean decrypted) {
        if (!this.encrypted) {
            return true;
        }
        return (8 & this.permissions) == 8;
    }

    public boolean isAllowCopy(boolean decrypted) {
        if (!this.encrypted) {
            return true;
        }
        return (0x10 & this.permissions) == 16;
    }

    public boolean isAllowModifyAnnotations() {
        if (!this.encrypted) {
            return true;
        }
        return (0x20 & this.permissions) == 32;
    }

    public boolean isAllowFillIn() {
        if (!this.encrypted) {
            return true;
        }
        return (0x100 & this.permissions) == 256;
    }

    public boolean isAllowScreenReaders() {
        if (!this.encrypted) {
            return true;
        }
        return (0x200 & this.permissions) == 512;
    }

    public boolean isAllowAssembly() {
        if (!this.encrypted) {
            return true;
        }
        return (0x400 & this.permissions) == 1024;
    }

    public boolean isAllowDegradedPrinting() {
        if (!this.encrypted) {
            return true;
        }
        return (4 & this.permissions) == 4;
    }
}

