/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.model;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class ProgressDialog
extends JDialog {
    protected JLabel message;
    protected JProgressBar progress;
    public static final JLabel INFO = new JLabel(UIManager.getIcon("OptionPane.informationIcon"));
    private boolean pluginMode;

    public ProgressDialog(Component parent, String msg, Frame frame, boolean pluginMode) {
        super(frame, !pluginMode);
        this.pluginMode = pluginMode;
        this.setTitle("Progress...");
        this.setDefaultCloseOperation(2);
        this.setSize(300, 100);
        this.setLocationRelativeTo(parent);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 2;
        this.getContentPane().add((Component)INFO, constraints);
        constraints.gridheight = 1;
        constraints.gridx = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.message = new JLabel(msg);
        this.getContentPane().add((Component)this.message, constraints);
        constraints.gridy = 1;
        this.progress = new JProgressBar();
        this.progress.setIndeterminate(true);
        this.getContentPane().add((Component)this.progress, constraints);
    }

    @Override
    public void dispose() {
        Window frame = this.getOwner();
        super.dispose();
        if (!this.pluginMode) {
            frame.dispatchEvent(new WindowEvent(frame, 201));
        }
    }

    public void setMessage(String msg) {
        this.message.setText(msg);
    }

    public void setValue(int value) {
        this.progress.setValue(value);
    }

    public void setTotal(int n) {
        if (n > 0) {
            this.progress.setMaximum(n);
            this.progress.setIndeterminate(false);
            this.progress.setStringPainted(true);
        } else {
            this.progress.setIndeterminate(true);
            this.progress.setStringPainted(false);
        }
    }
}

