/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.model;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.rups.model.IndirectObjectFactory;
import com.itextpdf.rups.model.LoggerHelper;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfPagesTreeNode;
import java.util.ArrayList;

public class TreeNodeFactory {
    protected IndirectObjectFactory objects;
    protected ArrayList<PdfObjectTreeNode> nodes = new ArrayList();

    public TreeNodeFactory(IndirectObjectFactory objects) {
        this.objects = objects;
        for (int i = 0; i < objects.size(); ++i) {
            int ref = objects.getRefByIndex(i);
            this.nodes.add(PdfObjectTreeNode.getInstance(PdfNull.PDF_NULL, ref));
        }
    }

    public PdfObjectTreeNode getNode(int ref) {
        int idx = this.objects.getIndexByRef(ref);
        PdfObjectTreeNode node = this.nodes.get(idx);
        if (node.getPdfObject().isNull()) {
            node = PdfObjectTreeNode.getInstance(this.objects.loadObjectByReference(ref), ref);
            this.nodes.set(idx, node);
        }
        return node;
    }

    protected void associateIfIndirect(PdfObjectTreeNode node) {
        PdfIndirectReference ref = null;
        if (node != null && node.getPdfObject() != null) {
            ref = node.getPdfObject().getIndirectReference();
        }
        if (ref != null) {
            int idx = this.objects.getIndexByRef(ref.getObjNumber());
            this.nodes.set(idx, node);
        }
    }

    public void expandNode(PdfObjectTreeNode node) {
        if (node.getChildCount() > 0) {
            return;
        }
        PdfObject object = node.getPdfObject();
        switch (object.getType()) {
            case 5: {
                PdfIndirectReference ref = (PdfIndirectReference)object;
                PdfObjectTreeNode leaf = this.getNode(ref.getObjNumber());
                this.addNodes(node, leaf);
                if (!(leaf instanceof PdfPagesTreeNode)) break;
                this.expandNode(leaf);
                break;
            }
            case 1: {
                PdfArray array = (PdfArray)object;
                for (int i = 0; i < array.size(); ++i) {
                    PdfObjectTreeNode leaf = PdfObjectTreeNode.getInstance(array.get(i, false));
                    this.associateIfIndirect(leaf);
                    this.addNodes(node, leaf);
                    this.expandNode(leaf);
                }
                break;
            }
            case 3: 
            case 9: {
                PdfDictionary dict = (PdfDictionary)object;
                for (PdfName key : dict.keySet()) {
                    PdfObjectTreeNode leaf = PdfObjectTreeNode.getInstance(dict, key);
                    this.associateIfIndirect(leaf);
                    this.addNodes(node, leaf);
                    this.expandNode(leaf);
                }
                break;
            }
        }
    }

    public PdfObjectTreeNode getChildNode(PdfObjectTreeNode node, PdfName key) {
        PdfObjectTreeNode child = node.getDictionaryChildNode(key);
        if (child != null && child.isDictionaryNode(key)) {
            if (child.isIndirectReference()) {
                this.expandNode(child);
                child = (PdfObjectTreeNode)child.getFirstChild();
            }
            this.expandNode(child);
            return child;
        }
        return null;
    }

    private void addNodes(PdfObjectTreeNode parent, PdfObjectTreeNode child) {
        try {
            parent.add(child);
        }
        catch (IllegalArgumentException iae) {
            parent.setRecursive(true);
        }
    }

    public void addNewIndirectObject(PdfObject object) {
        this.objects.addNewIndirectObject(object);
        this.nodes.add(PdfObjectTreeNode.getInstance(object, object.getIndirectReference().getObjNumber()));
        LoggerHelper.info("Tree node was successfully created for new indirect object", this.getClass());
    }
}

