/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.model;

import com.itextpdf.rups.io.OutputStreamResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XfaFile
implements OutputStreamResource {
    protected Document xfaDocument;

    public XfaFile(OutputStreamResource resource) throws IOException, DocumentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        resource.writeTo(baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        SAXReader reader = new SAXReader();
        reader.setEntityResolver(new SafeEmptyEntityResolver());
        this.xfaDocument = reader.read(bais);
    }

    public Document getXfaDocument() {
        return this.xfaDocument;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.xfaDocument == null) {
            return;
        }
        OutputFormat format = new OutputFormat("   ", true);
        XMLWriter writer = new XMLWriter(os, format);
        writer.write(this.xfaDocument);
    }

    private static class SafeEmptyEntityResolver
    implements EntityResolver {
        private SafeEmptyEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    }
}

