/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view;

import com.itextpdf.rups.event.ConsoleWriteEvent;
import com.itextpdf.rups.event.RupsEvent;
import java.awt.Color;
import java.io.OutputStream;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class Console
extends Observable
implements Observer {
    private static Console console = null;
    ConsoleStyleContext styleContext = new ConsoleStyleContext();
    private final JTextPane textArea = new JTextPane(new DefaultStyledDocument(this.styleContext));
    private static final int MAX_TEXT_AREA_SIZE = 8192;
    private static final int BUFFER_SIZE = 1024;

    private Console(boolean pluginMode) {
        this.textArea.setEditable(false);
    }

    public static synchronized Console getInstance() {
        if (console == null) {
            console = new Console(false);
        }
        return console;
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (obj instanceof RupsEvent) {
            RupsEvent event = (RupsEvent)obj;
            switch (event.getType()) {
                case 1: 
                case 2: {
                    this.clearWithBuffer("");
                }
            }
        }
    }

    private void updateTextPane(final String msg, final String type) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Document doc = Console.this.textArea.getDocument();
                    Style attset = Console.this.styleContext.getStyle(type);
                    if (doc.getLength() + msg.length() > 8192) {
                        Console.this.clearWithBuffer("...too many output\n");
                    }
                    doc.insertString(doc.getLength(), msg, attset);
                    Console.this.textArea.setCaretPosition(Console.this.textArea.getDocument().getLength());
                    Console.this.setChanged();
                    Console.this.notifyObservers(new ConsoleWriteEvent());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    private void clearWithBuffer(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    String backupString = Console.this.textArea.getText(Math.max(Console.this.textArea.getDocument().getLength() - 1024, 0), Math.min(Console.this.textArea.getDocument().getLength(), 1024));
                    Console.this.textArea.setText("");
                    Document doc = Console.this.textArea.getDocument();
                    doc.insertString(doc.getLength(), backupString, Console.this.styleContext.getStyle("Backup"));
                    doc.insertString(doc.getLength(), message == null ? "" : message, Console.this.styleContext.getStyle("Info"));
                }
                catch (BadLocationException any) {
                    Console.this.textArea.setText(message == null ? "" : message);
                }
                Console.this.textArea.setCaretPosition(Console.this.textArea.getDocument().getLength());
                Console.this.setChanged();
                Console.this.notifyObservers(new ConsoleWriteEvent());
            }
        });
    }

    public JTextPane getTextArea() {
        return this.textArea;
    }

    static class ConsoleStyleContext
    extends StyleContext {
        public static final String INFO = "Info";
        public static final String BACKUP = "Backup";
        public static final String ERROR = "Error";

        public ConsoleStyleContext() {
            Style root = this.getStyle("default");
            Style s = this.addStyle(INFO, root);
            StyleConstants.setForeground(s, Color.BLACK);
            s = this.addStyle(BACKUP, root);
            StyleConstants.setForeground(s, Color.LIGHT_GRAY);
            s = this.addStyle(ERROR, root);
            StyleConstants.setForeground(s, Color.RED);
        }
    }

    static class ConsoleOutputStream
    extends OutputStream {
        private String type;

        ConsoleOutputStream(String type) {
            this.type = type;
        }

        @Override
        public void write(int b) {
            Console.getInstance().updateTextPane(String.valueOf((char)b), this.type);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            Console.getInstance().updateTextPane(new String(b, off, len), this.type);
        }

        @Override
        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }
    }
}

