/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view;

import java.io.OutputStream;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class DebugView {
    private static DebugView debugView = null;
    private final JTextArea textArea = new JTextArea();
    private static final int MAX_LINES = 8192;
    private static final int BACKUP_SIZE = 8192;

    private DebugView(boolean pluginMode) {
        this.textArea.setEditable(false);
    }

    public static synchronized DebugView getInstance() {
        if (debugView == null) {
            debugView = new DebugView(false);
        }
        return debugView;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    private void updateTextPane(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebugView.this.textArea.getDocument();
                if (DebugView.this.textArea.getLineCount() >= 8192) {
                    String backupString = "";
                    try {
                        backupString = DebugView.this.textArea.getText(Math.max(DebugView.this.textArea.getDocument().getLength() - 8192, 0), Math.min(DebugView.this.textArea.getDocument().getLength(), 8192));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    DebugView.this.textArea.setText(backupString + "\n...too many output\n");
                }
                DebugView.this.textArea.append(msg);
                DebugView.this.textArea.setCaretPosition(DebugView.this.textArea.getDocument().getLength());
            }
        });
    }

    static class DebugOutputStream
    extends OutputStream {
        DebugOutputStream() {
        }

        @Override
        public void write(int b) {
            DebugView.getInstance().updateTextPane(String.valueOf((char)b));
        }

        @Override
        public void write(byte[] b, int off, int len) {
            DebugView.getInstance().updateTextPane(new String(b, off, len));
        }

        @Override
        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }
    }
}

