/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view;

import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.rups.controller.RupsController;
import com.itextpdf.rups.event.NewIndirectObjectEvent;
import com.itextpdf.rups.model.PdfSyntaxParser;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NewIndirectPdfObjectDialog
extends JDialog
implements PropertyChangeListener {
    private PdfObject result;
    private JTextArea textArea;
    private JOptionPane optionPane;
    private PdfSyntaxParser parser;
    private String btnString1 = "Enter";
    private String btnString2 = "Cancel";

    public NewIndirectPdfObjectDialog(Frame parent, String title, PdfSyntaxParser parser) {
        super(parent, true);
        this.setTitle(title);
        this.parser = parser;
        this.textArea = new JTextArea();
        this.textArea.setMinimumSize(new Dimension(100, 200));
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setMinimumSize(new Dimension(100, 200));
        Object[] array = new Object[]{"Value", scrollPane};
        Object[] options = new Object[]{this.btnString1, this.btnString2};
        this.optionPane = new JOptionPane(array, 3, 0, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.pack();
        this.setSize(300, 450);
        Point parentLocation = parent.getLocation();
        this.setLocation(parentLocation.x + 20, parentLocation.y + 40);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                NewIndirectPdfObjectDialog.this.optionPane.setValue(-1);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                NewIndirectPdfObjectDialog.this.textArea.requestFocusInWindow();
            }
        });
        this.optionPane.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (this.btnString1.equals(value)) {
                this.result = this.parser.parseString(this.textArea.getText(), this.getContentPane());
                this.clearAndHide();
            } else {
                this.result = null;
                this.clearAndHide();
            }
        }
    }

    public void clearAndHide() {
        this.textArea.setText(null);
        this.setVisible(false);
    }

    public PdfObject getResult() {
        return this.result;
    }

    public static class AddNewIndirectAction
    extends AbstractAction {
        private RupsController controller;

        public AddNewIndirectAction(RupsController controller) {
            this.controller = controller;
        }

        public AddNewIndirectAction(RupsController controller, String name) {
            super(name);
            this.controller = controller;
        }

        public AddNewIndirectAction(RupsController controller, String name, Icon icon) {
            super(name, icon);
            this.controller = controller;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.controller.update(null, new NewIndirectObjectEvent());
        }
    }
}

