/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view;

import com.itextpdf.rups.controller.RupsController;
import com.itextpdf.rups.event.RupsEvent;
import com.itextpdf.rups.io.FileCloseAction;
import com.itextpdf.rups.io.FileCompareAction;
import com.itextpdf.rups.io.FileOpenAction;
import com.itextpdf.rups.io.FileSaveAction;
import com.itextpdf.rups.io.filters.PdfFilter;
import com.itextpdf.rups.model.PdfFile;
import com.itextpdf.rups.view.MessageAction;
import com.itextpdf.rups.view.NewIndirectPdfObjectDialog;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class RupsMenuBar
extends JMenuBar
implements Observer {
    public static final String FILE_MENU = "File";
    public static final String OPEN = "Open";
    public static final String OPENINVIEWER = "Open in PDF Viewer";
    public static final String CLOSE = "Close";
    public static final String SAVE_AS = "Save as...";
    public static final String HELP_MENU = "Help";
    public static final String ABOUT = "About";
    public static final String COMPARE_WITH = "Compare with...";
    public static final String NEW_INDIRECT = "Add new indirect object";
    public static final String VERSION = "Version";
    protected RupsController controller;
    protected FileOpenAction fileOpenAction;
    protected FileSaveAction fileSaverAction;
    protected HashMap<String, JMenuItem> items;
    protected FileCompareAction fileCompareAction;

    public RupsMenuBar(RupsController controller) {
        this.controller = controller;
        this.items = new HashMap();
        this.fileOpenAction = new FileOpenAction(this.controller, PdfFilter.INSTANCE, this.controller.getMasterComponent());
        this.fileSaverAction = new FileSaveAction(this.controller, PdfFilter.INSTANCE, this.controller.getMasterComponent());
        this.fileCompareAction = new FileCompareAction(this.controller, PdfFilter.INSTANCE, this.controller.getMasterComponent());
        MessageAction message = new MessageAction();
        JMenu file = new JMenu(FILE_MENU);
        this.addItem(file, OPEN, this.fileOpenAction, KeyStroke.getKeyStroke(79, 128));
        this.addItem(file, CLOSE, new FileCloseAction(this.controller), KeyStroke.getKeyStroke(87, 128));
        this.addItem(file, SAVE_AS, this.fileSaverAction, KeyStroke.getKeyStroke(83, 128));
        this.addItem(file, COMPARE_WITH, this.fileCompareAction, KeyStroke.getKeyStroke(81, 128));
        file.addSeparator();
        this.addItem(file, OPENINVIEWER, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Desktop.isDesktopSupported()) {
                    return;
                }
                try {
                    PdfFile pdfFile = RupsMenuBar.this.controller.getPdfFile();
                    if (pdfFile == null || pdfFile.getDirectory() == null) {
                        return;
                    }
                    File myFile = new File(pdfFile.getDirectory(), pdfFile.getFilename());
                    Desktop.getDesktop().open(myFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, KeyStroke.getKeyStroke(69, 128));
        this.addItem(file, NEW_INDIRECT, new NewIndirectPdfObjectDialog.AddNewIndirectAction(controller), KeyStroke.getKeyStroke(78, 128));
        this.add(file);
        this.add(Box.createGlue());
        JMenu help = new JMenu(HELP_MENU);
        this.addItem(help, ABOUT, message);
        this.addItem(help, VERSION, message);
        this.add(help);
        this.enableItems(false);
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (observable instanceof RupsController && obj instanceof RupsEvent) {
            RupsEvent event = (RupsEvent)obj;
            switch (event.getType()) {
                case 2: {
                    this.enableItems(false);
                    break;
                }
                case 1: {
                    this.enableItems(true);
                    break;
                }
                case 6: {
                    this.fileOpenAction.actionPerformed(null);
                }
            }
        }
    }

    protected void addItem(JMenu menu, String caption, ActionListener action) {
        this.addItem(menu, caption, action, null);
    }

    protected void addItem(JMenu menu, String caption, ActionListener action, KeyStroke keyStroke) {
        JMenuItem item = new JMenuItem(caption);
        item.addActionListener(action);
        if (keyStroke != null) {
            item.setAccelerator(keyStroke);
        }
        menu.add(item);
        this.items.put(caption, item);
    }

    protected void enableItems(boolean enabled) {
        this.enableItem(CLOSE, enabled);
        this.enableItem(SAVE_AS, enabled);
        this.enableItem(OPENINVIEWER, enabled);
        this.enableItem(COMPARE_WITH, enabled);
        this.enableItem(NEW_INDIRECT, enabled);
    }

    protected void enableItem(String caption, boolean enabled) {
        this.items.get(caption).setEnabled(enabled);
    }
}

