/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.contextmenu;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.rups.view.contextmenu.ContextMenuMouseListener;
import com.itextpdf.rups.view.itext.PdfTree;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class PdfTreeContextMenuMouseListener
extends ContextMenuMouseListener {
    public PdfTreeContextMenuMouseListener(JPopupMenu popup, JComponent component) {
        super(popup, component);
    }

    @Override
    public boolean showPopupHook(MouseEvent event) {
        PdfTree tree = (PdfTree)this.component;
        int row = tree.getClosestRowForLocation(event.getX(), event.getY());
        tree.setSelectionRow(row);
        TreeSelectionModel selectionModel = ((PdfTree)this.component).getSelectionModel();
        TreePath[] paths = selectionModel.getSelectionPaths();
        if (paths == null || paths.length < 1) {
            return false;
        }
        PdfObjectTreeNode lastPath = (PdfObjectTreeNode)paths[0].getLastPathComponent();
        if (!lastPath.isStream()) {
            return false;
        }
        PdfStream stream = (PdfStream)lastPath.getPdfObject();
        return !PdfName.Image.equals(stream.get(PdfName.Subtype));
    }
}

