/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.contextmenu;

import com.itextpdf.rups.model.LoggerHelper;
import com.itextpdf.rups.view.contextmenu.AbstractRupsAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JTextPane;

public class SaveToFileJTextPaneAction
extends AbstractRupsAction {
    public SaveToFileJTextPaneAction(String name) {
        super(name);
    }

    public SaveToFileJTextPaneAction(String name, Component invoker) {
        super(name, invoker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        JFileChooser fileChooser = new JFileChooser();
        int choice = fileChooser.showSaveDialog(null);
        if (choice == 0) {
            String path = fileChooser.getSelectedFile().getPath();
            boolean nothingSelected = false;
            JTextPane textPane = (JTextPane)this.invoker;
            if (textPane.getSelectedText() == null || textPane.getSelectedText().trim().length() == 0) {
                nothingSelected = true;
                textPane.selectAll();
            }
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(path));
                writer.write(textPane.getSelectedText());
            }
            catch (IOException e) {
                LoggerHelper.warn("Can't write to file", (Exception)e, this.getClass());
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    LoggerHelper.error("Can't close stream", (Exception)e, this.getClass());
                }
            }
            if (nothingSelected) {
                textPane.select(0, 0);
            }
        }
    }
}

