/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.contextmenu;

import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.rups.model.LoggerHelper;
import com.itextpdf.rups.view.contextmenu.AbstractRupsAction;
import com.itextpdf.rups.view.itext.PdfTree;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class SaveToFilePdfTreeAction
extends AbstractRupsAction {
    private boolean saveRawBytes;

    public SaveToFilePdfTreeAction(String name) {
        super(name);
    }

    public SaveToFilePdfTreeAction(String name, Component invoker) {
        super(name, invoker);
    }

    public SaveToFilePdfTreeAction(String name, Component invoker, boolean raw) {
        super(name, invoker);
        this.saveRawBytes = raw;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int choice;
        JFileChooser fileChooser = new JFileChooser();
        if (this.saveRawBytes) {
            fileChooser.setDialogTitle(fileChooser.getDialogTitle() + " raw bytes");
        }
        if ((choice = fileChooser.showSaveDialog(null)) == 0) {
            String path = fileChooser.getSelectedFile().getPath();
            PdfTree tree = (PdfTree)this.invoker;
            TreeSelectionModel selectionModel = tree.getSelectionModel();
            TreePath[] paths = selectionModel.getSelectionPaths();
            PdfObjectTreeNode lastPath = (PdfObjectTreeNode)paths[0].getLastPathComponent();
            PdfObject object = lastPath.getPdfObject();
            PdfStream stream = (PdfStream)object;
            try {
                byte[] array = stream.getBytes(!this.saveRawBytes);
                try (FileOutputStream fos = new FileOutputStream(path);){
                    fos.write(array);
                }
            }
            catch (IOException e) {
                LoggerHelper.error("Can't write to file", (Exception)e, this.getClass());
            }
        }
    }
}

