/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.contextmenu;

import com.itextpdf.rups.view.contextmenu.CopyToClipboardAction;
import com.itextpdf.rups.view.contextmenu.SaveToFileJTextPaneAction;
import com.itextpdf.rups.view.contextmenu.SaveToPdfStreamJTextPaneAction;
import com.itextpdf.rups.view.itext.SyntaxHighlightedStreamPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextPane;

public class StreamPanelContextMenu
extends JPopupMenu {
    private static final String COPY = "Copy";
    private static final String SELECT_ALL = "Select All";
    private static final String SAVE_TO_FILE = "Save to File";
    private static final String SAVE_TO_STREAM = "Save to Stream";
    private JMenuItem saveToStream;
    private boolean pluginMode;

    public StreamPanelContextMenu(JTextPane textPane, SyntaxHighlightedStreamPane controller, boolean pluginMode) {
        this.pluginMode = pluginMode;
        JMenuItem copyItem = new JMenuItem();
        copyItem.setAction(new CopyToClipboardAction(COPY, textPane));
        copyItem.setText(COPY);
        JMenuItem selectAllItem = new JMenuItem(SELECT_ALL);
        selectAllItem.setAction(textPane.getActionMap().get("select-all"));
        selectAllItem.setText(SELECT_ALL);
        JMenuItem saveToFile = new JMenuItem();
        saveToFile.setText(SAVE_TO_FILE);
        saveToFile.setAction(new SaveToFileJTextPaneAction(SAVE_TO_FILE, textPane));
        this.saveToStream = new JMenuItem();
        this.saveToStream.setText(SAVE_TO_STREAM);
        this.saveToStream.setAction(new SaveToPdfStreamJTextPaneAction(SAVE_TO_STREAM, controller));
        this.add(this.saveToStream);
        this.add(new JSeparator());
        this.add(copyItem);
        this.add(saveToFile);
        this.add(new JSeparator());
        this.add(selectAllItem);
    }

    public void setSaveToStreamEnabled(boolean enabled) {
        this.saveToStream.setEnabled(enabled && !this.pluginMode);
    }
}

