/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.event.RupsEvent;
import com.itextpdf.rups.model.LoggerHelper;
import com.itextpdf.rups.model.ObjectLoader;
import com.itextpdf.rups.model.TreeNodeFactory;
import com.itextpdf.rups.model.XfaFile;
import com.itextpdf.rups.view.icons.IconTreeCellRenderer;
import com.itextpdf.rups.view.itext.XfaTextArea;
import com.itextpdf.rups.view.itext.XfaTree;
import com.itextpdf.rups.view.itext.treenodes.FormTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.itextpdf.rups.view.itext.treenodes.XfaTreeNode;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.dom4j.DocumentException;

public class FormTree
extends JTree
implements TreeSelectionListener,
Observer {
    protected PdfReaderController controller;
    protected XfaFile xfaFile;
    protected XfaTree xfaTree;
    protected XfaTextArea xfaTextArea;

    public FormTree(PdfReaderController controller) {
        this.controller = controller;
        this.setCellRenderer(new IconTreeCellRenderer());
        this.setModel(new DefaultTreeModel(new FormTreeNode()));
        this.addTreeSelectionListener(this);
        this.xfaTree = new XfaTree();
        this.xfaTree.clear();
        this.xfaTextArea = new XfaTextArea();
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (observable instanceof PdfReaderController && obj instanceof RupsEvent) {
            RupsEvent event = (RupsEvent)obj;
            switch (event.getType()) {
                case 2: {
                    this.setModel(new DefaultTreeModel(new FormTreeNode()));
                    this.xfaFile = null;
                    this.xfaTree.clear();
                    this.xfaTextArea.clear();
                    this.repaint();
                    return;
                }
                case 1: {
                    PdfObjectTreeNode xfa;
                    ObjectLoader loader = (ObjectLoader)event.getContent();
                    TreeNodeFactory factory = loader.getNodes();
                    PdfTrailerTreeNode trailer = this.controller.getPdfTree().getRoot();
                    PdfObjectTreeNode catalog = factory.getChildNode(trailer, PdfName.Root);
                    PdfObjectTreeNode form = factory.getChildNode(catalog, PdfName.AcroForm);
                    if (form == null) {
                        return;
                    }
                    PdfObjectTreeNode fields = factory.getChildNode(form, PdfName.Fields);
                    FormTreeNode root = new FormTreeNode();
                    if (fields != null) {
                        FormTreeNode node = new FormTreeNode(fields);
                        node.setUserObject("Fields");
                        this.loadFields(factory, node, fields);
                        root.add(node);
                    }
                    if ((xfa = factory.getChildNode(form, PdfName.XFA)) != null) {
                        XfaTreeNode node = new XfaTreeNode(xfa);
                        node.setUserObject("XFA");
                        this.loadXfa(factory, node, xfa);
                        root.add(node);
                        try {
                            this.xfaFile = new XfaFile(node);
                            this.xfaTree.load(this.xfaFile);
                            this.xfaTextArea.load(this.xfaFile);
                        }
                        catch (IOException e) {
                            LoggerHelper.warn("Can't load XFA", (Exception)e, this.getClass());
                        }
                        catch (DocumentException e) {
                            LoggerHelper.error("Can't parse xml", (Exception)e, this.getClass());
                        }
                    }
                    this.setModel(new DefaultTreeModel(root));
                }
            }
        }
    }

    private void loadFields(TreeNodeFactory factory, FormTreeNode form_node, PdfObjectTreeNode object_node) {
        if (object_node == null) {
            return;
        }
        factory.expandNode(object_node);
        if (object_node.isIndirectReference()) {
            this.loadFields(factory, form_node, (PdfObjectTreeNode)object_node.getFirstChild());
        } else if (object_node.isArray()) {
            Enumeration<TreeNode> children = object_node.children();
            while (children.hasMoreElements()) {
                this.loadFields(factory, form_node, (PdfObjectTreeNode)children.nextElement());
            }
        } else if (object_node.isDictionary()) {
            FormTreeNode leaf = new FormTreeNode(object_node);
            form_node.add(leaf);
            PdfObjectTreeNode kids = factory.getChildNode(object_node, PdfName.Kids);
            this.loadFields(factory, leaf, kids);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        if (this.controller == null) {
            return;
        }
        FormTreeNode selectednode = (FormTreeNode)this.getLastSelectedPathComponent();
        if (selectednode == null) {
            return;
        }
        PdfObjectTreeNode node = selectednode.getCorrespondingPdfObjectNode();
        if (node != null) {
            this.controller.selectNode(node);
        }
    }

    public XfaTree getXfaTree() {
        return this.xfaTree;
    }

    public XfaTextArea getXfaTextArea() {
        return this.xfaTextArea;
    }

    void loadXfa(TreeNodeFactory factory, XfaTreeNode form_node, PdfObjectTreeNode object_node) {
        if (object_node == null) {
            return;
        }
        factory.expandNode(object_node);
        if (object_node.isIndirectReference()) {
            this.loadXfa(factory, form_node, (PdfObjectTreeNode)object_node.getFirstChild());
        } else if (object_node.isArray()) {
            Enumeration<TreeNode> children = object_node.children();
            while (children.hasMoreElements()) {
                PdfObjectTreeNode key = (PdfObjectTreeNode)children.nextElement();
                PdfObjectTreeNode value = (PdfObjectTreeNode)children.nextElement();
                if (value.isIndirectReference()) {
                    factory.expandNode(value);
                    value = (PdfObjectTreeNode)value.getFirstChild();
                }
                form_node.addPacket(key.getPdfObject().toString(), value);
            }
        } else if (object_node.isStream()) {
            form_node.addPacket("xdp", object_node);
        }
    }
}

