/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.event.RupsEvent;
import com.itextpdf.rups.model.ObjectLoader;
import com.itextpdf.rups.model.TreeNodeFactory;
import com.itextpdf.rups.view.icons.IconTreeCellRenderer;
import com.itextpdf.rups.view.itext.treenodes.OutlineTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;

public class OutlineTree
extends JTree
implements TreeSelectionListener,
Observer {
    protected PdfReaderController controller;

    public OutlineTree(PdfReaderController controller) {
        this.controller = controller;
        this.setCellRenderer(new IconTreeCellRenderer());
        this.setModel(new DefaultTreeModel(new OutlineTreeNode()));
        this.addTreeSelectionListener(this);
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (observable instanceof PdfReaderController && obj instanceof RupsEvent) {
            RupsEvent event = (RupsEvent)obj;
            switch (event.getType()) {
                case 2: {
                    this.setModel(null);
                    this.setModel(new DefaultTreeModel(new OutlineTreeNode()));
                    this.repaint();
                    return;
                }
                case 1: {
                    ObjectLoader loader = (ObjectLoader)event.getContent();
                    TreeNodeFactory factory = loader.getNodes();
                    PdfTrailerTreeNode trailer = this.controller.getPdfTree().getRoot();
                    PdfObjectTreeNode catalog = factory.getChildNode(trailer, PdfName.Root);
                    PdfObjectTreeNode outline = factory.getChildNode(catalog, PdfName.Outlines);
                    if (outline == null) {
                        return;
                    }
                    OutlineTreeNode root = new OutlineTreeNode();
                    PdfObjectTreeNode first = factory.getChildNode(outline, PdfName.First);
                    if (first != null) {
                        this.loadOutline(factory, root, first);
                    }
                    this.setModel(new DefaultTreeModel(root));
                }
            }
        }
    }

    private void loadOutline(TreeNodeFactory factory, OutlineTreeNode parent, PdfObjectTreeNode child) {
        PdfObjectTreeNode next;
        OutlineTreeNode childnode = new OutlineTreeNode(child);
        parent.add(childnode);
        PdfObjectTreeNode first = factory.getChildNode(child, PdfName.First);
        if (first != null) {
            this.loadOutline(factory, childnode, first);
        }
        if ((next = factory.getChildNode(child, PdfName.Next)) != null) {
            this.loadOutline(factory, parent, next);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        if (this.controller == null) {
            return;
        }
        OutlineTreeNode selectednode = (OutlineTreeNode)this.getLastSelectedPathComponent();
        if (selectednode == null) {
            return;
        }
        PdfObjectTreeNode node = selectednode.getCorrespondingPdfObjectNode();
        if (node != null) {
            this.controller.selectNode(node);
        }
    }
}

