/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.rups.model.TreeNodeFactory;
import com.itextpdf.rups.view.itext.treenodes.PdfPageTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

class PageEnumerator
implements Enumeration<PdfPageTreeNode> {
    protected List<PdfPageTreeNode> pages = new ArrayList<PdfPageTreeNode>();
    protected TreeNodeFactory factory;
    protected int cursor = 0;

    public PageEnumerator(PdfDictionary catalog, TreeNodeFactory factory) {
        this.factory = factory;
        this.expand((PdfIndirectReference)catalog.get(PdfName.Pages, false), catalog.getAsDictionary(PdfName.Pages));
    }

    @Override
    public boolean hasMoreElements() {
        return this.cursor < this.pages.size();
    }

    @Override
    public PdfPageTreeNode nextElement() {
        return this.pages.get(this.cursor++);
    }

    public void expand(PdfIndirectReference ref, PdfDictionary dict) {
        if (dict == null) {
            return;
        }
        if (PdfName.Pages.equals(dict.getAsName(PdfName.Type))) {
            PdfArray kids = dict.getAsArray(PdfName.Kids);
            if (kids != null) {
                for (int i = 0; i < kids.size(); ++i) {
                    this.expand((PdfIndirectReference)kids.get(i, false), kids.getAsDictionary(i));
                }
            }
        } else if (PdfName.Page.equals(dict.getAsName(PdfName.Type))) {
            this.pages.add((PdfPageTreeNode)this.factory.getNode(ref.getObjNumber()));
        }
    }
}

