/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.event.RupsEvent;
import com.itextpdf.rups.model.ObjectLoader;
import com.itextpdf.rups.model.TreeNodeFactory;
import com.itextpdf.rups.view.PageSelectionListener;
import com.itextpdf.rups.view.itext.PageEnumerator;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfPageTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.itextpdf.rups.view.models.JTableAutoModel;
import com.itextpdf.rups.view.models.JTableAutoModelInterface;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

public class PagesTable
extends JTable
implements JTableAutoModelInterface,
Observer {
    protected ArrayList<PdfPageTreeNode> list = new ArrayList();
    protected PdfReaderController controller;
    protected PageSelectionListener listener;

    public PagesTable(PdfReaderController controller, PageSelectionListener listener) {
        this.controller = controller;
        this.listener = listener;
        this.setModel(new JTableAutoModel(this));
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (observable instanceof PdfReaderController && obj instanceof RupsEvent) {
            RupsEvent event = (RupsEvent)obj;
            switch (event.getType()) {
                case 2: {
                    this.list = new ArrayList();
                    break;
                }
                case 1: {
                    ObjectLoader loader = (ObjectLoader)event.getContent();
                    String[] pageLabels = loader.getFile().getPdfDocument().getPageLabels();
                    int i = 0;
                    TreeNodeFactory factory = loader.getNodes();
                    PdfTrailerTreeNode trailer = this.controller.getPdfTree().getRoot();
                    PdfObjectTreeNode catalog = factory.getChildNode(trailer, PdfName.Root);
                    PageEnumerator p = new PageEnumerator((PdfDictionary)catalog.getPdfObject(), factory);
                    while (p.hasMoreElements()) {
                        PdfPageTreeNode child = (PdfPageTreeNode)p.nextElement();
                        StringBuffer buf = new StringBuffer("Page ");
                        buf.append(++i);
                        if (pageLabels != null) {
                            buf.append(" ( ");
                            buf.append(pageLabels[i - 1]);
                            buf.append(" )");
                        }
                        child.setUserObject(buf.toString());
                        this.list.add(child);
                    }
                    break;
                }
            }
            this.setModel(new JTableAutoModel(this));
            this.repaint();
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.getRowCount() == 0) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return "Object " + this.list.get(rowIndex).getNumber();
            }
            case 1: {
                return this.list.get(rowIndex);
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Object";
            }
            case 1: {
                return "Page";
            }
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        int selectedRow;
        if (evt != null) {
            super.valueChanged(evt);
        }
        if (this.controller == null) {
            return;
        }
        if (this.getRowCount() > 0 && (selectedRow = this.getSelectedRow()) >= 0) {
            this.controller.selectNode(this.list.get(selectedRow));
            if (this.listener != null) {
                this.listener.gotoPage(this.getSelectedRow() + 1);
            }
        }
    }
}

