/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.event.NodeAddArrayChildEvent;
import com.itextpdf.rups.event.NodeAddDictChildEvent;
import com.itextpdf.rups.event.NodeDeleteArrayChildEvent;
import com.itextpdf.rups.event.NodeDeleteDictChildEvent;
import com.itextpdf.rups.event.RupsEvent;
import com.itextpdf.rups.model.PdfSyntaxParser;
import com.itextpdf.rups.view.icons.IconFetcher;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.models.AbstractPdfObjectPanelTableModel;
import com.itextpdf.rups.view.models.DictionaryTableModel;
import com.itextpdf.rups.view.models.DictionaryTableModelButton;
import com.itextpdf.rups.view.models.PdfArrayTableModel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class PdfObjectPanel
extends Observable
implements Observer {
    private boolean pluginMode;
    private JPanel panel = new JPanel();
    private static final String TEXT = "text";
    private static final String TABLE = "table";
    protected CardLayout layout = new CardLayout();
    JTable table = new JTable();
    JTextArea text = new JTextArea();
    private JTableButtonMouseListener mouseListener;
    private PdfObjectTreeNode target;

    public PdfObjectPanel(boolean pluginMode, PdfSyntaxParser parser) {
        this.pluginMode = pluginMode;
        this.panel.setLayout(this.layout);
        JScrollPane dict_scrollpane = new JScrollPane();
        dict_scrollpane.setViewportView(this.table);
        this.panel.add((Component)dict_scrollpane, TABLE);
        JScrollPane text_scrollpane = new JScrollPane();
        text_scrollpane.setViewportView(this.text);
        this.text.setEditable(false);
        this.panel.add((Component)text_scrollpane, TEXT);
        this.mouseListener = new JTableButtonMouseListener();
        this.table.addMouseListener(this.mouseListener);
    }

    public void clear() {
        this.target = null;
        this.text.setText(null);
        this.layout.show(this.panel, TEXT);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (observable instanceof PdfReaderController && obj instanceof RupsEvent) {
            RupsEvent event = (RupsEvent)obj;
            this.clear();
        }
    }

    public void render(PdfObjectTreeNode node, PdfSyntaxParser parser) {
        this.target = node;
        PdfObject object = node.getPdfObject();
        if (object == null) {
            this.text.setText(null);
            this.layout.show(this.panel, TEXT);
            this.panel.repaint();
            this.text.repaint();
            return;
        }
        switch (object.getType()) {
            case 3: 
            case 9: {
                DictionaryTableModel model = new DictionaryTableModel((PdfDictionary)object, this.pluginMode, parser, this.panel);
                model.addTableModelListener(new DictionaryModelListener());
                this.table.setModel(model);
                if (!this.pluginMode) {
                    this.table.getColumn("").setCellRenderer(new DictionaryTableModelButton(IconFetcher.getIcon("cross.png"), IconFetcher.getIcon("add.png")));
                }
                this.layout.show(this.panel, TABLE);
                this.panel.repaint();
                break;
            }
            case 1: {
                PdfArrayTableModel arrayModel = new PdfArrayTableModel((PdfArray)object, this.pluginMode, parser, this.panel);
                arrayModel.addTableModelListener(new ArrayModelListener());
                this.table.setModel(arrayModel);
                if (!this.pluginMode) {
                    this.table.getColumn("").setCellRenderer(new DictionaryTableModelButton(IconFetcher.getIcon("cross.png"), IconFetcher.getIcon("add.png")));
                }
                this.layout.show(this.panel, TABLE);
                this.panel.repaint();
                break;
            }
            case 10: {
                this.text.setText(((PdfString)object).toUnicodeString());
                this.layout.show(this.panel, TEXT);
                break;
            }
            default: {
                this.text.setText(object.toString());
                this.layout.show(this.panel, TEXT);
            }
        }
    }

    private class ArrayModelListener
    implements TableModelListener {
        private ArrayModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int row = e.getFirstRow();
            if (row != e.getLastRow()) {
                return;
            }
            PdfObject value = ((PdfArray)PdfObjectPanel.this.target.getPdfObject()).get(row, false);
            switch (e.getType()) {
                case 0: {
                    break;
                }
                case -1: {
                    PdfObjectPanel.this.setChanged();
                    PdfObjectPanel.this.notifyObservers(new NodeDeleteArrayChildEvent(row, PdfObjectPanel.this.target));
                    break;
                }
                case 1: {
                    PdfObjectPanel.this.setChanged();
                    PdfObjectPanel.this.notifyObservers(new NodeAddArrayChildEvent(value, PdfObjectPanel.this.target, row));
                }
            }
        }
    }

    private class DictionaryModelListener
    implements TableModelListener {
        private DictionaryModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int row = e.getFirstRow();
            int col = e.getColumn();
            if (row != e.getLastRow()) {
                return;
            }
            PdfName key = (PdfName)PdfObjectPanel.this.table.getValueAt(row, 0);
            PdfObject value = ((PdfDictionary)PdfObjectPanel.this.target.getPdfObject()).get(key, false);
            switch (e.getType()) {
                case 0: {
                    break;
                }
                case -1: {
                    PdfObjectPanel.this.setChanged();
                    PdfObjectPanel.this.notifyObservers(new NodeDeleteDictChildEvent(key, PdfObjectPanel.this.target));
                    break;
                }
                case 1: {
                    PdfObjectPanel.this.setChanged();
                    PdfObjectPanel.this.notifyObservers(new NodeAddDictChildEvent(key, value, PdfObjectPanel.this.target, row));
                }
            }
        }
    }

    private class JTableButtonMouseListener
    extends MouseAdapter {
        private JTableButtonMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int selectedColumn = PdfObjectPanel.this.table.getSelectedColumn();
            if (selectedColumn != ((AbstractPdfObjectPanelTableModel)PdfObjectPanel.this.table.getModel()).getButtonColumn()) {
                return;
            }
            int selectedRow = PdfObjectPanel.this.table.getSelectedRow();
            int rowCount = PdfObjectPanel.this.table.getRowCount();
            if (rowCount == 1 || rowCount - 1 == selectedRow) {
                ((AbstractPdfObjectPanelTableModel)PdfObjectPanel.this.table.getModel()).validateTempRow();
                return;
            }
            if (selectedRow < rowCount - 1 && selectedRow >= 0 && PdfObjectPanel.this.target != null) {
                ((AbstractPdfObjectPanelTableModel)PdfObjectPanel.this.table.getModel()).removeRow(selectedRow);
            }
        }
    }
}

