/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.event.RupsEvent;
import com.itextpdf.rups.io.listeners.PdfTreeExpansionListener;
import com.itextpdf.rups.io.listeners.PdfTreeNavigationListener;
import com.itextpdf.rups.view.icons.IconTreeCellRenderer;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PdfTree
extends JTree
implements Observer {
    protected PdfTrailerTreeNode root = new PdfTrailerTreeNode();

    public PdfTree() {
        PdfTreeNavigationListener listener = new PdfTreeNavigationListener();
        this.addKeyListener(listener);
        this.addMouseListener(listener);
        this.setCellRenderer(new IconTreeCellRenderer());
        this.addTreeExpansionListener(new PdfTreeExpansionListener());
        this.setModel(new DefaultTreeModel(this.root));
        this.repaint();
    }

    public PdfTrailerTreeNode getRoot() {
        return this.root;
    }

    @Override
    public void update(Observable observable, Object obj) {
        RupsEvent event;
        if (observable instanceof PdfReaderController && obj instanceof RupsEvent && 2 == (event = (RupsEvent)obj).getType()) {
            this.root = new PdfTrailerTreeNode();
        }
        this.setModel(new DefaultTreeModel(this.root));
        this.repaint();
    }

    public void selectNode(PdfObjectTreeNode node) {
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }
}

