/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.event.RupsEvent;
import com.itextpdf.rups.model.ObjectLoader;
import com.itextpdf.rups.model.PdfFile;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutionException;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

public class PlainText
extends JTextArea
implements Observer {
    private PdfFile file;
    protected boolean loaded = false;
    private SwingWorker<String, Object> worker;

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof PdfReaderController && arg instanceof RupsEvent) {
            RupsEvent event = (RupsEvent)arg;
            switch (event.getType()) {
                case 2: {
                    this.file = null;
                    this.setText("");
                    if (this.worker != null) {
                        this.worker.cancel(true);
                        this.worker = null;
                    }
                    this.loaded = false;
                    break;
                }
                case 1: {
                    this.file = ((ObjectLoader)event.getContent()).getFile();
                    this.loaded = false;
                    if (this.worker == null) break;
                    this.worker.cancel(true);
                    this.worker = null;
                    break;
                }
                case 9: {
                    if (this.file == null || this.loaded) break;
                    this.loaded = true;
                    this.setText("Loading...");
                    this.worker = new SwingWorker<String, Object>(){

                        @Override
                        protected String doInBackground() {
                            return PlainText.this.file.getRawContent();
                        }

                        @Override
                        protected void done() {
                            if (!this.isCancelled()) {
                                String text;
                                try {
                                    text = (String)this.get();
                                }
                                catch (InterruptedException any) {
                                    text = "Error while loading text";
                                    Thread.currentThread().interrupt();
                                }
                                catch (ExecutionException any) {
                                    text = "Error while loading text";
                                }
                                PlainText.this.setText(text);
                            }
                        }
                    };
                    this.worker.execute();
                }
            }
        }
    }
}

