/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.event.RupsEvent;
import com.itextpdf.rups.model.ObjectLoader;
import com.itextpdf.rups.model.TreeNodeFactory;
import com.itextpdf.rups.view.icons.IconTreeCellRenderer;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.itextpdf.rups.view.itext.treenodes.StructureTreeNode;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutionException;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class StructureTree
extends JTree
implements TreeSelectionListener,
Observer {
    protected PdfReaderController controller;
    protected ObjectLoader loader;
    protected boolean loaded = false;
    protected SwingWorker<TreeModel, Integer> worker;

    public StructureTree(PdfReaderController controller) {
        this.controller = controller;
        this.setCellRenderer(new IconTreeCellRenderer());
        this.setModel(new DefaultTreeModel(new StructureTreeNode()));
        this.addTreeSelectionListener(this);
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (observable instanceof PdfReaderController && obj instanceof RupsEvent) {
            RupsEvent event = (RupsEvent)obj;
            switch (event.getType()) {
                case 2: {
                    this.loader = null;
                    if (this.worker != null) {
                        this.worker.cancel(true);
                        this.worker = null;
                    }
                    this.setModel(new DefaultTreeModel(new StructureTreeNode()));
                    this.repaint();
                    this.loaded = false;
                    break;
                }
                case 1: {
                    this.loader = (ObjectLoader)event.getContent();
                    if (this.worker != null) {
                        this.worker.cancel(true);
                        this.worker = null;
                    }
                    this.loaded = false;
                    break;
                }
                case 8: {
                    if (this.loader == null || this.loaded) break;
                    this.loaded = true;
                    this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Loading...")));
                    this.worker = new SwingWorker<TreeModel, Integer>(){

                        @Override
                        protected TreeModel doInBackground() {
                            PdfTrailerTreeNode trailer;
                            PdfObjectTreeNode catalog;
                            TreeNodeFactory factory = StructureTree.this.loader.getNodes();
                            PdfObjectTreeNode structuretree = factory.getChildNode(catalog = factory.getChildNode(trailer = StructureTree.this.controller.getPdfTree().getRoot(), PdfName.Root), PdfName.StructTreeRoot);
                            if (structuretree == null) {
                                return new DefaultTreeModel(new StructureTreeNode());
                            }
                            StructureTreeNode root = new StructureTreeNode();
                            PdfObjectTreeNode kids = factory.getChildNode(structuretree, PdfName.K);
                            StructureTree.this.loadKids(factory, root, kids);
                            return new DefaultTreeModel(root);
                        }

                        @Override
                        protected void done() {
                            try {
                                if (!this.isCancelled()) {
                                    TreeModel model = (TreeModel)this.get();
                                    StructureTree.this.setModel(model);
                                }
                            }
                            catch (InterruptedException any) {
                                StructureTree.this.setModel(new DefaultTreeModel(new StructureTreeNode()));
                                Thread.currentThread().interrupt();
                            }
                            catch (ExecutionException any) {
                                StructureTree.this.setModel(new DefaultTreeModel(new StructureTreeNode()));
                            }
                            super.done();
                        }
                    };
                    this.worker.execute();
                }
            }
        }
    }

    private void loadKids(TreeNodeFactory factory, StructureTreeNode structure_node, PdfObjectTreeNode object_node) {
        if (object_node == null) {
            return;
        }
        factory.expandNode(object_node);
        if (object_node.isDictionary()) {
            PdfDictionary dict = (PdfDictionary)object_node.getPdfObject();
            if (PdfName.MCR.equals(dict.getAsName(PdfName.Type))) {
                structure_node.add(new StructureTreeNode(factory.getChildNode(object_node, PdfName.MCID), "bullet_go.png"));
                return;
            }
            if (PdfName.OBJR.equals(dict.getAsName(PdfName.Type))) {
                structure_node.add(new StructureTreeNode(factory.getChildNode(object_node, PdfName.Obj), "bullet_go.png"));
                return;
            }
            StructureTreeNode leaf = new StructureTreeNode(object_node, "chart_organisation.png");
            structure_node.add(leaf);
            PdfObjectTreeNode kids = factory.getChildNode(object_node, PdfName.K);
            this.loadKids(factory, leaf, kids);
        } else if (object_node.isArray()) {
            Enumeration<TreeNode> children = object_node.children();
            while (children.hasMoreElements()) {
                this.loadKids(factory, structure_node, (PdfObjectTreeNode)children.nextElement());
            }
        } else if (object_node.isIndirectReference()) {
            this.loadKids(factory, structure_node, (PdfObjectTreeNode)object_node.getFirstChild());
        } else {
            StructureTreeNode leaf = new StructureTreeNode(object_node, "bullet_go.png");
            structure_node.add(leaf);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.controller == null) {
            return;
        }
        StructureTreeNode selectednode = (StructureTreeNode)this.getLastSelectedPathComponent();
        if (selectednode == null) {
            return;
        }
        PdfObjectTreeNode node = selectednode.getCorrespondingPdfObjectNode();
        if (node != null) {
            this.controller.selectNode(node);
        }
    }
}

