/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.canvas.parser.util.PdfCanvasParser;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.event.RupsEvent;
import com.itextpdf.rups.model.LoggerHelper;
import com.itextpdf.rups.view.contextmenu.ContextMenuMouseListener;
import com.itextpdf.rups.view.contextmenu.StreamPanelContextMenu;
import com.itextpdf.rups.view.itext.ColorTextPane;
import com.itextpdf.rups.view.itext.RedoAction;
import com.itextpdf.rups.view.itext.UndoAction;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;

public class SyntaxHighlightedStreamPane
extends JScrollPane
implements Observer {
    protected ColorTextPane text;
    protected static Map<String, Map<Object, Object>> attributemap = null;
    protected static boolean matchingOperands = false;
    protected static final RandomAccessSourceFactory RASF = new RandomAccessSourceFactory();
    protected StreamPanelContextMenu popupMenu;
    protected PdfObjectTreeNode target;
    protected UndoManager manager;
    private static int MAX_NUMBER_OF_EDITS = 8192;
    private PdfReaderController controller;
    private static Method pdfStreamGetInputStreamMethod;

    public SyntaxHighlightedStreamPane(PdfReaderController controller, boolean pluginMode) {
        this.initAttributes();
        this.text = new ColorTextPane();
        this.setViewportView(this.text);
        this.controller = controller;
        this.popupMenu = new StreamPanelContextMenu(this.text, this, pluginMode);
        this.text.setComponentPopupMenu(this.popupMenu);
        this.text.addMouseListener(new ContextMenuMouseListener(this.popupMenu, this.text));
        this.manager = new UndoManager();
        this.manager.setLimit(MAX_NUMBER_OF_EDITS);
        this.text.getDocument().addUndoableEditListener(this.manager);
        this.text.registerKeyboardAction(new UndoAction(this.manager), KeyStroke.getKeyStroke(90, 2), 0);
        this.text.registerKeyboardAction(new RedoAction(this.manager), KeyStroke.getKeyStroke(89, 2), 0);
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (observable instanceof PdfReaderController && obj instanceof RupsEvent) {
            this.clearPane();
        }
    }

    public void render(PdfObjectTreeNode target) {
        this.manager.discardAllEdits();
        this.manager.setLimit(0);
        this.target = target;
        if (!(target.getPdfObject() instanceof PdfStream)) {
            this.clearPane();
            return;
        }
        PdfStream stream = (PdfStream)target.getPdfObject();
        this.text.setText("");
        if (PdfName.Image.equals(stream.getAsName(PdfName.Subtype))) {
            try {
                if (!stream.get(PdfName.Width, false).isNumber() && !stream.get(PdfName.Height, false).isNumber()) {
                    return;
                }
                PdfImageXObject pimg = new PdfImageXObject(stream);
                BufferedImage img = pimg.getBufferedImage();
                if (img == null) {
                    this.text.setText("Image can't be loaded.");
                } else {
                    StyledDocument doc = (StyledDocument)this.text.getDocument();
                    Style style = doc.addStyle("Image", null);
                    StyleConstants.setIcon(style, new ImageIcon(img));
                    try {
                        doc.insertString(doc.getLength(), "ignored text", style);
                        JButton saveImage = new JButton("Save Image");
                        final BufferedImage saveImg = img;
                        saveImage.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                try {
                                    FileDialog fileDialog = new FileDialog(new Frame(), "Save", 1);
                                    fileDialog.setFilenameFilter(new FilenameFilter(){

                                        @Override
                                        public boolean accept(File dir, String name) {
                                            return name.endsWith(".jpg");
                                        }
                                    });
                                    fileDialog.setFile("Untitled.jpg");
                                    fileDialog.setVisible(true);
                                    ImageIO.write((RenderedImage)saveImg, "jpg", new File(fileDialog.getDirectory() + fileDialog.getFile()));
                                }
                                catch (HeadlessException | IOException e) {
                                    LoggerHelper.error("Error while parsing Image", e, this.getClass());
                                }
                            }
                        });
                        this.text.append("\n", null);
                        this.text.insertComponent(saveImage);
                    }
                    catch (BadLocationException e) {
                        LoggerHelper.error("Unexpected exception", (Exception)e, this.getClass());
                    }
                }
            }
            catch (IOException e) {
                LoggerHelper.error("Unexpected exception", (Exception)e, this.getClass());
            }
            this.setTextEditableRoutine(false);
        } else if (stream.get(PdfName.Length1) != null) {
            try {
                this.setTextEditableRoutine(true);
                byte[] bytes = stream.getBytes(false);
                this.text.setText(new String(bytes));
                this.text.setCaretPosition(0);
            }
            catch (com.itextpdf.io.exceptions.IOException e) {
                this.text.setText("");
                this.setTextEditableRoutine(false);
            }
        } else if (stream.get(PdfName.Length1) == null) {
            this.setTextEditableRoutine(true);
            String newline = "\n";
            byte[] bb = null;
            try {
                bb = stream.getBytes();
                PdfTokenizer tokeniser = new PdfTokenizer(new RandomAccessFileOrArray(RASF.createSource(bb)));
                PdfCanvasParser ps = new PdfCanvasParser(tokeniser);
                ArrayList<PdfObject> tokens = new ArrayList<PdfObject>();
                while (ps.parse(tokens).size() > 0) {
                    String operator = tokens.get(tokens.size() - 1).toString();
                    StringBuilder operandssb = new StringBuilder();
                    for (int i = 0; i < tokens.size() - 1; ++i) {
                        this.append(operandssb, tokens.get(i));
                    }
                    String operands = operandssb.toString();
                    Map<Object, Object> attributes = attributemap.get(operator);
                    Map<Object, Object> attributesOperands = null;
                    if (matchingOperands) {
                        attributesOperands = attributes;
                    }
                    this.text.append(operands, attributesOperands);
                    this.text.append(operator + newline, attributes);
                }
            }
            catch (com.itextpdf.io.exceptions.IOException | PdfException e) {
                LoggerHelper.warn("Error while parsing PdfStream", (Exception)e, this.getClass());
                if (bb != null) {
                    this.text.setText(new String(bb));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.text.setCaretPosition(0);
        }
        this.text.repaint();
        this.manager.setLimit(MAX_NUMBER_OF_EDITS);
        this.repaint();
    }

    public void saveToTarget() {
        this.manager.discardAllEdits();
        this.manager.setLimit(0);
        if (this.controller != null && ((PdfDictionary)this.target.getPdfObject()).containsKey(PdfName.Filter)) {
            this.controller.deleteTreeNodeDictChild(this.target, PdfName.Filter);
        }
        ((PdfStream)this.target.getPdfObject()).setData(this.text.getText().getBytes());
        if (this.controller != null) {
            this.controller.selectNode(this.target);
        }
        this.manager.setLimit(MAX_NUMBER_OF_EDITS);
    }

    protected void append(StringBuilder sb, PdfObject obj) {
        switch (obj.getType()) {
            case 10: {
                PdfString str = (PdfString)obj;
                if (str.isHexWriting()) {
                    byte[] b;
                    sb.append("<");
                    for (byte aB : b = str.getValueBytes()) {
                        String hex = Integer.toHexString(aB & 0xFF);
                        if (hex.length() % 2 == 1) {
                            sb.append("0");
                        }
                        sb.append(hex);
                    }
                    sb.append("> ");
                    break;
                }
                sb.append("(").append(obj).append(") ");
                break;
            }
            case 3: {
                PdfDictionary dict = (PdfDictionary)obj;
                sb.append("<<");
                for (PdfName key : dict.keySet()) {
                    sb.append(key).append(" ");
                    this.append(sb, dict.get(key, false));
                }
                sb.append(">> ");
                break;
            }
            default: {
                sb.append(obj).append(" ");
            }
        }
    }

    protected void initAttributes() {
        attributemap = new HashMap<String, Map<Object, Object>>();
        HashMap<Object, Color> opConstructionPainting = new HashMap<Object, Color>();
        Color darkorange = new Color(255, 140, 0);
        opConstructionPainting.put(StyleConstants.Foreground, darkorange);
        opConstructionPainting.put(StyleConstants.Background, Color.WHITE);
        attributemap.put("m", opConstructionPainting);
        attributemap.put("l", opConstructionPainting);
        attributemap.put("c", opConstructionPainting);
        attributemap.put("v", opConstructionPainting);
        attributemap.put("y", opConstructionPainting);
        attributemap.put("h", opConstructionPainting);
        attributemap.put("re", opConstructionPainting);
        attributemap.put("S", opConstructionPainting);
        attributemap.put("s", opConstructionPainting);
        attributemap.put("f", opConstructionPainting);
        attributemap.put("F", opConstructionPainting);
        attributemap.put("f*", opConstructionPainting);
        attributemap.put("B", opConstructionPainting);
        attributemap.put("B*", opConstructionPainting);
        attributemap.put("b", opConstructionPainting);
        attributemap.put("b*", opConstructionPainting);
        attributemap.put("n", opConstructionPainting);
        attributemap.put("W", opConstructionPainting);
        attributemap.put("W*", opConstructionPainting);
        HashMap<Object, Serializable> graphicsdelim = new HashMap<Object, Serializable>();
        graphicsdelim.put(StyleConstants.Foreground, Color.WHITE);
        graphicsdelim.put(StyleConstants.Background, Color.RED);
        graphicsdelim.put(StyleConstants.Bold, Boolean.valueOf(true));
        attributemap.put("q", graphicsdelim);
        attributemap.put("Q", graphicsdelim);
        HashMap<Object, Color> graphics = new HashMap<Object, Color>();
        graphics.put(StyleConstants.Foreground, Color.RED);
        graphics.put(StyleConstants.Background, Color.WHITE);
        attributemap.put("w", graphics);
        attributemap.put("J", graphics);
        attributemap.put("j", graphics);
        attributemap.put("M", graphics);
        attributemap.put("d", graphics);
        attributemap.put("ri", graphics);
        attributemap.put("i", graphics);
        attributemap.put("gs", graphics);
        attributemap.put("cm", graphics);
        attributemap.put("g", graphics);
        attributemap.put("G", graphics);
        attributemap.put("rg", graphics);
        attributemap.put("RG", graphics);
        attributemap.put("k", graphics);
        attributemap.put("K", graphics);
        attributemap.put("cs", graphics);
        attributemap.put("CS", graphics);
        attributemap.put("sc", graphics);
        attributemap.put("SC", graphics);
        attributemap.put("scn", graphics);
        attributemap.put("SCN", graphics);
        attributemap.put("sh", graphics);
        HashMap<Object, Color> xObject = new HashMap<Object, Color>();
        xObject.put(StyleConstants.Foreground, Color.BLACK);
        xObject.put(StyleConstants.Background, Color.YELLOW);
        attributemap.put("Do", xObject);
        HashMap<Object, Serializable> inlineImage = new HashMap<Object, Serializable>();
        inlineImage.put(StyleConstants.Foreground, Color.BLACK);
        inlineImage.put(StyleConstants.Background, Color.YELLOW);
        inlineImage.put(StyleConstants.Italic, Boolean.valueOf(true));
        attributemap.put("BI", inlineImage);
        attributemap.put("EI", inlineImage);
        HashMap<Object, Serializable> textdelim = new HashMap<Object, Serializable>();
        textdelim.put(StyleConstants.Foreground, Color.WHITE);
        textdelim.put(StyleConstants.Background, Color.BLUE);
        textdelim.put(StyleConstants.Bold, Boolean.valueOf(true));
        attributemap.put("BT", textdelim);
        attributemap.put("ET", textdelim);
        HashMap<Object, Color> text = new HashMap<Object, Color>();
        text.put(StyleConstants.Foreground, Color.BLUE);
        text.put(StyleConstants.Background, Color.WHITE);
        attributemap.put("ID", text);
        attributemap.put("Tc", text);
        attributemap.put("Tw", text);
        attributemap.put("Tz", text);
        attributemap.put("TL", text);
        attributemap.put("Tf", text);
        attributemap.put("Tr", text);
        attributemap.put("Ts", text);
        attributemap.put("Td", text);
        attributemap.put("TD", text);
        attributemap.put("Tm", text);
        attributemap.put("T*", text);
        attributemap.put("Tj", text);
        attributemap.put("'", text);
        attributemap.put("\"", text);
        attributemap.put("TJ", text);
        HashMap<Object, Color> markedContent = new HashMap<Object, Color>();
        markedContent.put(StyleConstants.Foreground, Color.MAGENTA);
        markedContent.put(StyleConstants.Background, Color.WHITE);
        attributemap.put("BMC", markedContent);
        attributemap.put("BDC", markedContent);
        attributemap.put("EMC", markedContent);
    }

    private void setTextEditableRoutine(boolean editable) {
        this.text.setEditable(editable);
        if (pdfStreamGetInputStreamMethod != null && editable && this.target != null && this.target.getPdfObject() instanceof PdfStream) {
            try {
                this.popupMenu.setSaveToStreamEnabled(pdfStreamGetInputStreamMethod.invoke((Object)this.target.getPdfObject(), new Object[0]) == null);
                return;
            }
            catch (Exception any) {
                LoggerHelper.error("Cannot check for null inputStream from PdfStream", any, this.getClass());
            }
        }
        this.popupMenu.setSaveToStreamEnabled(false);
    }

    private void clearPane() {
        this.target = null;
        this.manager.discardAllEdits();
        this.manager.setLimit(0);
        this.text.setText("");
        this.setTextEditableRoutine(false);
    }

    static {
        try {
            pdfStreamGetInputStreamMethod = PdfStream.class.getDeclaredMethod("getInputStream", new Class[0]);
            pdfStreamGetInputStreamMethod.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException any) {
            pdfStreamGetInputStreamMethod = null;
            LoggerHelper.error("Reflection error from PdfStream. Editing of pdfStreams will be disabled", any, PdfReaderController.class);
        }
    }
}

