/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.event.RupsEvent;
import com.itextpdf.rups.model.IndirectObjectFactory;
import com.itextpdf.rups.model.ObjectLoader;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.models.JTableAutoModel;
import com.itextpdf.rups.view.models.JTableAutoModelInterface;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;

public class XRefTable
extends JTable
implements JTableAutoModelInterface,
Observer {
    protected IndirectObjectFactory objects;
    protected PdfReaderController controller;

    public XRefTable(PdfReaderController controller) {
        this.controller = controller;
        this.setModel(new JTableAutoModel(this));
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (observable instanceof PdfReaderController && obj instanceof RupsEvent) {
            RupsEvent event = (RupsEvent)obj;
            switch (event.getType()) {
                case 2: {
                    this.objects = null;
                    this.setModel(new JTableAutoModel(this));
                    this.repaint();
                    return;
                }
                case 1: {
                    ObjectLoader loader = (ObjectLoader)event.getContent();
                    this.objects = loader.getObjects();
                    this.setModel(new JTableAutoModel(this));
                    TableColumn col = this.getColumnModel().getColumn(0);
                    col.setPreferredWidth(5);
                    break;
                }
                case 16: {
                    this.setModel(new JTableAutoModel(this));
                }
            }
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.objects == null) {
            return 0;
        }
        return this.objects.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getObjectReferenceByRow(rowIndex);
            }
            case 1: {
                return this.getObjectDescriptionByRow(rowIndex);
            }
        }
        return null;
    }

    protected int getObjectReferenceByRow(int rowIndex) {
        return this.objects.getRefByIndex(rowIndex);
    }

    protected String getObjectDescriptionByRow(int rowIndex) {
        PdfObject object = this.objects.getObjectByIndex(rowIndex);
        if (object instanceof PdfNull && !this.objects.isLoadedByIndex(rowIndex)) {
            return "Indirect object";
        }
        return PdfObjectTreeNode.getCaption(object);
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Number";
            }
            case 1: {
                return "Object";
            }
        }
        return null;
    }

    protected PdfObject getObjectByRow(int rowIndex) {
        return this.objects.loadObjectByReference(this.getObjectReferenceByRow(rowIndex));
    }

    public void selectRowByReference(int ref) {
        int row = this.objects.getIndexByRef(ref);
        this.setRowSelectionInterval(row, row);
        this.scrollRectToVisible(this.getCellRect(row, 1, true));
        this.valueChanged(null);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt != null) {
            super.valueChanged(evt);
        }
        if (this.controller != null && this.objects != null) {
            this.controller.selectNode(this.getObjectReferenceByRow(this.getSelectedRow()));
        }
    }
}

