/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext.treenodes;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.rups.model.LoggerHelper;
import com.itextpdf.rups.view.icons.IconFetcher;
import com.itextpdf.rups.view.icons.IconTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfPageTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfPagesTreeNode;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

public class PdfObjectTreeNode
extends IconTreeNode {
    protected PdfObject object;
    protected PdfName key = null;
    protected int number = -1;
    protected boolean recursive = false;

    protected PdfObjectTreeNode(PdfObject object) {
        super(null, PdfObjectTreeNode.getCaption(object));
        this.object = object;
        switch (object.getType()) {
            case 5: {
                if (this.isRecursive()) {
                    this.icon = IconFetcher.getIcon("ref_recursive.png");
                    break;
                }
                this.icon = IconFetcher.getIcon("ref.png");
                break;
            }
            case 1: {
                this.icon = IconFetcher.getIcon("array.png");
                break;
            }
            case 3: {
                this.icon = IconFetcher.getIcon("dictionary.png");
                break;
            }
            case 9: {
                this.icon = IconFetcher.getIcon("stream.png");
                break;
            }
            case 2: {
                this.icon = IconFetcher.getIcon("boolean.png");
                break;
            }
            case 6: {
                this.icon = IconFetcher.getIcon("name.png");
                break;
            }
            case 4: 
            case 7: {
                this.icon = IconFetcher.getIcon("null.png");
                break;
            }
            case 8: {
                this.icon = IconFetcher.getIcon("number.png");
                break;
            }
            case 10: {
                this.icon = IconFetcher.getIcon("string.png");
            }
        }
    }

    protected PdfObjectTreeNode(String icon, PdfObject object) {
        super(icon, PdfObjectTreeNode.getCaption(object));
        this.object = object;
    }

    public static PdfObjectTreeNode getInstance(PdfObject object) {
        if (object.isDictionary()) {
            if (PdfName.Page.equals(((PdfDictionary)object).get(PdfName.Type, false))) {
                return new PdfPageTreeNode((PdfDictionary)object);
            }
            if (PdfName.Pages.equals(((PdfDictionary)object).get(PdfName.Type, false))) {
                return new PdfPagesTreeNode((PdfDictionary)object);
            }
        }
        return new PdfObjectTreeNode(object);
    }

    public static PdfObjectTreeNode getInstance(PdfObject object, int number) {
        PdfObjectTreeNode node = PdfObjectTreeNode.getInstance(object);
        node.number = number;
        return node;
    }

    public static PdfObjectTreeNode getInstance(PdfDictionary dict, PdfName key) {
        PdfObjectTreeNode node = PdfObjectTreeNode.getInstance(dict.get(key, false));
        node.setUserObject(PdfObjectTreeNode.getDictionaryEntryCaption(dict, key));
        node.key = key;
        return node;
    }

    public PdfObject getPdfObject() {
        return this.object;
    }

    public int getNumber() {
        if (this.isIndirect() && this.object.getIndirectReference() != null) {
            return this.object.getIndirectReference().getObjNumber();
        }
        if (this.isIndirectReference()) {
            return ((PdfIndirectReference)this.object).getObjNumber();
        }
        return this.number;
    }

    public boolean isIndirectReference() {
        return this.object.isIndirectReference();
    }

    public boolean isIndirect() {
        return this.object.isIndirect();
    }

    public boolean isArray() {
        return this.object.isArray();
    }

    public boolean isDictionaryNode(PdfName key) {
        return key != null && key.equals(this.key);
    }

    public PdfObjectTreeNode getDictionaryChildNode(PdfName key) {
        Enumeration<TreeNode> children = this.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            PdfObjectTreeNode child = (PdfObjectTreeNode)children.nextElement();
            if (!child.isDictionaryNode(key)) continue;
            return child;
        }
        return null;
    }

    public boolean isDictionary() {
        return this.object.isDictionary();
    }

    public boolean isStream() {
        return this.object.isStream();
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public static String getCaption(PdfObject object) {
        if (object == null) {
            return "null";
        }
        switch (object.getType()) {
            case 5: {
                String reffedCaption = PdfObjectTreeNode.getCaption(((PdfIndirectReference)object).getRefersTo(false));
                return object.toString() + " -> " + reffedCaption;
            }
            case 1: {
                return "Array";
            }
            case 9: {
                PdfName type = ((PdfDictionary)object).getAsName(PdfName.Type);
                if (type == null) {
                    return "Stream";
                }
                return "Stream of type: " + type;
            }
            case 10: {
                return ((PdfString)object).toUnicodeString();
            }
            case 3: {
                PdfName type = ((PdfDictionary)object).getAsName(PdfName.Type);
                if (type == null) {
                    return "Dictionary";
                }
                return "Dictionary of type: " + type;
            }
        }
        return object.toString();
    }

    public static String getDictionaryEntryCaption(PdfDictionary dict, PdfName key) {
        StringBuilder buf = new StringBuilder(key.toString());
        buf.append(": ");
        PdfObject valObj = dict.get(key, false);
        buf.append(PdfObjectTreeNode.getCaption(valObj));
        return buf.toString();
    }

    public PdfObjectTreeNode getAncestor() {
        try {
            if (this.isRecursive()) {
                PdfObjectTreeNode node = this;
                while (!(node = (PdfObjectTreeNode)node.getParent()).isIndirectReference() || node.getNumber() != this.getNumber()) {
                }
                return node;
            }
        }
        catch (NullPointerException e) {
            LoggerHelper.warn("Parent node is null for ", (Exception)e, this.getClass());
        }
        return null;
    }
}

