/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.models;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.rups.model.LoggerHelper;
import com.itextpdf.rups.model.PdfSyntaxParser;
import com.itextpdf.rups.model.PdfSyntaxUtils;
import com.itextpdf.rups.view.models.AbstractPdfObjectPanelTableModel;
import java.awt.Component;
import java.util.ArrayList;

public class DictionaryTableModel
extends AbstractPdfObjectPanelTableModel {
    private boolean pluginMode;
    private PdfSyntaxParser parser;
    private Component parent;
    protected PdfDictionary dictionary;
    protected ArrayList<PdfName> keys = new ArrayList();
    private String tempKey = "/";
    private String tempValue = "";

    public DictionaryTableModel(PdfDictionary dictionary, boolean pluginMode, PdfSyntaxParser parser, Component owner) {
        this.pluginMode = pluginMode;
        this.dictionary = dictionary;
        this.parser = parser;
        this.parent = owner;
        this.keys.addAll(dictionary.keySet());
    }

    @Override
    public int getColumnCount() {
        return this.pluginMode ? 2 : 3;
    }

    @Override
    public int getRowCount() {
        return this.pluginMode ? this.dictionary.size() : this.dictionary.size() + 1;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !this.pluginMode && columnIndex < 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int lastRow = this.keys.size();
        if (rowIndex == lastRow) {
            if (columnIndex == 0) {
                return this.tempKey;
            }
            if (columnIndex == 1) {
                return this.tempValue;
            }
        }
        switch (columnIndex) {
            case 0: {
                return this.keys.get(rowIndex);
            }
            case 1: {
                return PdfSyntaxUtils.getSyntaxString(this.dictionary.get(this.keys.get(rowIndex), false));
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int rowCount = this.getRowCount();
        if (rowIndex == rowCount - 1) {
            if (columnIndex == 0) {
                this.tempKey = (String)aValue;
                if (!this.tempKey.startsWith("/")) {
                    this.tempKey = "/" + this.tempKey;
                }
            } else if (columnIndex == 1) {
                this.tempValue = (String)aValue;
            }
        } else {
            if (!(aValue instanceof String) || "".equalsIgnoreCase(((String)aValue).trim())) {
                LoggerHelper.warn("Don't leave fields empty.", this.getClass());
                return;
            }
            if (columnIndex == 0) {
                String key = (String)aValue;
                PdfName oldName = this.keys.get(rowIndex);
                PdfName newName = this.getCorrectKey(key);
                if (newName == null) {
                    return;
                }
                PdfObject pdfObject = this.dictionary.get(oldName, false);
                this.removeRow(rowIndex);
                this.addRow(newName, pdfObject);
            } else {
                String value = (String)aValue;
                PdfObject newValue = this.parser.parseString(value, this.parent);
                if (newValue != null) {
                    PdfName oldName = this.keys.get(rowIndex);
                    this.removeRow(rowIndex);
                    this.addRow(oldName, newValue);
                }
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Key";
            }
            case 1: {
                return "Value";
            }
            case 2: {
                return "";
            }
        }
        return null;
    }

    @Override
    public int getButtonColumn() {
        return 2;
    }

    @Override
    public void removeRow(int rowIndex) {
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        this.dictionary.remove(this.keys.get(rowIndex));
        this.keys.remove(rowIndex);
        this.fireTableDataChanged();
    }

    @Override
    public void validateTempRow() {
        if ("".equalsIgnoreCase(this.tempKey.trim()) || "".equalsIgnoreCase(this.tempValue.trim())) {
            LoggerHelper.warn("Don't leave fields empty.", this.getClass());
            return;
        }
        PdfName key = this.getCorrectKey(this.tempKey);
        if (key == null) {
            return;
        }
        PdfObject value = this.parser.parseString(this.tempValue, this.parent);
        if (value != null) {
            if (this.dictionary.containsKey(key)) {
                LoggerHelper.warn("This key already exist in dictionary. Please edit existing entry.", this.getClass());
            } else {
                this.addRow(key, value);
                this.tempKey = "/";
                this.tempValue = "";
            }
            this.fireTableDataChanged();
        }
    }

    private void addRow(PdfName key, PdfObject value) {
        this.dictionary.put(key, value);
        int index = -1;
        for (PdfName name : this.dictionary.keySet()) {
            ++index;
            if (!name.equals(key)) continue;
            break;
        }
        this.keys.add(index, key);
        this.fireTableRowsInserted(index, index);
    }

    private PdfName getCorrectKey(String value) {
        PdfObject result;
        if (!value.startsWith("/")) {
            value = "/" + value;
        }
        if ((result = this.parser.parseString(value)) instanceof PdfName) {
            return (PdfName)result;
        }
        LoggerHelper.error("Key value isn't value Name object.", this.getClass());
        return null;
    }
}

