/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.models;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.rups.model.LoggerHelper;
import com.itextpdf.rups.model.PdfSyntaxParser;
import com.itextpdf.rups.model.PdfSyntaxUtils;
import com.itextpdf.rups.view.models.AbstractPdfObjectPanelTableModel;
import java.awt.Component;
import javax.swing.JOptionPane;

public class PdfArrayTableModel
extends AbstractPdfObjectPanelTableModel {
    protected PdfArray array;
    private boolean pluginMode;
    private PdfSyntaxParser parser;
    private Component parent;
    private String tempValue = "";

    public PdfArrayTableModel(PdfArray array, boolean pluginMode, PdfSyntaxParser parser, Component parent) {
        this.array = array;
        this.pluginMode = pluginMode;
        this.parser = parser;
        this.parent = parent;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !this.pluginMode && columnIndex < 1;
    }

    @Override
    public int getColumnCount() {
        return this.pluginMode ? 1 : 2;
    }

    @Override
    public int getRowCount() {
        return this.array.size() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (rowIndex == this.array.size()) {
                return this.tempValue;
            }
            return PdfSyntaxUtils.getSyntaxString(this.array.get(rowIndex, false));
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int rowCount = this.getRowCount();
        if (rowIndex == rowCount - 1) {
            if (columnIndex == 0) {
                this.tempValue = (String)aValue;
            }
        } else {
            String value;
            PdfObject newValue;
            if (!(aValue instanceof String) || "".equalsIgnoreCase(((String)aValue).trim())) {
                LoggerHelper.warn("Don't leave fields empty.", this.getClass());
                return;
            }
            if (columnIndex == 0 && (newValue = this.parser.parseString(value = (String)aValue, this.parent)) != null) {
                this.removeRow(rowIndex);
                this.addRow(rowIndex, newValue);
            }
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Array";
            }
            case 1: {
                return "";
            }
        }
        return null;
    }

    @Override
    public void removeRow(int rowIndex) {
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        this.array.remove(rowIndex);
        this.fireTableDataChanged();
    }

    @Override
    public void validateTempRow() {
        if ("".equalsIgnoreCase(this.tempValue.trim())) {
            LoggerHelper.warn("Don't leave fields empty.", this.getClass());
            return;
        }
        PdfObject value = this.parser.parseString(this.tempValue, this.parent);
        if (value != null) {
            int index;
            while (true) {
                String result;
                if ((result = JOptionPane.showInputDialog(this.parent, "Choose array index", this.array.size())) == null) {
                    return;
                }
                try {
                    index = Integer.valueOf(result);
                }
                catch (NumberFormatException any) {
                    LoggerHelper.warn("The typed index isn't integer.", (Exception)any, this.getClass());
                    continue;
                }
                if (0 <= index && index <= this.array.size()) break;
                LoggerHelper.warn("The typed index is not in range.", this.getClass());
            }
            this.addRow(index, value);
            this.tempValue = "";
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getButtonColumn() {
        return 1;
    }

    private void addRow(int index, PdfObject value) {
        this.array.add(index, value);
        this.fireTableRowsInserted(index, index);
    }
}

