"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigLogger = exports.CONFIG_LABEL = void 0;
const core_1 = require("@zwave-js/core");
exports.CONFIG_LABEL = "CONFIG";
const CONFIG_LOGLEVEL = "debug";
class ConfigLogger extends core_1.ZWaveLoggerBase {
    constructor(loggers) {
        super(loggers, exports.CONFIG_LABEL);
    }
    /**
     * Logs a message
     * @param msg The message to output
     */
    print(message, level) {
        const actualLevel = level || CONFIG_LOGLEVEL;
        if (!this.container.isLoglevelVisible(actualLevel))
            return;
        this.logger.log({
            level: actualLevel,
            message,
            direction: core_1.getDirectionPrefix("none"),
        });
    }
}
exports.ConfigLogger = ConfigLogger;
//# sourceMappingURL=Logger.js.map