"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMinimumShiftForBitMask = exports.validatePayload = exports.stripUndefined = exports.isConsecutiveArray = void 0;
const objects_1 = require("alcalzone-shared/objects");
const ZWaveError_1 = require("../error/ZWaveError");
/** Ensures that the values array is consecutive */
function isConsecutiveArray(values) {
    return values.every((v, i, arr) => (i === 0 ? true : v - 1 === arr[i - 1]));
}
exports.isConsecutiveArray = isConsecutiveArray;
/** Returns an object that includes all non-undefined properties from the original one */
function stripUndefined(obj) {
    const ret = {};
    for (const [key, value] of objects_1.entries(obj)) {
        if (value !== undefined)
            ret[key] = value;
    }
    return ret;
}
exports.stripUndefined = stripUndefined;
function validatePayloadInternal(reason, ...assertions) {
    if (!assertions.every(Boolean)) {
        throw new ZWaveError_1.ZWaveError("The message payload is invalid!", ZWaveError_1.ZWaveErrorCodes.PacketFormat_InvalidPayload, reason);
    }
}
// Export and augment the validatePayload method with a reason
exports.validatePayload = validatePayloadInternal.bind(undefined, undefined);
exports.validatePayload.withReason = (reason) => validatePayloadInternal.bind(undefined, reason);
/**
 * Determines how many bits a value must be shifted to be right-aligned with a given bit mask
 * Example:
 * ```txt
 *   Mask = 00110000
 *             ^---- => 4 bits
 *
 *   Mask = 00110001
 *                 ^ => 0 bits
 * ```
 */
function getMinimumShiftForBitMask(mask) {
    let i = 0;
    while (mask % 2 === 0) {
        mask >>>= 1;
        if (mask === 0)
            break;
        i++;
    }
    return i;
}
exports.getMinimumShiftForBitMask = getMinimumShiftForBitMask;
//# sourceMappingURL=misc.js.map