"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssociationGroupInfoCCCommandListGet = exports.AssociationGroupInfoCCCommandListReport = exports.AssociationGroupInfoCCInfoGet = exports.AssociationGroupInfoCCInfoReport = exports.AssociationGroupInfoCCNameGet = exports.AssociationGroupInfoCCNameReport = exports.AssociationGroupInfoCC = exports.AssociationGroupInfoCCAPI = exports.AssociationGroupInfoProfile = exports.AssociationGroupInfoCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// @noSetValueAPI This CC only has get-type commands
// All the supported commands
var AssociationGroupInfoCommand;
(function (AssociationGroupInfoCommand) {
    AssociationGroupInfoCommand[AssociationGroupInfoCommand["NameGet"] = 1] = "NameGet";
    AssociationGroupInfoCommand[AssociationGroupInfoCommand["NameReport"] = 2] = "NameReport";
    AssociationGroupInfoCommand[AssociationGroupInfoCommand["InfoGet"] = 3] = "InfoGet";
    AssociationGroupInfoCommand[AssociationGroupInfoCommand["InfoReport"] = 4] = "InfoReport";
    AssociationGroupInfoCommand[AssociationGroupInfoCommand["CommandListGet"] = 5] = "CommandListGet";
    AssociationGroupInfoCommand[AssociationGroupInfoCommand["CommandListReport"] = 6] = "CommandListReport";
})(AssociationGroupInfoCommand = exports.AssociationGroupInfoCommand || (exports.AssociationGroupInfoCommand = {}));
// TODO: Check if this should be in a config file instead
/**
 * @publicAPI
 */
var AssociationGroupInfoProfile;
(function (AssociationGroupInfoProfile) {
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["General: N/A"] = 0] = "General: N/A";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["General: Lifeline"] = 1] = "General: Lifeline";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 01"] = 8193] = "Control: Key 01";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 02"] = 8194] = "Control: Key 02";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 03"] = 8195] = "Control: Key 03";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 04"] = 8196] = "Control: Key 04";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 05"] = 8197] = "Control: Key 05";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 06"] = 8198] = "Control: Key 06";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 07"] = 8199] = "Control: Key 07";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 08"] = 8200] = "Control: Key 08";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 09"] = 8201] = "Control: Key 09";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 10"] = 8202] = "Control: Key 10";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 11"] = 8203] = "Control: Key 11";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 12"] = 8204] = "Control: Key 12";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 13"] = 8205] = "Control: Key 13";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 14"] = 8206] = "Control: Key 14";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 15"] = 8207] = "Control: Key 15";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 16"] = 8208] = "Control: Key 16";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 17"] = 8209] = "Control: Key 17";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 18"] = 8210] = "Control: Key 18";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 19"] = 8211] = "Control: Key 19";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 20"] = 8212] = "Control: Key 20";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 21"] = 8213] = "Control: Key 21";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 22"] = 8214] = "Control: Key 22";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 23"] = 8215] = "Control: Key 23";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 24"] = 8216] = "Control: Key 24";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 25"] = 8217] = "Control: Key 25";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 26"] = 8218] = "Control: Key 26";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 27"] = 8219] = "Control: Key 27";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 28"] = 8220] = "Control: Key 28";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 29"] = 8221] = "Control: Key 29";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 30"] = 8222] = "Control: Key 30";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 31"] = 8223] = "Control: Key 31";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Control: Key 32"] = 8224] = "Control: Key 32";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Air temperature"] = 12545] = "Sensor: Air temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: General purpose"] = 12546] = "Sensor: General purpose";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Illuminance"] = 12547] = "Sensor: Illuminance";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Power"] = 12548] = "Sensor: Power";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Humidity"] = 12549] = "Sensor: Humidity";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Velocity"] = 12550] = "Sensor: Velocity";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Direction"] = 12551] = "Sensor: Direction";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Atmospheric pressure"] = 12552] = "Sensor: Atmospheric pressure";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Barometric pressure"] = 12553] = "Sensor: Barometric pressure";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Solar radiation"] = 12554] = "Sensor: Solar radiation";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Dew point"] = 12555] = "Sensor: Dew point";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Rain rate"] = 12556] = "Sensor: Rain rate";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Tide level"] = 12557] = "Sensor: Tide level";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Weight"] = 12558] = "Sensor: Weight";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Voltage"] = 12559] = "Sensor: Voltage";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Current"] = 12560] = "Sensor: Current";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Carbon dioxide (CO2) level"] = 12561] = "Sensor: Carbon dioxide (CO2) level";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Air flow"] = 12562] = "Sensor: Air flow";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Tank capacity"] = 12563] = "Sensor: Tank capacity";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Distance"] = 12564] = "Sensor: Distance";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Angle position"] = 12565] = "Sensor: Angle position";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Rotation"] = 12566] = "Sensor: Rotation";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Water temperature"] = 12567] = "Sensor: Water temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Soil temperature"] = 12568] = "Sensor: Soil temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Seismic Intensity"] = 12569] = "Sensor: Seismic Intensity";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Seismic magnitude"] = 12570] = "Sensor: Seismic magnitude";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Ultraviolet"] = 12571] = "Sensor: Ultraviolet";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Electrical resistivity"] = 12572] = "Sensor: Electrical resistivity";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Electrical conductivity"] = 12573] = "Sensor: Electrical conductivity";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Loudness"] = 12574] = "Sensor: Loudness";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Moisture"] = 12575] = "Sensor: Moisture";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Frequency"] = 12576] = "Sensor: Frequency";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Time"] = 12577] = "Sensor: Time";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Target temperature"] = 12578] = "Sensor: Target temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Particulate Matter 2.5"] = 12579] = "Sensor: Particulate Matter 2.5";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Formaldehyde (CH2O) level"] = 12580] = "Sensor: Formaldehyde (CH2O) level";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Radon concentration"] = 12581] = "Sensor: Radon concentration";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Methane (CH4) density"] = 12582] = "Sensor: Methane (CH4) density";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Volatile Organic Compound level"] = 12583] = "Sensor: Volatile Organic Compound level";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Carbon monoxide (CO) level"] = 12584] = "Sensor: Carbon monoxide (CO) level";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Soil humidity"] = 12585] = "Sensor: Soil humidity";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Soil reactivity"] = 12586] = "Sensor: Soil reactivity";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Soil salinity"] = 12587] = "Sensor: Soil salinity";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Heart rate"] = 12588] = "Sensor: Heart rate";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Blood pressure"] = 12589] = "Sensor: Blood pressure";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Muscle mass"] = 12590] = "Sensor: Muscle mass";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Fat mass"] = 12591] = "Sensor: Fat mass";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Bone mass"] = 12592] = "Sensor: Bone mass";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Total body water (TBW)"] = 12593] = "Sensor: Total body water (TBW)";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Basis metabolic rate (BMR)"] = 12594] = "Sensor: Basis metabolic rate (BMR)";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Body Mass Index (BMI)"] = 12595] = "Sensor: Body Mass Index (BMI)";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Acceleration X-axis"] = 12596] = "Sensor: Acceleration X-axis";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Acceleration Y-axis"] = 12597] = "Sensor: Acceleration Y-axis";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Acceleration Z-axis"] = 12598] = "Sensor: Acceleration Z-axis";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Smoke density"] = 12599] = "Sensor: Smoke density";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Water flow"] = 12600] = "Sensor: Water flow";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Water pressure"] = 12601] = "Sensor: Water pressure";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: RF signal strength"] = 12602] = "Sensor: RF signal strength";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Particulate Matter 10"] = 12603] = "Sensor: Particulate Matter 10";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Respiratory rate"] = 12604] = "Sensor: Respiratory rate";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Relative Modulation level"] = 12605] = "Sensor: Relative Modulation level";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Boiler water temperature"] = 12606] = "Sensor: Boiler water temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Domestic Hot Water (DHW) temperature"] = 12607] = "Sensor: Domestic Hot Water (DHW) temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Outside temperature"] = 12608] = "Sensor: Outside temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Exhaust temperature"] = 12609] = "Sensor: Exhaust temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Water Chlorine level"] = 12610] = "Sensor: Water Chlorine level";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Water acidity"] = 12611] = "Sensor: Water acidity";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Water Oxidation reduction potential"] = 12612] = "Sensor: Water Oxidation reduction potential";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Heart Rate LF/HF ratio"] = 12613] = "Sensor: Heart Rate LF/HF ratio";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Motion Direction"] = 12614] = "Sensor: Motion Direction";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Applied force on the sensor"] = 12615] = "Sensor: Applied force on the sensor";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Return Air temperature"] = 12616] = "Sensor: Return Air temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Supply Air temperature"] = 12617] = "Sensor: Supply Air temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Condenser Coil temperature"] = 12618] = "Sensor: Condenser Coil temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Evaporator Coil temperature"] = 12619] = "Sensor: Evaporator Coil temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Liquid Line temperature"] = 12620] = "Sensor: Liquid Line temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Discharge Line temperature"] = 12621] = "Sensor: Discharge Line temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Suction Pressure"] = 12622] = "Sensor: Suction Pressure";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Discharge Pressure"] = 12623] = "Sensor: Discharge Pressure";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Sensor: Defrost temperature"] = 12624] = "Sensor: Defrost temperature";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Smoke Alarm"] = 28929] = "Notification: Smoke Alarm";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: CO Alarm"] = 28930] = "Notification: CO Alarm";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: CO2 Alarm"] = 28931] = "Notification: CO2 Alarm";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Heat Alarm"] = 28932] = "Notification: Heat Alarm";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Water Alarm"] = 28933] = "Notification: Water Alarm";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Access Control"] = 28934] = "Notification: Access Control";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Home Security"] = 28935] = "Notification: Home Security";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Power Management"] = 28936] = "Notification: Power Management";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: System"] = 28937] = "Notification: System";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Emergency Alarm"] = 28938] = "Notification: Emergency Alarm";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Clock"] = 28939] = "Notification: Clock";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Appliance"] = 28940] = "Notification: Appliance";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Home Health"] = 28941] = "Notification: Home Health";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Siren"] = 28942] = "Notification: Siren";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Water Valve"] = 28943] = "Notification: Water Valve";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Weather Alarm"] = 28944] = "Notification: Weather Alarm";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Irrigation"] = 28945] = "Notification: Irrigation";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Gas alarm"] = 28946] = "Notification: Gas alarm";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Pest Control"] = 28947] = "Notification: Pest Control";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Light sensor"] = 28948] = "Notification: Light sensor";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Water Quality Monitoring"] = 28949] = "Notification: Water Quality Monitoring";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Notification: Home monitoring"] = 28950] = "Notification: Home monitoring";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Meter: Electric"] = 12801] = "Meter: Electric";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Meter: Gas"] = 12802] = "Meter: Gas";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Meter: Water"] = 12803] = "Meter: Water";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Meter: Heating"] = 12804] = "Meter: Heating";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Meter: Cooling"] = 12805] = "Meter: Cooling";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 01"] = 27393] = "Irrigation: Channel 01";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 02"] = 27394] = "Irrigation: Channel 02";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 03"] = 27395] = "Irrigation: Channel 03";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 04"] = 27396] = "Irrigation: Channel 04";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 05"] = 27397] = "Irrigation: Channel 05";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 06"] = 27398] = "Irrigation: Channel 06";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 07"] = 27399] = "Irrigation: Channel 07";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 08"] = 27400] = "Irrigation: Channel 08";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 09"] = 27401] = "Irrigation: Channel 09";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 10"] = 27402] = "Irrigation: Channel 10";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 11"] = 27403] = "Irrigation: Channel 11";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 12"] = 27404] = "Irrigation: Channel 12";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 13"] = 27405] = "Irrigation: Channel 13";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 14"] = 27406] = "Irrigation: Channel 14";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 15"] = 27407] = "Irrigation: Channel 15";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 16"] = 27408] = "Irrigation: Channel 16";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 17"] = 27409] = "Irrigation: Channel 17";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 18"] = 27410] = "Irrigation: Channel 18";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 19"] = 27411] = "Irrigation: Channel 19";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 20"] = 27412] = "Irrigation: Channel 20";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 21"] = 27413] = "Irrigation: Channel 21";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 22"] = 27414] = "Irrigation: Channel 22";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 23"] = 27415] = "Irrigation: Channel 23";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 24"] = 27416] = "Irrigation: Channel 24";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 25"] = 27417] = "Irrigation: Channel 25";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 26"] = 27418] = "Irrigation: Channel 26";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 27"] = 27419] = "Irrigation: Channel 27";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 28"] = 27420] = "Irrigation: Channel 28";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 29"] = 27421] = "Irrigation: Channel 29";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 30"] = 27422] = "Irrigation: Channel 30";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 31"] = 27423] = "Irrigation: Channel 31";
    AssociationGroupInfoProfile[AssociationGroupInfoProfile["Irrigation: Channel 32"] = 27424] = "Irrigation: Channel 32";
})(AssociationGroupInfoProfile = exports.AssociationGroupInfoProfile || (exports.AssociationGroupInfoProfile = {}));
/** Returns the ValueID used to store the name of an association group */
function getGroupNameValueID(groupId) {
    return {
        commandClass: core_1.CommandClasses["Association Group Information"],
        property: "name",
        propertyKey: groupId,
    };
}
/** Returns the ValueID used to store info for an association group */
function getGroupInfoValueID(groupId) {
    return {
        commandClass: core_1.CommandClasses["Association Group Information"],
        property: "info",
        propertyKey: groupId,
    };
}
/** Returns the ValueID used to store info for an association group */
function getIssuedCommandsValueID(groupId) {
    return {
        commandClass: core_1.CommandClasses["Association Group Information"],
        property: "issuedCommands",
        propertyKey: groupId,
    };
}
let AssociationGroupInfoCCAPI = class AssociationGroupInfoCCAPI extends API_1.PhysicalCCAPI {
    supportsCommand(cmd) {
        switch (cmd) {
            case AssociationGroupInfoCommand.NameGet:
            case AssociationGroupInfoCommand.InfoGet:
            case AssociationGroupInfoCommand.CommandListGet:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    async getGroupName(groupId) {
        this.assertSupportsCommand(AssociationGroupInfoCommand, AssociationGroupInfoCommand.NameGet);
        const cc = new AssociationGroupInfoCCNameGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            groupId,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response)
            return response.name;
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getGroupInfo(groupId, refreshCache = false) {
        this.assertSupportsCommand(AssociationGroupInfoCommand, AssociationGroupInfoCommand.InfoGet);
        const cc = new AssociationGroupInfoCCInfoGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            groupId,
            refreshCache,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            // SDS13782: If List Mode is set to 0, the Group Count field MUST be set to 1.
            const { groupId: _, ...info } = response.groups[0];
            return {
                hasDynamicInfo: response.hasDynamicInfo,
                ...info,
            };
        }
    }
    async getCommands(groupId, allowCache = true) {
        this.assertSupportsCommand(AssociationGroupInfoCommand, AssociationGroupInfoCommand.CommandListGet);
        const cc = new AssociationGroupInfoCCCommandListGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            groupId,
            allowCache,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response)
            return response.commands;
    }
};
AssociationGroupInfoCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Association Group Information"])
], AssociationGroupInfoCCAPI);
exports.AssociationGroupInfoCCAPI = AssociationGroupInfoCCAPI;
let AssociationGroupInfoCC = class AssociationGroupInfoCC extends CommandClass_1.CommandClass {
    constructor(driver, options) {
        super(driver, options);
        this.registerValue(getGroupNameValueID(0).property, true);
        this.registerValue(getGroupInfoValueID(0).property, true);
    }
    determineRequiredCCInterviews() {
        // AssociationCC must be interviewed after Z-Wave+ if that is supported
        return [
            ...super.determineRequiredCCInterviews(),
            core_1.CommandClasses.Association,
            core_1.CommandClasses["Multi Channel Association"],
        ];
    }
    skipEndpointInterview() {
        // The associations are managed on the root device
        return true;
    }
    /** Returns the name of an association group */
    getGroupNameCached(groupId) {
        return this.getValueDB().getValue(getGroupNameValueID(groupId));
    }
    /** Returns the association profile for an association group */
    getGroupProfileCached(groupId) {
        var _a;
        return (_a = this.getValueDB().getValue(getGroupInfoValueID(groupId))) === null || _a === void 0 ? void 0 : _a.profile;
    }
    /** Returns the dictionary of all commands issued by the given association group */
    getIssuedCommandsCached(groupId) {
        return this.getValueDB().getValue(getIssuedCommandsValueID(groupId));
    }
    findGroupsForIssuedCommand(ccId, command) {
        const ret = [];
        const associationGroupCount = this.getAssociationGroupCountCached();
        for (let groupId = 1; groupId <= associationGroupCount; groupId++) {
            // Scan the issued commands of all groups if there's a match
            const issuedCommands = this.getIssuedCommandsCached(groupId);
            if (!issuedCommands)
                continue;
            if (issuedCommands.has(ccId) &&
                issuedCommands.get(ccId).includes(command)) {
                ret.push(groupId);
                continue;
            }
        }
        return ret;
    }
    getAssociationGroupCountCached() {
        var _a, _b;
        const endpoint = this.getEndpoint();
        // The association group count is either determined by the
        // Association CC or the Multi Channel Association CC
        // First query the Multi Channel Association CC
        return (((_a = endpoint
            .createCCInstanceUnsafe(core_1.CommandClasses["Multi Channel Association"])) === null || _a === void 0 ? void 0 : _a.getGroupCountCached()) || ((_b = 
        // Then the Association CC
        endpoint
            .createCCInstanceUnsafe(core_1.CommandClasses.Association)) === null || _b === void 0 ? void 0 : _b.getGroupCountCached()) ||
            // And fall back to 0
            0);
    }
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Association Group Information"].withOptions({ priority: Constants_1.MessagePriority.NodeQuery });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        const associationGroupCount = this.getAssociationGroupCountCached();
        for (let groupId = 1; groupId <= associationGroupCount; groupId++) {
            if (complete) {
                // First get the group's name
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `Association group #${groupId}: Querying name...`,
                    direction: "outbound",
                });
                const name = await api.getGroupName(groupId);
                if (name) {
                    const logMessage = `Association group #${groupId} has name "${name}"`;
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: logMessage,
                        direction: "inbound",
                    });
                }
            }
            // Even if this is a partial interview, we need to refresh information
            // for nodes with dynamic associations
            let hasDynamicInfo;
            if (!complete) {
                hasDynamicInfo = this.getValueDB().getValue({
                    commandClass: this.ccId,
                    property: "hasDynamicInfo",
                });
            }
            if (complete || hasDynamicInfo) {
                // Then its information
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `Association group #${groupId}: Querying info...`,
                    direction: "outbound",
                });
                const info = await api.getGroupInfo(groupId, !!hasDynamicInfo);
                if (info) {
                    const logMessage = `Received info for association group #${groupId}:
info is dynamic: ${info.hasDynamicInfo}
profile:         ${shared_1.getEnumMemberName(AssociationGroupInfoProfile, info.profile)}`;
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: logMessage,
                        direction: "inbound",
                    });
                }
            }
            if (complete) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `Association group #${groupId}: Querying command list...`,
                    direction: "outbound",
                });
                await api.getCommands(groupId);
                // Not sure how to log this
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
AssociationGroupInfoCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Association Group Information"]),
    CommandClass_1.implementedVersion(3)
], AssociationGroupInfoCC);
exports.AssociationGroupInfoCC = AssociationGroupInfoCC;
let AssociationGroupInfoCCNameReport = class AssociationGroupInfoCCNameReport extends AssociationGroupInfoCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this.groupId = this.payload[0];
        const nameLength = this.payload[1];
        core_1.validatePayload(this.payload.length >= 2 + nameLength);
        this.name = this.payload.slice(2, 2 + nameLength).toString("utf8");
        this.persistValues();
    }
    persistValues() {
        const valueId = getGroupNameValueID(this.groupId);
        this.getValueDB().setValue(valueId, this.name);
        return true;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "group id": this.groupId,
                name: this.name,
            },
        };
    }
};
AssociationGroupInfoCCNameReport = __decorate([
    CommandClass_1.CCCommand(AssociationGroupInfoCommand.NameReport)
], AssociationGroupInfoCCNameReport);
exports.AssociationGroupInfoCCNameReport = AssociationGroupInfoCCNameReport;
let AssociationGroupInfoCCNameGet = class AssociationGroupInfoCCNameGet extends AssociationGroupInfoCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.groupId = options.groupId;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.groupId]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "group id": this.groupId },
        };
    }
};
AssociationGroupInfoCCNameGet = __decorate([
    CommandClass_1.CCCommand(AssociationGroupInfoCommand.NameGet),
    CommandClass_1.expectedCCResponse(AssociationGroupInfoCCNameReport)
], AssociationGroupInfoCCNameGet);
exports.AssociationGroupInfoCCNameGet = AssociationGroupInfoCCNameGet;
let AssociationGroupInfoCCInfoReport = class AssociationGroupInfoCCInfoReport extends AssociationGroupInfoCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this.isListMode = !!(this.payload[0] & 128);
        this.hasDynamicInfo = !!(this.payload[0] & 64);
        const groupCount = this.payload[0] & 63;
        // each group requires 7 bytes of payload
        core_1.validatePayload(this.payload.length >= 1 + groupCount * 7);
        const _groups = [];
        for (let i = 0; i < groupCount; i++) {
            const offset = 1 + i * 7;
            // Parse the payload
            const groupBytes = this.payload.slice(offset, offset + 7);
            const groupId = groupBytes[0];
            const mode = 0; //groupBytes[1];
            const profile = groupBytes.readUInt16BE(2);
            const eventCode = 0; // groupBytes.readUInt16BE(5);
            _groups.push({ groupId, mode, profile, eventCode });
        }
        this.groups = _groups;
        this.persistValues();
    }
    persistValues() {
        if (!super.persistValues())
            return false;
        for (const group of this.groups) {
            const { groupId, mode, profile, eventCode } = group;
            const valueId = getGroupInfoValueID(groupId);
            this.getValueDB().setValue(valueId, {
                mode,
                profile,
                eventCode,
            });
        }
        return true;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "is list mode": this.isListMode,
                "has dynamic info": this.hasDynamicInfo,
                groups: `${this.groups
                    .map((g) => `
· Group #${g.groupId}
  mode:       ${g.mode}
  profile:    ${g.profile}
  event code: ${g.eventCode}`)
                    .join("")}`,
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], AssociationGroupInfoCCInfoReport.prototype, "hasDynamicInfo", void 0);
AssociationGroupInfoCCInfoReport = __decorate([
    CommandClass_1.CCCommand(AssociationGroupInfoCommand.InfoReport)
], AssociationGroupInfoCCInfoReport);
exports.AssociationGroupInfoCCInfoReport = AssociationGroupInfoCCInfoReport;
let AssociationGroupInfoCCInfoGet = class AssociationGroupInfoCCInfoGet extends AssociationGroupInfoCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.refreshCache = options.refreshCache;
            if ("listMode" in options)
                this.listMode = options.listMode;
            if ("groupId" in options)
                this.groupId = options.groupId;
        }
    }
    serialize() {
        const isListMode = this.listMode === true;
        const optionByte = (this.refreshCache ? 128 : 0) |
            (isListMode ? 64 : 0);
        this.payload = Buffer.from([
            optionByte,
            isListMode ? 0 : this.groupId,
        ]);
        return super.serialize();
    }
    toLogEntry() {
        const message = {};
        if (this.groupId != undefined) {
            message["group id"] = this.groupId;
        }
        if (this.listMode != undefined) {
            message["list mode"] = this.listMode;
        }
        message["refresh cache"] = this.refreshCache;
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
AssociationGroupInfoCCInfoGet = __decorate([
    CommandClass_1.CCCommand(AssociationGroupInfoCommand.InfoGet),
    CommandClass_1.expectedCCResponse(AssociationGroupInfoCCInfoReport)
], AssociationGroupInfoCCInfoGet);
exports.AssociationGroupInfoCCInfoGet = AssociationGroupInfoCCInfoGet;
let AssociationGroupInfoCCCommandListReport = class AssociationGroupInfoCCCommandListReport extends AssociationGroupInfoCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        const groupId = this.payload[0];
        const listLength = this.payload[1];
        core_1.validatePayload(this.payload.length >= 2 + listLength);
        const listBytes = this.payload.slice(2, 2 + listLength);
        // Parse all CC ids and commands
        let offset = 0;
        const commands = new Map();
        while (offset < listLength) {
            const { ccId, bytesRead } = core_1.parseCCId(listBytes, offset);
            const command = listBytes[offset + bytesRead];
            if (!commands.has(ccId))
                commands.set(ccId, []);
            commands.get(ccId).push(command);
            offset += bytesRead + 1;
        }
        this.issuedCommands = [groupId, commands];
        this.persistValues();
    }
    get groupId() {
        return this.issuedCommands[0];
    }
    get commands() {
        return this.issuedCommands[1];
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "group id": this.groupId,
                commands: `${[...this.commands]
                    .map(([cc, cmds]) => {
                    return `\n· ${core_1.getCCName(cc)}: ${cmds
                        .map((cmd) => shared_1.num2hex(cmd))
                        .join(", ")}`;
                })
                    .join("")}`,
            },
        };
    }
};
__decorate([
    CommandClass_1.ccKeyValuePair({ internal: true })
], AssociationGroupInfoCCCommandListReport.prototype, "issuedCommands", void 0);
AssociationGroupInfoCCCommandListReport = __decorate([
    CommandClass_1.CCCommand(AssociationGroupInfoCommand.CommandListReport)
], AssociationGroupInfoCCCommandListReport);
exports.AssociationGroupInfoCCCommandListReport = AssociationGroupInfoCCCommandListReport;
let AssociationGroupInfoCCCommandListGet = class AssociationGroupInfoCCCommandListGet extends AssociationGroupInfoCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.allowCache = options.allowCache;
            this.groupId = options.groupId;
        }
    }
    serialize() {
        this.payload = Buffer.from([
            this.allowCache ? 128 : 0,
            this.groupId,
        ]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "group id": this.groupId,
                "allow cache": this.allowCache,
            },
        };
    }
};
AssociationGroupInfoCCCommandListGet = __decorate([
    CommandClass_1.CCCommand(AssociationGroupInfoCommand.CommandListGet),
    CommandClass_1.expectedCCResponse(AssociationGroupInfoCCCommandListReport)
], AssociationGroupInfoCCCommandListGet);
exports.AssociationGroupInfoCCCommandListGet = AssociationGroupInfoCCCommandListGet;

//# sourceMappingURL=AssociationGroupInfoCC.js.map
