/// <reference types="node" />
import { Duration, Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import { AllOrNone } from "@zwave-js/shared";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum BasicCommand {
    Set = 1,
    Get = 2,
    Report = 3
}
export declare function getTargetValueValueId(endpoint?: number): ValueID;
export declare function getCurrentValueValueId(endpoint?: number): ValueID;
export declare function getCompatEventValueId(endpoint?: number): ValueID;
export declare class BasicCCAPI extends CCAPI {
    supportsCommand(cmd: BasicCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    private refreshTimeout;
    protected [POLL_VALUE]: PollValueImplementation;
    get(): Promise<Pick<BasicCCReport, "targetValue" | "currentValue" | "duration"> | undefined>;
    set(targetValue: number): Promise<void>;
}
export declare class BasicCC extends CommandClass {
    ccCommand: BasicCommand;
    interview(complete?: boolean): Promise<void>;
}
interface BasicCCSetOptions extends CCCommandOptions {
    targetValue: number;
}
export declare class BasicCCSet extends BasicCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | BasicCCSetOptions);
    targetValue: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
declare type BasicCCReportOptions = CCCommandOptions & {
    currentValue: number;
} & AllOrNone<{
    targetValue: number;
    duration: Duration;
}>;
export declare class BasicCCReport extends BasicCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | BasicCCReportOptions);
    private _currentValue;
    get currentValue(): Maybe<number> | undefined;
    private _targetValue;
    get targetValue(): number | undefined;
    private _duration;
    get duration(): Duration | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class BasicCCGet extends BasicCC {
}
export {};
