"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CRC16CCCommandEncapsulation = exports.CRC16CC = exports.CRC16CCAPI = exports.CRC16Command = void 0;
const core_1 = require("@zwave-js/core");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// @noSetValueAPI
// @noInterview This CC only has a single encapsulation command
// All the supported commands
var CRC16Command;
(function (CRC16Command) {
    CRC16Command[CRC16Command["CommandEncapsulation"] = 1] = "CommandEncapsulation";
})(CRC16Command = exports.CRC16Command || (exports.CRC16Command = {}));
let CRC16CCAPI = class CRC16CCAPI extends API_1.CCAPI {
    supportsCommand(_cmd) {
        // switch (cmd) {
        // 	case CRC16Command.CommandEncapsulation:
        return true; // This is mandatory
        // }
        // return super.supportsCommand(cmd);
    }
    async sendEncapsulated(encapsulatedCC) {
        this.assertSupportsCommand(CRC16Command, CRC16Command.CommandEncapsulation);
        const cc = new CRC16CCCommandEncapsulation(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            encapsulated: encapsulatedCC,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
CRC16CCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["CRC-16 Encapsulation"])
], CRC16CCAPI);
exports.CRC16CCAPI = CRC16CCAPI;
let CRC16CC = class CRC16CC extends CommandClass_1.CommandClass {
    /** Encapsulates a command in a CRC-16 CC */
    static encapsulate(driver, cc) {
        return new CRC16CCCommandEncapsulation(driver, {
            nodeId: cc.nodeId,
            encapsulated: cc,
        });
    }
};
CRC16CC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["CRC-16 Encapsulation"]),
    CommandClass_1.implementedVersion(1)
], CRC16CC);
exports.CRC16CC = CRC16CC;
// This indirection is necessary to be able to define the same CC as the response
function getResponseForCommandEncapsulation() {
    return CRC16CCCommandEncapsulation;
}
let CRC16CCCommandEncapsulation = class CRC16CCCommandEncapsulation extends CRC16CC {
    constructor(driver, options) {
        super(driver, options);
        this.headerBuffer = Buffer.from([this.ccId, this.ccCommand]);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 3);
            const ccBuffer = this.payload.slice(0, -2);
            // Verify the CRC
            let expectedCRC = core_1.CRC16_CCITT(this.headerBuffer);
            expectedCRC = core_1.CRC16_CCITT(ccBuffer, expectedCRC);
            const actualCRC = this.payload.readUInt16BE(this.payload.length - 2);
            core_1.validatePayload(expectedCRC === actualCRC);
            this.encapsulated = CommandClass_1.CommandClass.from(this.driver, {
                data: ccBuffer,
                fromEncapsulation: true,
                encapCC: this,
            });
        }
        else {
            this.encapsulated = options.encapsulated;
            options.encapsulated.encapsulatingCC = this;
        }
    }
    serialize() {
        const commandBuffer = this.encapsulated.serialize();
        // Reserve 2 bytes for the CRC
        this.payload = Buffer.concat([commandBuffer, Buffer.allocUnsafe(2)]);
        // Compute and save the CRC16 in the payload
        // The CC header is included in the CRC computation
        let crc = core_1.CRC16_CCITT(this.headerBuffer);
        crc = core_1.CRC16_CCITT(commandBuffer, crc);
        this.payload.writeUInt16BE(crc, this.payload.length - 2);
        return super.serialize();
    }
    computeEncapsulationOverhead() {
        // CRC16 adds two bytes CRC to the default overhead
        return super.computeEncapsulationOverhead() + 2;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            // Hide the default payload line
            message: undefined,
        };
    }
};
CRC16CCCommandEncapsulation = __decorate([
    CommandClass_1.CCCommand(CRC16Command.CommandEncapsulation),
    CommandClass_1.expectedCCResponse(getResponseForCommandEncapsulation)
], CRC16CCCommandEncapsulation);
exports.CRC16CCCommandEncapsulation = CRC16CCCommandEncapsulation;

//# sourceMappingURL=CRC16CC.js.map
