"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ColorSwitchCCStopLevelChange = exports.ColorSwitchCCStartLevelChange = exports.ColorSwitchCCSet = exports.ColorSwitchCCGet = exports.ColorSwitchCCReport = exports.ColorSwitchCCSupportedGet = exports.ColorSwitchCCSupportedReport = exports.ColorSwitchCC = exports.ColorSwitchCCAPI = exports.ColorComponent = exports.ColorSwitchCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const math_1 = require("alcalzone-shared/math");
const objects_1 = require("alcalzone-shared/objects");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
const MultilevelSwitchCC_1 = require("./MultilevelSwitchCC");
// All the supported commands
var ColorSwitchCommand;
(function (ColorSwitchCommand) {
    ColorSwitchCommand[ColorSwitchCommand["SupportedGet"] = 1] = "SupportedGet";
    ColorSwitchCommand[ColorSwitchCommand["SupportedReport"] = 2] = "SupportedReport";
    ColorSwitchCommand[ColorSwitchCommand["Get"] = 3] = "Get";
    ColorSwitchCommand[ColorSwitchCommand["Report"] = 4] = "Report";
    ColorSwitchCommand[ColorSwitchCommand["Set"] = 5] = "Set";
    ColorSwitchCommand[ColorSwitchCommand["StartLevelChange"] = 6] = "StartLevelChange";
    ColorSwitchCommand[ColorSwitchCommand["StopLevelChange"] = 7] = "StopLevelChange";
})(ColorSwitchCommand = exports.ColorSwitchCommand || (exports.ColorSwitchCommand = {}));
/**
 * @publicAPI
 */
var ColorComponent;
(function (ColorComponent) {
    ColorComponent[ColorComponent["Warm White"] = 0] = "Warm White";
    ColorComponent[ColorComponent["Cold White"] = 1] = "Cold White";
    ColorComponent[ColorComponent["Red"] = 2] = "Red";
    ColorComponent[ColorComponent["Green"] = 3] = "Green";
    ColorComponent[ColorComponent["Blue"] = 4] = "Blue";
    ColorComponent[ColorComponent["Amber"] = 5] = "Amber";
    ColorComponent[ColorComponent["Cyan"] = 6] = "Cyan";
    ColorComponent[ColorComponent["Purple"] = 7] = "Purple";
    ColorComponent[ColorComponent["Index"] = 8] = "Index";
})(ColorComponent = exports.ColorComponent || (exports.ColorComponent = {}));
const ColorComponentMap = {
    warmWhite: ColorComponent["Warm White"],
    coldWhite: ColorComponent["Cold White"],
    red: ColorComponent.Red,
    green: ColorComponent.Green,
    blue: ColorComponent.Blue,
    amber: ColorComponent.Amber,
    cyan: ColorComponent.Cyan,
    purple: ColorComponent.Purple,
    index: ColorComponent.Index,
};
const hexColorRegex = /^#?(?<red>[0-9a-f]{2})(?<green>[0-9a-f]{2})(?<blue>[0-9a-f]{2})$/i;
const colorTableKeys = [
    ...shared_1.keysOf(ColorComponent),
    ...shared_1.keysOf(ColorComponentMap),
];
function colorTableKeyToComponent(key) {
    if (/^\d+$/.test(key)) {
        return parseInt(key, 10);
    }
    else if (key in ColorComponentMap) {
        return ColorComponentMap[key];
    }
    else if (key in ColorComponent) {
        return ColorComponent[key];
    }
    throw new core_1.ZWaveError(`Invalid color key ${key}!`, core_1.ZWaveErrorCodes.Argument_Invalid);
}
function getSupportedColorComponentsValueID(endpointIndex) {
    return {
        commandClass: core_1.CommandClasses["Color Switch"],
        endpoint: endpointIndex,
        property: "supportedColorComponents",
    };
}
function getCurrentColorValueID(endpointIndex, component) {
    return {
        commandClass: core_1.CommandClasses["Color Switch"],
        property: "currentColor",
        endpoint: endpointIndex,
        propertyKey: component,
    };
}
function getTargetColorValueID(endpointIndex, component) {
    return {
        commandClass: core_1.CommandClasses["Color Switch"],
        property: "targetColor",
        endpoint: endpointIndex,
        propertyKey: component,
    };
}
function getSupportsHexColorValueID(endpointIndex) {
    return {
        commandClass: core_1.CommandClasses["Color Switch"],
        property: "supportsHexColor",
        endpoint: endpointIndex,
    };
}
function getHexColorValueID(endpointIndex) {
    return {
        commandClass: core_1.CommandClasses["Color Switch"],
        property: "hexColor",
        endpoint: endpointIndex,
    };
}
let ColorSwitchCCAPI = class ColorSwitchCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, propertyKey }, value) => {
            if (property === "targetColor") {
                if (propertyKey == undefined) {
                    API_1.throwMissingPropertyKey(this.ccId, property);
                }
                else if (typeof propertyKey !== "number") {
                    API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
                }
                // Single color component, only accepts numbers
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                await this.set({ [propertyKey]: value });
                if (this.isSinglecast()) {
                    // Verify the current value after a delay
                    // TODO: #1321
                    const duration = undefined;
                    this.schedulePoll({ property, propertyKey }, duration === null || duration === void 0 ? void 0 : duration.toMilliseconds());
                }
            }
            else if (property === "hexColor") {
                // No property key, this is the hex color #rrggbb
                if (typeof value !== "string") {
                    API_1.throwWrongValueType(this.ccId, property, "string", typeof value);
                }
                await this.set({ hexColor: value });
            }
            else {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
        this[_b] = async ({ property, propertyKey, }) => {
            var _c, _d, _e;
            if (propertyKey == undefined) {
                API_1.throwMissingPropertyKey(this.ccId, property);
            }
            else if (typeof propertyKey !== "number") {
                API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
            }
            switch (property) {
                case "currentColor":
                    return (_c = (await this.get(propertyKey))) === null || _c === void 0 ? void 0 : _c.currentValue;
                case "targetColor":
                    return (_d = (await this.get(propertyKey))) === null || _d === void 0 ? void 0 : _d.targetValue;
                case "duration":
                    return (_e = (await this.get(propertyKey))) === null || _e === void 0 ? void 0 : _e.duration;
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case ColorSwitchCommand.SupportedGet:
            case ColorSwitchCommand.Get:
                return this.isSinglecast();
            case ColorSwitchCommand.Set:
            case ColorSwitchCommand.StartLevelChange:
            case ColorSwitchCommand.StopLevelChange:
                return true; // These are mandatory
        }
        return super.supportsCommand(cmd);
    }
    async getSupported() {
        this.assertSupportsCommand(ColorSwitchCommand, ColorSwitchCommand.SupportedGet);
        const cc = new ColorSwitchCCSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.supportedColorComponents;
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get(component) {
        this.assertSupportsCommand(ColorSwitchCommand, ColorSwitchCommand.Get);
        const cc = new ColorSwitchCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            colorComponent: component,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["currentValue", "targetValue", "duration"]);
        }
    }
    async set(options) {
        var _c;
        this.assertSupportsCommand(ColorSwitchCommand, ColorSwitchCommand.Set);
        const cc = new ColorSwitchCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            ...options,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
        // If the command did not fail, assume that it succeeded and update the values accordingly
        // TODO: The API methods should not modify the value DB directly, but to do so
        // this requires a nicer way of synchronizing hexColor with the others
        if (this.isSinglecast()) {
            const valueDB = (_c = this.endpoint.getNodeUnsafe()) === null || _c === void 0 ? void 0 : _c.valueDB;
            if (valueDB) {
                // each color component separately
                let updatedRGB = false;
                for (const [key, value] of objects_1.entries(cc.colorTable)) {
                    const component = colorTableKeyToComponent(key);
                    if (component === ColorComponent.Red ||
                        component === ColorComponent.Green ||
                        component === ColorComponent.Blue) {
                        updatedRGB = true;
                    }
                    valueDB.setValue(getCurrentColorValueID(this.endpoint.index, component), value, { noEvent: true });
                }
                // and hex color if necessary
                const supportsHex = valueDB.getValue(getSupportsHexColorValueID(this.endpoint.index));
                if (supportsHex && updatedRGB) {
                    const hexValueId = getHexColorValueID(this.endpoint.index);
                    const [r, g, b] = [
                        ColorComponent.Red,
                        ColorComponent.Green,
                        ColorComponent.Blue,
                    ].map((c) => { var _c; return (_c = valueDB.getValue(getCurrentColorValueID(this.endpoint.index, c))) !== null && _c !== void 0 ? _c : 0; });
                    const hexValue = (r << 16) | (g << 8) | b;
                    valueDB.setValue(hexValueId, hexValue.toString(16).padStart(6, "0"));
                }
            }
        }
    }
    async startLevelChange(options) {
        this.assertSupportsCommand(ColorSwitchCommand, ColorSwitchCommand.StartLevelChange);
        const cc = new ColorSwitchCCStartLevelChange(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            ...options,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async stopLevelChange(colorComponent) {
        this.assertSupportsCommand(ColorSwitchCommand, ColorSwitchCommand.StopLevelChange);
        const cc = new ColorSwitchCCStopLevelChange(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            colorComponent,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
ColorSwitchCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Color Switch"])
], ColorSwitchCCAPI);
exports.ColorSwitchCCAPI = ColorSwitchCCAPI;
let ColorSwitchCC = class ColorSwitchCC extends CommandClass_1.CommandClass {
    constructor(driver, options) {
        super(driver, options);
        this.registerValue(getSupportsHexColorValueID(0).property, true);
    }
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Color Switch"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        const valueDB = this.getValueDB();
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        let supportedColors;
        if (complete) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "querying supported colors...",
                direction: "outbound",
            });
            supportedColors = await api.getSupported();
            if (!supportedColors) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "Querying supported colors timed out, skipping interview...",
                    level: "warn",
                });
                return;
            }
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `received supported colors:${supportedColors
                    .map((c) => `\n· ${shared_1.getEnumMemberName(ColorComponent, c)}`)
                    .join("")}`,
                direction: "outbound",
            });
            // Create metadata
            for (const color of supportedColors) {
                const colorName = shared_1.getEnumMemberName(ColorComponent, color);
                valueDB.setMetadata(getCurrentColorValueID(this.endpointIndex, color), {
                    ...core_1.ValueMetadata.ReadOnlyUInt8,
                    label: `Current value (${colorName})`,
                    description: `The current value of the ${colorName} color.`,
                });
                valueDB.setMetadata(getTargetColorValueID(this.endpointIndex, color), {
                    ...core_1.ValueMetadata.UInt8,
                    label: `Target value (${colorName})`,
                    description: `The target value of the ${colorName} color.`,
                });
            }
            // Create the collective HEX color values
            const supportsHex = [
                ColorComponent.Red,
                ColorComponent.Green,
                ColorComponent.Blue,
            ].every((c) => supportedColors.includes(c));
            valueDB.setValue(getSupportsHexColorValueID(this.endpointIndex), supportsHex);
            if (supportsHex) {
                valueDB.setMetadata(getHexColorValueID(this.endpointIndex), {
                    ...core_1.ValueMetadata.Color,
                    minLength: 6,
                    maxLength: 7,
                    label: `RGB Color`,
                });
            }
        }
        else {
            supportedColors = valueDB.getValue(getSupportedColorComponentsValueID(this.endpointIndex));
        }
        for (const color of supportedColors) {
            const colorName = shared_1.getEnumMemberName(ColorComponent, color);
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `querying current color state (${colorName})`,
                direction: "outbound",
            });
            await api.get(color);
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
    translatePropertyKey(property, propertyKey) {
        if ((property === "currentColor" || property === "targetColor") &&
            typeof propertyKey === "number") {
            const translated = ColorComponent[propertyKey];
            if (translated)
                return translated;
        }
        return super.translatePropertyKey(property, propertyKey);
    }
};
ColorSwitchCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Color Switch"]),
    CommandClass_1.implementedVersion(3)
], ColorSwitchCC);
exports.ColorSwitchCC = ColorSwitchCC;
let ColorSwitchCCSupportedReport = class ColorSwitchCCSupportedReport extends ColorSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        // Docs say 'variable length', but the table shows 2 bytes.
        core_1.validatePayload(this.payload.length >= 2);
        this.supportedColorComponents = core_1.parseBitMask(this.payload.slice(0, 2), ColorComponent["Warm White"]);
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "supported color components": this.supportedColorComponents
                    .map((c) => `\n· ${shared_1.getEnumMemberName(ColorComponent, c)}`)
                    .join(""),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ColorSwitchCCSupportedReport.prototype, "supportedColorComponents", void 0);
ColorSwitchCCSupportedReport = __decorate([
    CommandClass_1.CCCommand(ColorSwitchCommand.SupportedReport)
], ColorSwitchCCSupportedReport);
exports.ColorSwitchCCSupportedReport = ColorSwitchCCSupportedReport;
let ColorSwitchCCSupportedGet = class ColorSwitchCCSupportedGet extends ColorSwitchCC {
};
ColorSwitchCCSupportedGet = __decorate([
    CommandClass_1.CCCommand(ColorSwitchCommand.SupportedGet),
    CommandClass_1.expectedCCResponse(ColorSwitchCCSupportedReport)
], ColorSwitchCCSupportedGet);
exports.ColorSwitchCCSupportedGet = ColorSwitchCCSupportedGet;
let ColorSwitchCCReport = class ColorSwitchCCReport extends ColorSwitchCC {
    constructor(driver, options) {
        var _c;
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this.colorComponent = this.payload[0];
        this.currentValue = this.payload[1];
        if (this.version >= 3 && this.payload.length >= 4) {
            this.targetValue = this.payload[2];
            this.duration = core_1.Duration.parseReport(this.payload[3]);
        }
        const valueDB = this.getValueDB();
        const valueId = getCurrentColorValueID(this.endpointIndex, this.colorComponent);
        valueDB.setValue(valueId, this.currentValue);
        // Update target value if required
        if (this.targetValue != undefined) {
            const targetValueId = getTargetColorValueID(this.endpointIndex, this.colorComponent);
            valueDB.setValue(targetValueId, this.targetValue);
        }
        // Update collective hex value if required
        const supportsHex = valueDB.getValue(getSupportsHexColorValueID(this.endpointIndex));
        if (supportsHex &&
            (this.colorComponent === ColorComponent.Red ||
                this.colorComponent === ColorComponent.Green ||
                this.colorComponent === ColorComponent.Blue)) {
            const hexValueId = getHexColorValueID(this.endpointIndex);
            const hexValue = (_c = valueDB.getValue(hexValueId)) !== null && _c !== void 0 ? _c : "000000";
            const byteOffset = ColorComponent.Blue - this.colorComponent;
            const byteMask = 0xff << (byteOffset * 8);
            let hexValueNumeric = parseInt(hexValue, 16);
            hexValueNumeric =
                (hexValueNumeric & ~byteMask) |
                    (this.currentValue << (byteOffset * 8));
            valueDB.setValue(hexValueId, hexValueNumeric.toString(16).padStart(6, "0"));
        }
        // For duration, which is stored globally instead of per component
        this.persistValues();
    }
    toLogEntry() {
        const message = {
            "color component": shared_1.getEnumMemberName(ColorComponent, this.colorComponent),
            "current value": this.currentValue,
        };
        if (this.targetValue != undefined) {
            message["target value"] = this.targetValue;
        }
        if (this.duration != undefined) {
            message.duration = this.duration.toString();
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Duration,
        label: "Remaining duration",
    })
], ColorSwitchCCReport.prototype, "duration", void 0);
ColorSwitchCCReport = __decorate([
    CommandClass_1.CCCommand(ColorSwitchCommand.Report)
], ColorSwitchCCReport);
exports.ColorSwitchCCReport = ColorSwitchCCReport;
function testResponseForColorSwitchGet(sent, received) {
    return sent.colorComponent === received.colorComponent;
}
let ColorSwitchCCGet = class ColorSwitchCCGet extends ColorSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this._colorComponent = options.colorComponent;
        }
    }
    get colorComponent() {
        return this._colorComponent;
    }
    set colorComponent(value) {
        if (!ColorComponent[value]) {
            throw new core_1.ZWaveError("colorComponent must be a valid color component index.", core_1.ZWaveErrorCodes.Argument_Invalid);
        }
        this._colorComponent = value;
    }
    serialize() {
        this.payload = Buffer.from([this._colorComponent]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "color component": shared_1.getEnumMemberName(ColorComponent, this.colorComponent),
            },
        };
    }
};
ColorSwitchCCGet = __decorate([
    CommandClass_1.CCCommand(ColorSwitchCommand.Get),
    CommandClass_1.expectedCCResponse(ColorSwitchCCReport, testResponseForColorSwitchGet)
], ColorSwitchCCGet);
exports.ColorSwitchCCGet = ColorSwitchCCGet;
let ColorSwitchCCSet = class ColorSwitchCCSet extends ColorSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            // Populate properties from options object
            if ("hexColor" in options) {
                const match = hexColorRegex.exec(options.hexColor);
                if (!match) {
                    throw new core_1.ZWaveError(`${options.hexColor} is not a valid HEX color string`, core_1.ZWaveErrorCodes.Argument_Invalid);
                }
                this.colorTable = {
                    red: parseInt(match.groups.red, 16),
                    green: parseInt(match.groups.green, 16),
                    blue: parseInt(match.groups.blue, 16),
                };
            }
            else {
                this.colorTable = shared_1.pick(options, colorTableKeys);
            }
            this.duration = options.duration;
        }
    }
    serialize() {
        const populatedColorCount = Object.keys(this.colorTable).length;
        this.payload = Buffer.allocUnsafe(1 + populatedColorCount * 2 + (this.version >= 2 ? 1 : 0));
        this.payload[0] = populatedColorCount & 0b11111;
        let i = 1;
        for (const [key, value] of objects_1.entries(this.colorTable)) {
            const component = colorTableKeyToComponent(key);
            this.payload[i] = component;
            this.payload[i + 1] = math_1.clamp(value, 0, 0xff);
            i += 2;
        }
        if (this.version >= 2 && this.duration) {
            this.payload[i] = this.duration.serializeSet();
        }
        return super.serialize();
    }
    toLogEntry() {
        const message = {};
        for (const [key, value] of Object.entries(this.colorTable)) {
            if (value == undefined)
                continue;
            const realKey = key in ColorComponentMap
                ? ColorComponent[ColorComponentMap[key]]
                : ColorComponent[key];
            message[realKey] = value;
        }
        if (this.duration != undefined) {
            message.duration = this.duration.toString();
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
ColorSwitchCCSet = __decorate([
    CommandClass_1.CCCommand(ColorSwitchCommand.Set)
], ColorSwitchCCSet);
exports.ColorSwitchCCSet = ColorSwitchCCSet;
let ColorSwitchCCStartLevelChange = class ColorSwitchCCStartLevelChange extends ColorSwitchCC {
    constructor(driver, options) {
        var _c;
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.duration = options.duration;
            this.ignoreStartLevel = options.ignoreStartLevel;
            this.startLevel = (_c = options.startLevel) !== null && _c !== void 0 ? _c : 0;
            this.direction = options.direction;
            this.colorComponent = options.colorComponent;
        }
    }
    serialize() {
        const controlByte = (MultilevelSwitchCC_1.LevelChangeDirection[this.direction] << 6) |
            (this.ignoreStartLevel ? 32 : 0);
        const payload = [controlByte, this.colorComponent, this.startLevel];
        if (this.version >= 3 && this.duration) {
            payload.push(this.duration.serializeSet());
        }
        this.payload = Buffer.from(payload);
        return super.serialize();
    }
    toLogEntry() {
        const message = {
            "color component": shared_1.getEnumMemberName(ColorComponent, this.colorComponent),
            "start level": `${this.startLevel}${this.ignoreStartLevel ? " (ignored)" : ""}`,
            direction: this.direction,
        };
        if (this.duration != undefined) {
            message.duration = this.duration.toString();
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
ColorSwitchCCStartLevelChange = __decorate([
    CommandClass_1.CCCommand(ColorSwitchCommand.StartLevelChange)
], ColorSwitchCCStartLevelChange);
exports.ColorSwitchCCStartLevelChange = ColorSwitchCCStartLevelChange;
let ColorSwitchCCStopLevelChange = class ColorSwitchCCStopLevelChange extends ColorSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.colorComponent = options.colorComponent;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.colorComponent]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "color component": shared_1.getEnumMemberName(ColorComponent, this.colorComponent),
            },
        };
    }
};
ColorSwitchCCStopLevelChange = __decorate([
    CommandClass_1.CCCommand(ColorSwitchCommand.StopLevelChange)
], ColorSwitchCCStopLevelChange);
exports.ColorSwitchCCStopLevelChange = ColorSwitchCCStopLevelChange;

//# sourceMappingURL=ColorSwitchCC.js.map
