"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DoorLockCCCapabilitiesGet = exports.DoorLockCCCapabilitiesReport = exports.DoorLockCCConfigurationSet = exports.DoorLockCCConfigurationGet = exports.DoorLockCCConfigurationReport = exports.DoorLockCCOperationGet = exports.DoorLockCCOperationReport = exports.DoorLockCCOperationSet = exports.DoorLockCC = exports.DoorLockCCAPI = exports.DoorLockOperationType = exports.DoorLockMode = exports.DoorLockCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const typeguards_1 = require("alcalzone-shared/typeguards");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var DoorLockCommand;
(function (DoorLockCommand) {
    DoorLockCommand[DoorLockCommand["OperationSet"] = 1] = "OperationSet";
    DoorLockCommand[DoorLockCommand["OperationGet"] = 2] = "OperationGet";
    DoorLockCommand[DoorLockCommand["OperationReport"] = 3] = "OperationReport";
    DoorLockCommand[DoorLockCommand["ConfigurationSet"] = 4] = "ConfigurationSet";
    DoorLockCommand[DoorLockCommand["ConfigurationGet"] = 5] = "ConfigurationGet";
    DoorLockCommand[DoorLockCommand["ConfigurationReport"] = 6] = "ConfigurationReport";
    DoorLockCommand[DoorLockCommand["CapabilitiesGet"] = 7] = "CapabilitiesGet";
    DoorLockCommand[DoorLockCommand["CapabilitiesReport"] = 8] = "CapabilitiesReport";
})(DoorLockCommand = exports.DoorLockCommand || (exports.DoorLockCommand = {}));
// @publicAPI
var DoorLockMode;
(function (DoorLockMode) {
    DoorLockMode[DoorLockMode["Unsecured"] = 0] = "Unsecured";
    DoorLockMode[DoorLockMode["UnsecuredWithTimeout"] = 1] = "UnsecuredWithTimeout";
    DoorLockMode[DoorLockMode["InsideUnsecured"] = 16] = "InsideUnsecured";
    DoorLockMode[DoorLockMode["InsideUnsecuredWithTimeout"] = 17] = "InsideUnsecuredWithTimeout";
    DoorLockMode[DoorLockMode["OutsideUnsecured"] = 32] = "OutsideUnsecured";
    DoorLockMode[DoorLockMode["OutsideUnsecuredWithTimeout"] = 33] = "OutsideUnsecuredWithTimeout";
    DoorLockMode[DoorLockMode["Unknown"] = 254] = "Unknown";
    DoorLockMode[DoorLockMode["Secured"] = 255] = "Secured";
})(DoorLockMode = exports.DoorLockMode || (exports.DoorLockMode = {}));
// @publicAPI
var DoorLockOperationType;
(function (DoorLockOperationType) {
    DoorLockOperationType[DoorLockOperationType["Constant"] = 1] = "Constant";
    DoorLockOperationType[DoorLockOperationType["Timed"] = 2] = "Timed";
})(DoorLockOperationType = exports.DoorLockOperationType || (exports.DoorLockOperationType = {}));
function getTargetModeValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Door Lock"],
        endpoint,
        property: "targetMode",
    };
}
function getOperationTypeValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Door Lock"],
        endpoint,
        property: "operationType",
    };
}
const configurationSetParameters = [
    "operationType",
    "outsideHandlesCanOpenDoorConfiguration",
    "insideHandlesCanOpenDoorConfiguration",
    "lockTimeoutConfiguration",
    "autoRelockTime",
    "holdAndReleaseTime",
    "twistAssist",
    "blockToBlock",
];
let DoorLockCCAPI = class DoorLockCCAPI extends API_1.PhysicalCCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            var _c;
            if (property === "targetMode") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                await this.set(value);
                // Verify the current value after a delay
                this.schedulePoll({ property });
            }
            else if (typeof property === "string" &&
                configurationSetParameters.includes(property)) {
                // checking every type here would create a LOT of duplicate code, so we don't
                // ConfigurationSet expects all parameters --> read the others from cache
                const config = {
                    [property]: value,
                };
                for (const param of configurationSetParameters) {
                    if (param !== property) {
                        config[param] = (_c = this.endpoint.getNodeUnsafe()) === null || _c === void 0 ? void 0 : _c.valueDB.getValue({
                            commandClass: this.ccId,
                            endpoint: this.endpoint.index,
                            property: param,
                        });
                    }
                }
                // Fix insideHandlesCanOpenDoorConfiguration is not iterable
                const allTrue = [true, true, true, true];
                // wotan-disable-next-line no-useless-predicate
                if (!config.insideHandlesCanOpenDoorConfiguration) {
                    config.insideHandlesCanOpenDoorConfiguration = allTrue;
                }
                // wotan-disable-next-line no-useless-predicate
                if (!config.outsideHandlesCanOpenDoorConfiguration) {
                    config.outsideHandlesCanOpenDoorConfiguration = allTrue;
                }
                await this.setConfiguration(config);
                // Refresh the current value
                // TODO: #1321, #1521
                await this.getConfiguration();
            }
            else {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
        this[_b] = async ({ property, }) => {
            var _c, _d;
            switch (property) {
                case "currentMode":
                case "targetMode":
                case "duration":
                case "outsideHandlesCanOpenDoor":
                case "insideHandlesCanOpenDoor":
                case "latchStatus":
                case "boltStatus":
                case "doorStatus":
                case "lockTimeout":
                    return (_c = (await this.get())) === null || _c === void 0 ? void 0 : _c[property];
                case "operationType":
                case "outsideHandlesCanOpenDoorConfiguration":
                case "insideHandlesCanOpenDoorConfiguration":
                case "lockTimeoutConfiguration":
                case "autoRelockTime":
                case "holdAndReleaseTime":
                case "twistAssist":
                case "blockToBlock":
                    return (_d = (await this.getConfiguration())) === null || _d === void 0 ? void 0 : _d[property];
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case DoorLockCommand.OperationSet:
            case DoorLockCommand.OperationGet:
            case DoorLockCommand.ConfigurationSet:
            case DoorLockCommand.ConfigurationGet:
                return true; // This is mandatory
            case DoorLockCommand.CapabilitiesGet:
                return this.version >= 4;
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getCapabilities() {
        this.assertSupportsCommand(DoorLockCommand, DoorLockCommand.CapabilitiesGet);
        const cc = new DoorLockCCCapabilitiesGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "autoRelockSupported",
                "blockToBlockSupported",
                "boltSupported",
                "doorSupported",
                "holdAndReleaseSupported",
                "latchSupported",
                "twistAssistSupported",
                "supportedDoorLockModes",
                "supportedInsideHandles",
                "supportedOperationTypes",
                "supportedOutsideHandles",
            ]);
        }
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(DoorLockCommand, DoorLockCommand.OperationGet);
        const cc = new DoorLockCCOperationGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "currentMode",
                "targetMode",
                "duration",
                "outsideHandlesCanOpenDoor",
                "insideHandlesCanOpenDoor",
                "latchStatus",
                "boltStatus",
                "doorStatus",
                "lockTimeout",
            ]);
        }
    }
    async set(mode) {
        this.assertSupportsCommand(DoorLockCommand, DoorLockCommand.OperationSet);
        const cc = new DoorLockCCOperationSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            mode,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async setConfiguration(configuration) {
        this.assertSupportsCommand(DoorLockCommand, DoorLockCommand.ConfigurationSet);
        const cc = new DoorLockCCConfigurationSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            ...configuration,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getConfiguration() {
        this.assertSupportsCommand(DoorLockCommand, DoorLockCommand.ConfigurationGet);
        const cc = new DoorLockCCConfigurationGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "operationType",
                "outsideHandlesCanOpenDoorConfiguration",
                "insideHandlesCanOpenDoorConfiguration",
                "lockTimeoutConfiguration",
                "autoRelockTime",
                "holdAndReleaseTime",
                "twistAssist",
                "blockToBlock",
            ]);
        }
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
DoorLockCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Door Lock"])
], DoorLockCCAPI);
exports.DoorLockCCAPI = DoorLockCCAPI;
let DoorLockCC = class DoorLockCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        var _c, _d, _e, _f;
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Door Lock"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // We need to do some queries after a potential timeout
        // In this case, do now mark this CC as interviewed completely
        let hadCriticalTimeout = false;
        if (complete && this.version >= 4) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "requesting lock capabilities...",
                direction: "outbound",
            });
            const resp = await api.getCapabilities();
            if (resp) {
                const logMessage = `received lock capabilities:
supported operation types: ${resp.supportedOperationTypes
                    .map((t) => shared_1.getEnumMemberName(DoorLockOperationType, t))
                    .join(", ")}
supported door lock modes: ${resp.supportedDoorLockModes
                    .map((t) => shared_1.getEnumMemberName(DoorLockMode, t))
                    .map((str) => `\n· ${str}`)
                    .join(", ")}
supported outside handles: ${resp.supportedOutsideHandles
                    .map(String)
                    .join(", ")}
supported inside handles:  ${resp.supportedInsideHandles.map(String).join(", ")}
supports auto-relock:      ${resp.autoRelockSupported}
supports hold-and-release: ${resp.holdAndReleaseSupported}
supports twist assist:     ${resp.twistAssistSupported}
supports block to block:   ${resp.blockToBlockSupported}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
                // Update metadata of settable states
                const valueDB = this.getValueDB();
                valueDB.setMetadata(getTargetModeValueId(this.endpointIndex), {
                    ...core_1.ValueMetadata.UInt8,
                    states: core_1.enumValuesToMetadataStates(DoorLockMode, resp.supportedDoorLockModes),
                });
                valueDB.setMetadata(getOperationTypeValueId(this.endpointIndex), {
                    ...core_1.ValueMetadata.UInt8,
                    states: core_1.enumValuesToMetadataStates(DoorLockOperationType, resp.supportedOperationTypes),
                });
            }
            else {
                hadCriticalTimeout = true;
            }
        }
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "requesting lock configuration...",
            direction: "outbound",
        });
        const config = await api.getConfiguration();
        if (config) {
            let logMessage = `received lock configuration:
operation type:                ${shared_1.getEnumMemberName(DoorLockOperationType, config.operationType)}`;
            if (config.operationType === DoorLockOperationType.Timed) {
                logMessage += `
lock timeout:                  ${config.lockTimeoutConfiguration} seconds
`;
            }
            logMessage += `
outside handles can open door: ${config.outsideHandlesCanOpenDoorConfiguration
                .map(String)
                .join(", ")}
inside handles can open door:  ${config.insideHandlesCanOpenDoorConfiguration
                .map(String)
                .join(", ")}`;
            if (this.version >= 4) {
                logMessage += `
auto-relock time               ${(_c = config.autoRelockTime) !== null && _c !== void 0 ? _c : "-"} seconds
hold-and-release time          ${(_d = config.holdAndReleaseTime) !== null && _d !== void 0 ? _d : "-"} seconds
twist assist                   ${!!config.twistAssist}
block to block                 ${!!config.blockToBlock}`;
            }
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: logMessage,
                direction: "inbound",
            });
        }
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "requesting current lock status...",
            direction: "outbound",
        });
        const status = await api.get();
        if (status) {
            let logMessage = `received lock status:
current mode:       ${shared_1.getEnumMemberName(DoorLockMode, status.currentMode)}`;
            if (status.targetMode != undefined) {
                logMessage += `
target mode:        ${shared_1.getEnumMemberName(DoorLockMode, status.targetMode)}
remaining duration: ${(_f = (_e = status.duration) === null || _e === void 0 ? void 0 : _e.toString()) !== null && _f !== void 0 ? _f : "undefined"}`;
            }
            if (status.lockTimeout != undefined) {
                logMessage += `
lock timeout:       ${status.lockTimeout} seconds`;
            }
            logMessage += `
door status:        ${status.doorStatus}
bolt status:        ${status.boltStatus}
latch status:       ${status.latchStatus}`;
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: logMessage,
                direction: "inbound",
            });
        }
        // Remember that the interview is complete
        if (!hadCriticalTimeout)
            this.interviewComplete = true;
    }
};
DoorLockCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Door Lock"]),
    CommandClass_1.implementedVersion(4)
], DoorLockCC);
exports.DoorLockCC = DoorLockCC;
let DoorLockCCOperationSet = class DoorLockCCOperationSet extends DoorLockCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            if (options.mode === DoorLockMode.Unknown) {
                throw new core_1.ZWaveError(`Unknown is not a valid door lock target state!`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            this.mode = options.mode;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.mode]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "target mode": shared_1.getEnumMemberName(DoorLockMode, this.mode),
            },
        };
    }
};
DoorLockCCOperationSet = __decorate([
    CommandClass_1.CCCommand(DoorLockCommand.OperationSet)
], DoorLockCCOperationSet);
exports.DoorLockCCOperationSet = DoorLockCCOperationSet;
let DoorLockCCOperationReport = class DoorLockCCOperationReport extends DoorLockCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 5);
        this.currentMode = this.payload[0];
        this.outsideHandlesCanOpenDoor = [
            !!(this.payload[1] & 16),
            !!(this.payload[1] & 32),
            !!(this.payload[1] & 64),
            !!(this.payload[1] & 128),
        ];
        this.insideHandlesCanOpenDoor = [
            !!(this.payload[1] & 0b0001),
            !!(this.payload[1] & 0b0010),
            !!(this.payload[1] & 0b0100),
            !!(this.payload[1] & 0b1000),
        ];
        this.doorStatus = !!(this.payload[2] & 0b1) ? "closed" : "open";
        this.boltStatus = !!(this.payload[2] & 0b10) ? "unlocked" : "locked";
        this.latchStatus = !!(this.payload[2] & 0b100) ? "closed" : "open";
        // Ignore invalid timeout values
        const lockTimeoutMinutes = this.payload[3];
        const lockTimeoutSeconds = this.payload[4];
        if (lockTimeoutMinutes <= 253 && lockTimeoutSeconds <= 59) {
            this.lockTimeout = lockTimeoutSeconds + lockTimeoutMinutes * 60;
        }
        if (this.version >= 3 && this.payload.length >= 7) {
            this.targetMode = this.payload[5];
            this.duration = core_1.Duration.parseReport(this.payload[6]);
        }
        this.persistValues();
    }
    toLogEntry() {
        const message = {
            "current mode": shared_1.getEnumMemberName(DoorLockMode, this.currentMode),
            "active outside handles": this.outsideHandlesCanOpenDoor.join(", "),
            "active inside handles": this.insideHandlesCanOpenDoor.join(", "),
            "latch status": this.latchStatus,
            "bolt status": this.boltStatus,
            "door status": this.doorStatus,
        };
        if (this.targetMode != undefined) {
            message["target mode"] = shared_1.getEnumMemberName(DoorLockMode, this.targetMode);
        }
        if (this.duration != undefined) {
            message["remaining duration"] = this.duration.toString();
        }
        if (this.lockTimeout != undefined) {
            message["lock timeout"] = `${this.lockTimeout} seconds`;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyUInt8,
        label: "Current lock mode",
        states: core_1.enumValuesToMetadataStates(DoorLockMode),
    })
], DoorLockCCOperationReport.prototype, "currentMode", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.UInt8,
        label: "Target lock mode",
        states: core_1.enumValuesToMetadataStates(DoorLockMode),
    })
], DoorLockCCOperationReport.prototype, "targetMode", void 0);
__decorate([
    CommandClass_1.ccValue({ minVersion: 3 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnly,
        label: "Remaining duration until target lock mode",
    })
], DoorLockCCOperationReport.prototype, "duration", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnly,
        label: "Which outside handles can open the door (actual status)",
    })
], DoorLockCCOperationReport.prototype, "outsideHandlesCanOpenDoor", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnly,
        label: "Which inside handles can open the door (actual status)",
    })
], DoorLockCCOperationReport.prototype, "insideHandlesCanOpenDoor", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnly,
        label: "The current status of the latch",
    })
], DoorLockCCOperationReport.prototype, "latchStatus", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnly,
        label: "The current status of the bolt",
    })
], DoorLockCCOperationReport.prototype, "boltStatus", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnly,
        label: "The current status of the door",
    })
], DoorLockCCOperationReport.prototype, "doorStatus", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyNumber,
        label: "Seconds until lock mode times out",
    })
], DoorLockCCOperationReport.prototype, "lockTimeout", void 0);
DoorLockCCOperationReport = __decorate([
    CommandClass_1.CCCommand(DoorLockCommand.OperationReport)
], DoorLockCCOperationReport);
exports.DoorLockCCOperationReport = DoorLockCCOperationReport;
let DoorLockCCOperationGet = class DoorLockCCOperationGet extends DoorLockCC {
};
DoorLockCCOperationGet = __decorate([
    CommandClass_1.CCCommand(DoorLockCommand.OperationGet),
    CommandClass_1.expectedCCResponse(DoorLockCCOperationReport)
], DoorLockCCOperationGet);
exports.DoorLockCCOperationGet = DoorLockCCOperationGet;
let DoorLockCCConfigurationReport = class DoorLockCCConfigurationReport extends DoorLockCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 4);
        this.operationType = this.payload[0];
        this.outsideHandlesCanOpenDoorConfiguration = [
            !!(this.payload[1] & 16),
            !!(this.payload[1] & 32),
            !!(this.payload[1] & 64),
            !!(this.payload[1] & 128),
        ];
        this.insideHandlesCanOpenDoorConfiguration = [
            !!(this.payload[1] & 0b0001),
            !!(this.payload[1] & 0b0010),
            !!(this.payload[1] & 0b0100),
            !!(this.payload[1] & 0b1000),
        ];
        if (this.operationType === DoorLockOperationType.Timed) {
            const lockTimeoutMinutes = this.payload[2];
            const lockTimeoutSeconds = this.payload[3];
            if (lockTimeoutMinutes <= 0xfd && lockTimeoutSeconds <= 59) {
                this.lockTimeoutConfiguration =
                    lockTimeoutSeconds + lockTimeoutMinutes * 60;
            }
        }
        if (this.version >= 4 && this.payload.length >= 5) {
            this.autoRelockTime = this.payload.readUInt16BE(4);
            this.holdAndReleaseTime = this.payload.readUInt16BE(6);
            const flags = this.payload[8];
            this.twistAssist = !!(flags & 0b1);
            this.blockToBlock = !!(flags & 0b10);
        }
        this.persistValues();
    }
    toLogEntry() {
        const message = {
            "operation type": shared_1.getEnumMemberName(DoorLockOperationType, this.operationType),
            "outside handle configuration": this.outsideHandlesCanOpenDoorConfiguration.join(", "),
            "inside handle configuration": this.insideHandlesCanOpenDoorConfiguration.join(", "),
        };
        if (this.lockTimeoutConfiguration != undefined) {
            message["timed mode duration"] = `${this.lockTimeoutConfiguration} seconds`;
        }
        if (this.autoRelockTime != undefined) {
            message["auto-relock time"] = `${this.autoRelockTime} seconds`;
        }
        if (this.holdAndReleaseTime != undefined) {
            message["hold-and-release time"] = `${this.holdAndReleaseTime} seconds`;
        }
        if (this.twistAssist != undefined) {
            message["twist assist enabled"] = this.twistAssist;
        }
        if (this.blockToBlock != undefined) {
            message["block-to-block enabled"] = this.blockToBlock;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.UInt8,
        label: "Lock operation type",
        states: core_1.enumValuesToMetadataStates(DoorLockOperationType),
    })
], DoorLockCCConfigurationReport.prototype, "operationType", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Any,
        label: "Which outside handles can open the door (configuration)",
    })
], DoorLockCCConfigurationReport.prototype, "outsideHandlesCanOpenDoorConfiguration", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Any,
        label: "Which inside handles can open the door (configuration)",
    })
], DoorLockCCConfigurationReport.prototype, "insideHandlesCanOpenDoorConfiguration", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.UInt16,
        label: "Duration of timed mode in seconds",
    })
], DoorLockCCConfigurationReport.prototype, "lockTimeoutConfiguration", void 0);
__decorate([
    CommandClass_1.ccValue({ minVersion: 4 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.UInt16,
        label: "Duration in seconds until lock returns to secure state",
    })
], DoorLockCCConfigurationReport.prototype, "autoRelockTime", void 0);
__decorate([
    CommandClass_1.ccValue({ minVersion: 4 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.UInt16,
        label: "Duration in seconds the latch stays retracted",
    })
], DoorLockCCConfigurationReport.prototype, "holdAndReleaseTime", void 0);
__decorate([
    CommandClass_1.ccValue({ minVersion: 4 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Boolean,
        label: "Twist Assist enabled",
    })
], DoorLockCCConfigurationReport.prototype, "twistAssist", void 0);
__decorate([
    CommandClass_1.ccValue({ minVersion: 4 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Boolean,
        label: "Block-to-block functionality enabled",
    })
], DoorLockCCConfigurationReport.prototype, "blockToBlock", void 0);
DoorLockCCConfigurationReport = __decorate([
    CommandClass_1.CCCommand(DoorLockCommand.ConfigurationReport)
], DoorLockCCConfigurationReport);
exports.DoorLockCCConfigurationReport = DoorLockCCConfigurationReport;
let DoorLockCCConfigurationGet = class DoorLockCCConfigurationGet extends DoorLockCC {
};
DoorLockCCConfigurationGet = __decorate([
    CommandClass_1.CCCommand(DoorLockCommand.ConfigurationGet),
    CommandClass_1.expectedCCResponse(DoorLockCCConfigurationReport)
], DoorLockCCConfigurationGet);
exports.DoorLockCCConfigurationGet = DoorLockCCConfigurationGet;
let DoorLockCCConfigurationSet = class DoorLockCCConfigurationSet extends DoorLockCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.operationType = options.operationType;
            this.outsideHandlesCanOpenDoorConfiguration =
                options.outsideHandlesCanOpenDoorConfiguration;
            this.insideHandlesCanOpenDoorConfiguration =
                options.insideHandlesCanOpenDoorConfiguration;
            this.lockTimeoutConfiguration = options.lockTimeoutConfiguration;
            this.autoRelockTime = options.autoRelockTime;
            this.holdAndReleaseTime = options.holdAndReleaseTime;
            this.twistAssist = options.twistAssist;
            this.blockToBlock = options.blockToBlock;
        }
    }
    serialize() {
        var _c, _d;
        const insideHandles = typeguards_1.isArray(this.insideHandlesCanOpenDoorConfiguration)
            ? this.insideHandlesCanOpenDoorConfiguration
            : [];
        const outsideHandles = typeguards_1.isArray(this.outsideHandlesCanOpenDoorConfiguration)
            ? this.outsideHandlesCanOpenDoorConfiguration
            : [];
        const handles = [...insideHandles, ...outsideHandles]
            .map((val, i) => (val ? 1 << i : 0))
            .reduce((acc, cur) => acc | cur, 0);
        let lockTimeoutMinutes;
        let lockTimeoutSeconds;
        if (this.operationType === DoorLockOperationType.Constant) {
            lockTimeoutMinutes = lockTimeoutSeconds = 0xfe;
        }
        else {
            lockTimeoutMinutes = Math.floor(this.lockTimeoutConfiguration / 60);
            lockTimeoutSeconds = this.lockTimeoutConfiguration % 60;
        }
        this.payload = Buffer.from([
            this.operationType,
            handles,
            lockTimeoutMinutes,
            lockTimeoutSeconds,
        ]);
        if (this.version >= 4 &&
            (this.twistAssist != undefined ||
                this.blockToBlock != undefined ||
                this.autoRelockTime != undefined ||
                this.holdAndReleaseTime != undefined)) {
            const flags = (this.twistAssist ? 0b1 : 0) | (this.blockToBlock ? 0b10 : 0);
            this.payload = Buffer.concat([
                this.payload,
                Buffer.from([
                    // placeholder for auto relock time
                    0,
                    0,
                    // placeholder for hold and release time
                    0,
                    0,
                    flags,
                ]),
            ]);
            this.payload.writeUInt16BE(((_c = this.autoRelockTime) !== null && _c !== void 0 ? _c : 0) & 0xffff, 4);
            this.payload.writeUInt16BE(((_d = this.holdAndReleaseTime) !== null && _d !== void 0 ? _d : 0) & 0xffff, 6);
        }
        return super.serialize();
    }
    toLogEntry() {
        const insideHandles = typeguards_1.isArray(this.insideHandlesCanOpenDoorConfiguration)
            ? this.insideHandlesCanOpenDoorConfiguration
            : [];
        const outsideHandles = typeguards_1.isArray(this.outsideHandlesCanOpenDoorConfiguration)
            ? this.outsideHandlesCanOpenDoorConfiguration
            : [];
        const message = {
            "operation type": shared_1.getEnumMemberName(DoorLockOperationType, this.operationType),
            "outside handle configuration": outsideHandles.join(", "),
            "inside handle configuration": insideHandles.join(", "),
        };
        if (this.lockTimeoutConfiguration != undefined) {
            message["timed mode duration"] = `${this.lockTimeoutConfiguration} seconds`;
        }
        if (this.autoRelockTime != undefined) {
            message["auto-relock time"] = `${this.autoRelockTime} seconds`;
        }
        if (this.holdAndReleaseTime != undefined) {
            message["hold-and-release time"] = `${this.holdAndReleaseTime} seconds`;
        }
        if (this.twistAssist != undefined) {
            message["enable twist assist"] = this.twistAssist;
        }
        if (this.blockToBlock != undefined) {
            message["enable block-to-block"] = this.blockToBlock;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
DoorLockCCConfigurationSet = __decorate([
    CommandClass_1.CCCommand(DoorLockCommand.ConfigurationSet)
], DoorLockCCConfigurationSet);
exports.DoorLockCCConfigurationSet = DoorLockCCConfigurationSet;
let DoorLockCCCapabilitiesReport = class DoorLockCCCapabilitiesReport extends DoorLockCC {
    constructor(driver, options) {
        super(driver, options);
        // parse variable length operation type bit mask
        core_1.validatePayload(this.payload.length >= 1);
        const bitMaskLength = this.payload[0] & 0b11111;
        let offset = 1;
        core_1.validatePayload(this.payload.length >= offset + bitMaskLength + 1);
        this.supportedOperationTypes = core_1.parseBitMask(this.payload.slice(offset, offset + bitMaskLength));
        offset += bitMaskLength;
        // parse variable length door lock mode list
        const listLength = this.payload[offset];
        offset += 1;
        core_1.validatePayload(this.payload.length >= offset + listLength + 3);
        this.supportedDoorLockModes = [
            ...this.payload.slice(offset, offset + listLength),
        ];
        offset += listLength;
        this.supportedOutsideHandles = [
            !!(this.payload[offset] & 16),
            !!(this.payload[offset] & 32),
            !!(this.payload[offset] & 64),
            !!(this.payload[offset] & 128),
        ];
        this.supportedInsideHandles = [
            !!(this.payload[offset] & 0b0001),
            !!(this.payload[offset] & 0b0010),
            !!(this.payload[offset] & 0b0100),
            !!(this.payload[offset] & 0b1000),
        ];
        this.doorSupported = !!(this.payload[offset + 1] & 0b1);
        this.boltSupported = !!(this.payload[offset + 1] & 0b10);
        this.latchSupported = !!(this.payload[offset + 1] & 0b100);
        this.blockToBlockSupported = !!(this.payload[offset + 2] & 0b1);
        this.twistAssistSupported = !!(this.payload[offset + 2] & 0b10);
        this.holdAndReleaseSupported = !!(this.payload[offset + 2] & 0b100);
        this.autoRelockSupported = !!(this.payload[offset + 2] & 0b1000);
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                door: this.doorSupported,
                bolt: this.boltSupported,
                latch: this.latchSupported,
                "block-to-block feature": this.blockToBlockSupported,
                "twist assist feature": this.twistAssistSupported,
                "hold-and-release feature": this.holdAndReleaseSupported,
                "auto-relock feature": this.autoRelockSupported,
                "operation types": this.supportedOperationTypes
                    .map((t) => `\n· ${shared_1.getEnumMemberName(DoorLockOperationType, t)}`)
                    .join(""),
                "door lock modes": this.supportedDoorLockModes
                    .map((t) => `\n· ${shared_1.getEnumMemberName(DoorLockMode, t)}`)
                    .join(""),
                "outside handles": this.supportedOutsideHandles.join(", "),
                "inside handles": this.supportedInsideHandles.join(", "),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true, minVersion: 4 })
], DoorLockCCCapabilitiesReport.prototype, "supportedOperationTypes", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true, minVersion: 4 })
], DoorLockCCCapabilitiesReport.prototype, "supportedDoorLockModes", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true, minVersion: 4 })
], DoorLockCCCapabilitiesReport.prototype, "supportedOutsideHandles", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true, minVersion: 4 })
], DoorLockCCCapabilitiesReport.prototype, "supportedInsideHandles", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true, minVersion: 4 })
], DoorLockCCCapabilitiesReport.prototype, "latchSupported", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true, minVersion: 4 })
], DoorLockCCCapabilitiesReport.prototype, "boltSupported", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true, minVersion: 4 })
], DoorLockCCCapabilitiesReport.prototype, "doorSupported", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true, minVersion: 4 })
], DoorLockCCCapabilitiesReport.prototype, "autoRelockSupported", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true, minVersion: 4 })
], DoorLockCCCapabilitiesReport.prototype, "holdAndReleaseSupported", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true, minVersion: 4 })
], DoorLockCCCapabilitiesReport.prototype, "twistAssistSupported", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true, minVersion: 4 })
], DoorLockCCCapabilitiesReport.prototype, "blockToBlockSupported", void 0);
DoorLockCCCapabilitiesReport = __decorate([
    CommandClass_1.CCCommand(DoorLockCommand.CapabilitiesReport)
], DoorLockCCCapabilitiesReport);
exports.DoorLockCCCapabilitiesReport = DoorLockCCCapabilitiesReport;
let DoorLockCCCapabilitiesGet = class DoorLockCCCapabilitiesGet extends DoorLockCC {
};
DoorLockCCCapabilitiesGet = __decorate([
    CommandClass_1.CCCommand(DoorLockCommand.CapabilitiesGet),
    CommandClass_1.expectedCCResponse(DoorLockCCCapabilitiesReport)
], DoorLockCCCapabilitiesGet);
exports.DoorLockCCCapabilitiesGet = DoorLockCCCapabilitiesGet;

//# sourceMappingURL=DoorLockCC.js.map
