"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultiChannelCCV1CommandEncapsulation = exports.MultiChannelCCV1Get = exports.MultiChannelCCV1Report = exports.MultiChannelCCCommandEncapsulation = exports.MultiChannelCCAggregatedMembersGet = exports.MultiChannelCCAggregatedMembersReport = exports.MultiChannelCCEndPointFind = exports.MultiChannelCCEndPointFindReport = exports.MultiChannelCCCapabilityGet = exports.MultiChannelCCCapabilityReport = exports.MultiChannelCCEndPointGet = exports.MultiChannelCCEndPointReport = exports.MultiChannelCC = exports.MultiChannelCCAPI = exports.getAggregatedCountValueId = exports.getIndividualCountValueId = exports.getIdenticalCapabilitiesValueId = exports.getCountIsDynamicValueId = exports.getEndpointCCsValueId = exports.MultiChannelCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
var MultiChannelCommand;
(function (MultiChannelCommand) {
    // Legacy commands for V1 (Multi Instance)
    MultiChannelCommand[MultiChannelCommand["GetV1"] = 4] = "GetV1";
    MultiChannelCommand[MultiChannelCommand["ReportV1"] = 5] = "ReportV1";
    MultiChannelCommand[MultiChannelCommand["CommandEncapsulationV1"] = 6] = "CommandEncapsulationV1";
    // V2+
    MultiChannelCommand[MultiChannelCommand["EndPointGet"] = 7] = "EndPointGet";
    MultiChannelCommand[MultiChannelCommand["EndPointReport"] = 8] = "EndPointReport";
    MultiChannelCommand[MultiChannelCommand["CapabilityGet"] = 9] = "CapabilityGet";
    MultiChannelCommand[MultiChannelCommand["CapabilityReport"] = 10] = "CapabilityReport";
    MultiChannelCommand[MultiChannelCommand["EndPointFind"] = 11] = "EndPointFind";
    MultiChannelCommand[MultiChannelCommand["EndPointFindReport"] = 12] = "EndPointFindReport";
    MultiChannelCommand[MultiChannelCommand["CommandEncapsulation"] = 13] = "CommandEncapsulation";
    MultiChannelCommand[MultiChannelCommand["AggregatedMembersGet"] = 14] = "AggregatedMembersGet";
    MultiChannelCommand[MultiChannelCommand["AggregatedMembersReport"] = 15] = "AggregatedMembersReport";
})(MultiChannelCommand = exports.MultiChannelCommand || (exports.MultiChannelCommand = {}));
// TODO: Handle removal reports of dynamic endpoints
// @noSetValueAPI
function getEndpointCCsValueId(endpointIndex) {
    return {
        commandClass: core_1.CommandClasses["Multi Channel"],
        endpoint: endpointIndex,
        property: "commandClasses",
    };
}
exports.getEndpointCCsValueId = getEndpointCCsValueId;
function getCountIsDynamicValueId() {
    return {
        commandClass: core_1.CommandClasses["Multi Channel"],
        property: "countIsDynamic",
    };
}
exports.getCountIsDynamicValueId = getCountIsDynamicValueId;
function getIdenticalCapabilitiesValueId() {
    return {
        commandClass: core_1.CommandClasses["Multi Channel"],
        property: "identicalCapabilities",
    };
}
exports.getIdenticalCapabilitiesValueId = getIdenticalCapabilitiesValueId;
function getIndividualCountValueId() {
    return {
        commandClass: core_1.CommandClasses["Multi Channel"],
        property: "individualCount",
    };
}
exports.getIndividualCountValueId = getIndividualCountValueId;
function getAggregatedCountValueId() {
    return {
        commandClass: core_1.CommandClasses["Multi Channel"],
        property: "aggregatedCount",
    };
}
exports.getAggregatedCountValueId = getAggregatedCountValueId;
let MultiChannelCCAPI = class MultiChannelCCAPI extends API_1.CCAPI {
    supportsCommand(cmd) {
        switch (cmd) {
            // Legacy commands:
            case MultiChannelCommand.GetV1:
                return this.isSinglecast() && this.version === 1;
            case MultiChannelCommand.CommandEncapsulationV1:
                return this.version === 1;
            // The specs start at version 3 but according to OZW,
            // these do seem to be supported in version 2
            case MultiChannelCommand.EndPointGet:
            case MultiChannelCommand.CapabilityGet:
                return this.version >= 2 && this.isSinglecast();
            case MultiChannelCommand.CommandEncapsulation:
                return this.version >= 2;
            case MultiChannelCommand.EndPointFind:
                return this.version >= 3 && this.isSinglecast();
            case MultiChannelCommand.AggregatedMembersGet:
                return this.version >= 4 && this.isSinglecast();
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getEndpoints() {
        this.assertSupportsCommand(MultiChannelCommand, MultiChannelCommand.EndPointGet);
        const cc = new MultiChannelCCEndPointGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return {
                isDynamicEndpointCount: response.countIsDynamic,
                identicalCapabilities: response.identicalCapabilities,
                individualEndpointCount: response.individualCount,
                aggregatedEndpointCount: response.aggregatedCount,
            };
        }
    }
    async getEndpointCapabilities(endpoint) {
        this.assertSupportsCommand(MultiChannelCommand, MultiChannelCommand.CapabilityGet);
        const cc = new MultiChannelCCCapabilityGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            requestedEndpoint: endpoint,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.capability;
    }
    async findEndpoints(genericClass, specificClass) {
        this.assertSupportsCommand(MultiChannelCommand, MultiChannelCommand.EndPointFind);
        const cc = new MultiChannelCCEndPointFind(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            genericClass,
            specificClass,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.foundEndpoints;
    }
    async getAggregatedMembers(endpoint) {
        this.assertSupportsCommand(MultiChannelCommand, MultiChannelCommand.AggregatedMembersGet);
        const cc = new MultiChannelCCAggregatedMembersGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            requestedEndpoint: endpoint,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.members;
    }
    async sendEncapsulated(options) {
        this.assertSupportsCommand(MultiChannelCommand, MultiChannelCommand.CommandEncapsulation);
        const cc = new MultiChannelCCCommandEncapsulation(this.driver, {
            nodeId: this.endpoint.nodeId,
            ...options,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async getEndpointCountV1(ccId) {
        this.assertSupportsCommand(MultiChannelCommand, MultiChannelCommand.GetV1);
        const cc = new MultiChannelCCV1Get(this.driver, {
            nodeId: this.endpoint.nodeId,
            requestedCC: ccId,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.endpointCount;
    }
    async sendEncapsulatedV1(encapsulated) {
        this.assertSupportsCommand(MultiChannelCommand, MultiChannelCommand.CommandEncapsulationV1);
        const cc = new MultiChannelCCV1CommandEncapsulation(this.driver, {
            nodeId: this.endpoint.nodeId,
            encapsulated,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
MultiChannelCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Multi Channel"])
], MultiChannelCCAPI);
exports.MultiChannelCCAPI = MultiChannelCCAPI;
let MultiChannelCC = class MultiChannelCC extends CommandClass_1.CommandClass {
    constructor(driver, options) {
        super(driver, options);
        this.registerValue(getEndpointCCsValueId(0).property, true);
    }
    /** Tests if a command targets a specific endpoint and thus requires encapsulation */
    static requiresEncapsulation(cc) {
        return (cc.endpointIndex !== 0 &&
            !(cc instanceof MultiChannelCCCommandEncapsulation));
    }
    /** Encapsulates a command that targets a specific endpoint */
    static encapsulate(driver, cc) {
        return new MultiChannelCCCommandEncapsulation(driver, {
            nodeId: cc.nodeId,
            encapsulated: cc,
            destination: cc.endpointIndex,
        });
    }
    async interview(complete = true) {
        // Special interview procedure for legacy nodes
        if (this.version === 1)
            return this.interviewV1(complete);
        const node = this.getNode();
        const endpoint = node.getEndpoint(this.endpointIndex);
        const api = endpoint.commandClasses["Multi Channel"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        // Step 1: Retrieve general information about end points
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "querying device endpoint information...",
            direction: "outbound",
        });
        const multiResponse = await api.getEndpoints();
        if (!multiResponse) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "Querying device endpoint information timed out, skipping interview...",
                level: "warn",
            });
            return;
        }
        let logMessage = `received response for device endpoints:
endpoint count (individual): ${multiResponse.individualEndpointCount}
count is dynamic:            ${multiResponse.isDynamicEndpointCount}
identical capabilities:      ${multiResponse.identicalCapabilities}`;
        if (multiResponse.aggregatedEndpointCount != undefined) {
            logMessage += `\nendpoint count (aggregated): ${multiResponse.aggregatedEndpointCount}`;
        }
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound",
        });
        const endpointsToQuery = [];
        const addSequentialEndpoints = () => {
            var _a;
            for (let i = 1; i <=
                multiResponse.individualEndpointCount +
                    ((_a = multiResponse.aggregatedEndpointCount) !== null && _a !== void 0 ? _a : 0); i++) {
                endpointsToQuery.push(i);
            }
        };
        if (api.supportsCommand(MultiChannelCommand.EndPointFind)) {
            // Step 2a: Find all endpoints
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "querying all endpoints...",
                direction: "outbound",
            });
            const foundEndpoints = await api.findEndpoints(0xff, 0xff);
            if (foundEndpoints)
                endpointsToQuery.push(...foundEndpoints);
            if (!endpointsToQuery.length) {
                // Create a sequential list of endpoints
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `Endpoint query returned no results, assuming that endpoints are sequential`,
                    direction: "inbound",
                });
                addSequentialEndpoints();
            }
            else {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `received endpoints: ${endpointsToQuery
                        .map(String)
                        .join(", ")}`,
                    direction: "inbound",
                });
            }
        }
        else {
            // Step 2b: Assume that the endpoints are in sequential order
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `does not support EndPointFind, assuming that endpoints are sequential`,
                direction: "none",
            });
            addSequentialEndpoints();
        }
        // Step 3: Query endpoints
        let hasQueriedCapabilities = false;
        for (const endpoint of endpointsToQuery) {
            if (endpoint > multiResponse.individualEndpointCount &&
                this.version >= 4) {
                // Find members of aggregated end point
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `querying members of aggregated endpoint #${endpoint}...`,
                    direction: "outbound",
                });
                const members = await api.getAggregatedMembers(endpoint);
                if (members) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: `aggregated endpoint #${endpoint} has members ${members
                            .map(String)
                            .join(", ")}`,
                        direction: "inbound",
                    });
                }
            }
            // When the device reports identical capabilities for all endpoints,
            // we don't need to query them all
            if (multiResponse.identicalCapabilities && hasQueriedCapabilities) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `all endpoints identical, skipping capability query for endpoint #${endpoint}...`,
                    direction: "none",
                });
                // copy the capabilities from the first endpoint
                const ep1Caps = this.getValueDB().getValue(getEndpointCCsValueId(endpointsToQuery[0]));
                this.getValueDB().setValue(getEndpointCCsValueId(endpoint), [
                    ...ep1Caps,
                ]);
                continue;
            }
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `querying capabilities for endpoint #${endpoint}...`,
                direction: "outbound",
            });
            const caps = await api.getEndpointCapabilities(endpoint);
            if (caps) {
                hasQueriedCapabilities = true;
                logMessage = `received response for endpoint capabilities (#${endpoint}):
generic device class:  ${caps.generic.label}
specific device class: ${caps.specific.label}
is dynamic end point:  ${caps.isDynamic}
supported CCs:`;
                for (const cc of caps.supportedCCs) {
                    const ccName = core_1.CommandClasses[cc];
                    logMessage += `\n  · ${ccName ? ccName : shared_1.num2hex(cc)}`;
                }
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
    async interviewV1(complete = true) {
        // Only do the interview once
        if (complete) {
            const node = this.getNode();
            const api = node.getEndpoint(this.endpointIndex).commandClasses["Multi Channel"];
            // V1 works the opposite way - we scan all CCs and remember how many
            // endpoints they have
            const supportedCCs = [...node.implementedCommandClasses.keys()]
                // Don't query CCs the node only controls
                .filter((cc) => node.supportsCC(cc))
                // Don't query CCs that want to skip the endpoint interview
                .filter((cc) => { var _a; return !((_a = node.createCCInstance(cc)) === null || _a === void 0 ? void 0 : _a.skipEndpointInterview()); });
            const endpointCounts = new Map();
            for (const ccId of supportedCCs) {
                this.driver.controllerLog.logNode(node.id, {
                    message: `Querying endpoint count for CommandClass ${core_1.getCCName(ccId)}...`,
                    direction: "outbound",
                });
                const endpointCount = await api.getEndpointCountV1(ccId);
                if (endpointCount != undefined) {
                    endpointCounts.set(ccId, endpointCount);
                    this.driver.controllerLog.logNode(node.id, {
                        message: `CommandClass ${core_1.getCCName(ccId)} has ${endpointCount} endpoints`,
                        direction: "inbound",
                    });
                }
            }
            // Store the collected information
            // We have only individual and no dynamic and no aggregated endpoints
            const numEndpoints = Math.max(...endpointCounts.values());
            node.valueDB.setValue(getCountIsDynamicValueId(), false);
            node.valueDB.setValue(getAggregatedCountValueId(), 0);
            node.valueDB.setValue(getIndividualCountValueId(), numEndpoints);
            // Since we queried all CCs separately, we can assume that all
            // endpoints have different capabilities
            node.valueDB.setValue(getIdenticalCapabilitiesValueId(), false);
            for (let endpoint = 1; endpoint <= numEndpoints; endpoint++) {
                // Check which CCs exist on this endpoint
                const endpointCCs = [...endpointCounts.entries()]
                    .filter(([, ccEndpoints]) => ccEndpoints <= endpoint)
                    .map(([ccId]) => ccId);
                // Create a new capability value from the CCs
                const capability = {
                    generic: 0,
                    specific: 0,
                    isDynamic: false,
                    wasRemoved: false,
                    supportedCCs: endpointCCs,
                };
                // And store it
                node.valueDB.setValue(getEndpointCCsValueId(endpoint), capability);
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
MultiChannelCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Multi Channel"]),
    CommandClass_1.implementedVersion(4)
], MultiChannelCC);
exports.MultiChannelCC = MultiChannelCC;
let MultiChannelCCEndPointReport = class MultiChannelCCEndPointReport extends MultiChannelCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this._countIsDynamic = !!(this.payload[0] & 0b10000000);
        this._identicalCapabilities = !!(this.payload[0] & 0b01000000);
        this._individualCount = this.payload[1] & 0b01111111;
        if (this.version >= 4 && this.payload.length >= 3) {
            this._aggregatedCount = this.payload[2] & 0b01111111;
        }
        this.persistValues();
    }
    get countIsDynamic() {
        return this._countIsDynamic;
    }
    get identicalCapabilities() {
        return this._identicalCapabilities;
    }
    get individualCount() {
        return this._individualCount;
    }
    get aggregatedCount() {
        return this._aggregatedCount;
    }
    toLogEntry() {
        const message = {
            "endpoint count (individual)": this.individualCount,
            "count is dynamic": this.countIsDynamic,
            "identical capabilities": this.identicalCapabilities,
        };
        if (this.aggregatedCount != undefined) {
            message["endpoint count (aggregated)"] = this.aggregatedCount;
        }
        const ret = {
            ...super.toLogEntry(),
            message,
        };
        return ret;
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], MultiChannelCCEndPointReport.prototype, "countIsDynamic", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], MultiChannelCCEndPointReport.prototype, "identicalCapabilities", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], MultiChannelCCEndPointReport.prototype, "individualCount", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], MultiChannelCCEndPointReport.prototype, "aggregatedCount", null);
MultiChannelCCEndPointReport = __decorate([
    CommandClass_1.CCCommand(MultiChannelCommand.EndPointReport)
], MultiChannelCCEndPointReport);
exports.MultiChannelCCEndPointReport = MultiChannelCCEndPointReport;
let MultiChannelCCEndPointGet = class MultiChannelCCEndPointGet extends MultiChannelCC {
};
MultiChannelCCEndPointGet = __decorate([
    CommandClass_1.CCCommand(MultiChannelCommand.EndPointGet),
    CommandClass_1.expectedCCResponse(MultiChannelCCEndPointReport)
], MultiChannelCCEndPointGet);
exports.MultiChannelCCEndPointGet = MultiChannelCCEndPointGet;
let MultiChannelCCCapabilityReport = class MultiChannelCCCapabilityReport extends MultiChannelCC {
    constructor(driver, options) {
        super(driver, options);
        // Only validate the bytes we expect to see here
        // parseNodeInformationFrame does its own validation
        core_1.validatePayload(this.payload.length >= 1);
        this.endpointIndex = this.payload[0] & 0b01111111;
        const NIF = core_1.parseNodeInformationFrame(this.payload.slice(1));
        const capability = {
            isDynamic: !!(this.payload[0] & 0b10000000),
            wasRemoved: false,
            generic: this.driver.configManager.lookupGenericDeviceClass(NIF.generic),
            specific: this.driver.configManager.lookupSpecificDeviceClass(NIF.generic, NIF.specific),
            supportedCCs: NIF.supportedCCs,
        };
        // Removal reports have very specific information
        capability.wasRemoved =
            capability.isDynamic &&
                capability.generic.key === 0xff && // "Non-Interoperable"
                capability.specific.key === 0x00;
        this.capability = capability;
        // Remember the supported CCs
        this.persistValues();
    }
    persistValues() {
        const ccsValueId = getEndpointCCsValueId(this.endpointIndex);
        if (this.capability.wasRemoved) {
            this.getValueDB().removeValue(ccsValueId);
        }
        else {
            this.getValueDB().setValue(ccsValueId, this.capability.supportedCCs);
        }
        return true;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "endpoint index": this.endpointIndex,
                "generic device class": this.capability.generic.label,
                "specific device class": this.capability.specific.label,
                "is dynamic end point": this.capability.isDynamic,
                "supported CCs": this.capability.supportedCCs
                    .map((cc) => `\n· ${core_1.getCCName(cc)}`)
                    .join(""),
            },
        };
    }
};
MultiChannelCCCapabilityReport = __decorate([
    CommandClass_1.CCCommand(MultiChannelCommand.CapabilityReport)
], MultiChannelCCCapabilityReport);
exports.MultiChannelCCCapabilityReport = MultiChannelCCCapabilityReport;
let MultiChannelCCCapabilityGet = class MultiChannelCCCapabilityGet extends MultiChannelCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.requestedEndpoint = options.requestedEndpoint;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.requestedEndpoint & 0b01111111]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { endpoint: this.requestedEndpoint },
        };
    }
};
MultiChannelCCCapabilityGet = __decorate([
    CommandClass_1.CCCommand(MultiChannelCommand.CapabilityGet),
    CommandClass_1.expectedCCResponse(MultiChannelCCCapabilityReport)
], MultiChannelCCCapabilityGet);
exports.MultiChannelCCCapabilityGet = MultiChannelCCCapabilityGet;
let MultiChannelCCEndPointFindReport = class MultiChannelCCEndPointFindReport extends MultiChannelCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 3);
        this._reportsToFollow = this.payload[0];
        this._genericClass = this.payload[1];
        this._specificClass = this.payload[2];
        // Some devices omit the endpoint list althought that is not allowed in the specs
        // therefore don't validatePayload here.
        this._foundEndpoints = [...this.payload.slice(3)]
            .map((e) => e & 0b01111111)
            .filter((e) => e !== 0);
    }
    get genericClass() {
        return this._genericClass;
    }
    get specificClass() {
        return this._specificClass;
    }
    get foundEndpoints() {
        return this._foundEndpoints;
    }
    get reportsToFollow() {
        return this._reportsToFollow;
    }
    getPartialCCSessionId() {
        // Distinguish sessions by the requested device classes
        return {
            genericClass: this.genericClass,
            specificClass: this.specificClass,
        };
    }
    expectMoreMessages() {
        return this._reportsToFollow > 0;
    }
    mergePartialCCs(partials) {
        // Concat the list of end points
        this._foundEndpoints = [...partials, this]
            .map((report) => report._foundEndpoints)
            .reduce((prev, cur) => prev.concat(...cur), []);
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "generic device class": this.driver.configManager.lookupGenericDeviceClass(this.genericClass).label,
                "specific device class": this.driver.configManager.lookupSpecificDeviceClass(this.genericClass, this.specificClass).label,
                "found endpoints": this._foundEndpoints.join(", "),
                "# of reports to follow": this._reportsToFollow,
            },
        };
    }
};
MultiChannelCCEndPointFindReport = __decorate([
    CommandClass_1.CCCommand(MultiChannelCommand.EndPointFindReport)
], MultiChannelCCEndPointFindReport);
exports.MultiChannelCCEndPointFindReport = MultiChannelCCEndPointFindReport;
let MultiChannelCCEndPointFind = class MultiChannelCCEndPointFind extends MultiChannelCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.genericClass = options.genericClass;
            this.specificClass = options.specificClass;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.genericClass, this.specificClass]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "generic device class": this.driver.configManager.lookupGenericDeviceClass(this.genericClass).label,
                "specific device class": this.driver.configManager.lookupSpecificDeviceClass(this.genericClass, this.specificClass).label,
            },
        };
    }
};
MultiChannelCCEndPointFind = __decorate([
    CommandClass_1.CCCommand(MultiChannelCommand.EndPointFind),
    CommandClass_1.expectedCCResponse(MultiChannelCCEndPointFindReport)
], MultiChannelCCEndPointFind);
exports.MultiChannelCCEndPointFind = MultiChannelCCEndPointFind;
let MultiChannelCCAggregatedMembersReport = class MultiChannelCCAggregatedMembersReport extends MultiChannelCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        const endpoint = this.payload[0] & 127;
        const bitMaskLength = this.payload[1];
        core_1.validatePayload(this.payload.length >= 2 + bitMaskLength);
        const bitMask = this.payload.slice(2, 2 + bitMaskLength);
        const members = core_1.parseBitMask(bitMask);
        this.aggregatedEndpointMembers = [endpoint, members];
        this.persistValues();
    }
    get aggregatedEndpoint() {
        return this.aggregatedEndpointMembers[0];
    }
    get members() {
        return this.aggregatedEndpointMembers[1];
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                endpoint: this.endpointIndex,
                members: this.members.join(", "),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccKeyValuePair({ internal: true })
], MultiChannelCCAggregatedMembersReport.prototype, "aggregatedEndpointMembers", void 0);
MultiChannelCCAggregatedMembersReport = __decorate([
    CommandClass_1.CCCommand(MultiChannelCommand.AggregatedMembersReport)
], MultiChannelCCAggregatedMembersReport);
exports.MultiChannelCCAggregatedMembersReport = MultiChannelCCAggregatedMembersReport;
let MultiChannelCCAggregatedMembersGet = class MultiChannelCCAggregatedMembersGet extends MultiChannelCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.requestedEndpoint = options.requestedEndpoint;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.requestedEndpoint & 127]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { endpoint: this.requestedEndpoint },
        };
    }
};
MultiChannelCCAggregatedMembersGet = __decorate([
    CommandClass_1.CCCommand(MultiChannelCommand.AggregatedMembersGet),
    CommandClass_1.expectedCCResponse(MultiChannelCCAggregatedMembersReport)
], MultiChannelCCAggregatedMembersGet);
exports.MultiChannelCCAggregatedMembersGet = MultiChannelCCAggregatedMembersGet;
// SDS13783: A receiving node MAY respond to a Multi Channel encapsulated command if the Destination
// End Point field specifies a single End Point. In that case, the response MUST be Multi Channel
// encapsulated.
// A receiving node MUST NOT respond to a Multi Channel encapsulated command if the
// Destination End Point field specifies multiple End Points via bit mask addressing.
function getCCResponseForCommandEncapsulation(sent) {
    if (typeof sent.destination === "number" &&
        sent.encapsulated.expectsCCResponse()) {
        // Allow both versions of the encapsulation command
        // Our implementation check is a bit too strict, so change the return type
        return [
            MultiChannelCCCommandEncapsulation,
            MultiChannelCCV1CommandEncapsulation,
        ];
    }
}
function testResponseForCommandEncapsulation(sent, received) {
    if (typeof sent.destination === "number" &&
        sent.destination === received.endpointIndex) {
        return "checkEncapsulated";
    }
    return false;
}
let MultiChannelCCCommandEncapsulation = class MultiChannelCCCommandEncapsulation extends MultiChannelCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 2);
            this.endpointIndex = this.payload[0] & 127;
            const isBitMask = !!(this.payload[1] & 128);
            const destination = this.payload[1] & 127;
            if (isBitMask) {
                this.destination = core_1.parseBitMask(Buffer.from([destination]));
            }
            else {
                this.destination = destination;
            }
            // No need to validate further, each CC does it for itself
            this.encapsulated = CommandClass_1.CommandClass.from(this.driver, {
                data: this.payload.slice(2),
                fromEncapsulation: true,
                encapCC: this,
            });
        }
        else {
            this.encapsulated = options.encapsulated;
            options.encapsulated.encapsulatingCC = this;
            this.destination = options.destination;
            // If the encapsulated command requires security, so does this one
            if (this.encapsulated.secure)
                this.secure = true;
        }
    }
    serialize() {
        const destination = typeof this.destination === "number"
            ? // The destination is a single number
                this.destination & 127
            : // The destination is a bit mask
                core_1.encodeBitMask(this.destination, 7)[0] | 128;
        this.payload = Buffer.concat([
            Buffer.from([this.endpointIndex & 127, destination]),
            this.encapsulated.serialize(),
        ]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                source: this.endpointIndex,
                destination: typeof this.destination === "number"
                    ? this.destination
                    : this.destination.join(", "),
            },
        };
    }
    computeEncapsulationOverhead() {
        // Multi Channel CC adds two bytes for the source and destination endpoint
        return super.computeEncapsulationOverhead() + 2;
    }
};
MultiChannelCCCommandEncapsulation = __decorate([
    CommandClass_1.CCCommand(MultiChannelCommand.CommandEncapsulation),
    CommandClass_1.expectedCCResponse(getCCResponseForCommandEncapsulation, testResponseForCommandEncapsulation)
], MultiChannelCCCommandEncapsulation);
exports.MultiChannelCCCommandEncapsulation = MultiChannelCCCommandEncapsulation;
let MultiChannelCCV1Report = class MultiChannelCCV1Report extends MultiChannelCC {
    // @noCCValues This information is stored during the interview
    constructor(driver, options) {
        super(driver, options);
        // V1 won't be extended in the future, so do an exact check
        core_1.validatePayload(this.payload.length === 2);
        this.requestedCC = this.payload[0];
        this.endpointCount = this.payload[1];
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                CC: core_1.getCCName(this.requestedCC),
                "# of endpoints": this.endpointCount,
            },
        };
    }
};
MultiChannelCCV1Report = __decorate([
    CommandClass_1.CCCommand(MultiChannelCommand.ReportV1)
], MultiChannelCCV1Report);
exports.MultiChannelCCV1Report = MultiChannelCCV1Report;
function testResponseForMultiChannelV1Get(sent, received) {
    return sent.requestedCC === received.requestedCC;
}
let MultiChannelCCV1Get = class MultiChannelCCV1Get extends MultiChannelCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.requestedCC = options.requestedCC;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.requestedCC]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { CC: core_1.getCCName(this.requestedCC) },
        };
    }
};
MultiChannelCCV1Get = __decorate([
    CommandClass_1.CCCommand(MultiChannelCommand.GetV1),
    CommandClass_1.expectedCCResponse(MultiChannelCCV1Report, testResponseForMultiChannelV1Get)
], MultiChannelCCV1Get);
exports.MultiChannelCCV1Get = MultiChannelCCV1Get;
// This indirection is necessary to be able to define the same CC as the response
function getResponseForV1CommandEncapsulation() {
    return MultiChannelCCV1CommandEncapsulation;
}
let MultiChannelCCV1CommandEncapsulation = class MultiChannelCCV1CommandEncapsulation extends MultiChannelCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 1);
            this.endpointIndex = this.payload[0];
            // Some devices send invalid reports, i.e. MultiChannelCCV1CommandEncapsulation, but with V2+ binary format
            // This would be a NoOp CC, but it makes no sense to encapsulate that.
            const isV2withV1Header = this.payload.length >= 2 && this.payload[1] === 0x00;
            // No need to validate further, each CC does it for itself
            this.encapsulated = CommandClass_1.CommandClass.from(this.driver, {
                data: this.payload.slice(isV2withV1Header ? 2 : 1),
                fromEncapsulation: true,
                encapCC: this,
            });
        }
        else {
            this.encapsulated = options.encapsulated;
            // No need to distinguish between source and destination in V1
            this.endpointIndex = this.encapsulated.endpointIndex;
        }
    }
    serialize() {
        this.payload = Buffer.concat([
            Buffer.from([this.endpointIndex]),
            this.encapsulated.serialize(),
        ]);
        return super.serialize();
    }
    computeEncapsulationOverhead() {
        // Multi Channel CC V1 adds one byte for the endpoint index
        return super.computeEncapsulationOverhead() + 1;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { source: this.endpointIndex },
        };
    }
};
MultiChannelCCV1CommandEncapsulation = __decorate([
    CommandClass_1.CCCommand(MultiChannelCommand.CommandEncapsulationV1),
    CommandClass_1.expectedCCResponse(getResponseForV1CommandEncapsulation)
], MultiChannelCCV1CommandEncapsulation);
exports.MultiChannelCCV1CommandEncapsulation = MultiChannelCCV1CommandEncapsulation;

//# sourceMappingURL=MultiChannelCC.js.map
