/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum NodeNamingAndLocationCommand {
    NameSet = 1,
    NameGet = 2,
    NameReport = 3,
    LocationSet = 4,
    LocationGet = 5,
    LocationReport = 6
}
export declare function getNodeNameValueId(): ValueID;
export declare function getNodeLocationValueId(): ValueID;
export declare class NodeNamingAndLocationCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: NodeNamingAndLocationCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
    getName(): Promise<string | undefined>;
    setName(name: string): Promise<void>;
    getLocation(): Promise<string | undefined>;
    setLocation(location: string): Promise<void>;
}
export declare class NodeNamingAndLocationCC extends CommandClass {
    ccCommand: NodeNamingAndLocationCommand;
    skipEndpointInterview(): boolean;
    interview(complete?: boolean): Promise<void>;
}
interface NodeNamingAndLocationCCNameSetOptions extends CCCommandOptions {
    name: string;
}
export declare class NodeNamingAndLocationCCNameSet extends NodeNamingAndLocationCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | NodeNamingAndLocationCCNameSetOptions);
    name: string;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class NodeNamingAndLocationCCNameReport extends NodeNamingAndLocationCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | CCCommandOptions);
    readonly name: string;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class NodeNamingAndLocationCCNameGet extends NodeNamingAndLocationCC {
}
interface NodeNamingAndLocationCCLocationSetOptions extends CCCommandOptions {
    location: string;
}
export declare class NodeNamingAndLocationCCLocationSet extends NodeNamingAndLocationCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | NodeNamingAndLocationCCLocationSetOptions);
    location: string;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class NodeNamingAndLocationCCLocationReport extends NodeNamingAndLocationCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | CCCommandOptions);
    readonly location: string;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class NodeNamingAndLocationCCLocationGet extends NodeNamingAndLocationCC {
}
export {};
