/// <reference types="node" />
import type { MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import { Maybe, Timeout } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum ProtectionCommand {
    Set = 1,
    Get = 2,
    Report = 3,
    SupportedGet = 4,
    SupportedReport = 5,
    ExclusiveControlSet = 6,
    ExclusiveControlGet = 7,
    ExclusiveControlReport = 8,
    TimeoutSet = 9,
    TimeoutGet = 10,
    TimeoutReport = 11
}
export declare enum LocalProtectionState {
    Unprotected = 0,
    ProtectedBySequence = 1,
    NoOperationPossible = 2
}
export declare enum RFProtectionState {
    Unprotected = 0,
    NoControl = 1,
    NoResponse = 2
}
export declare function getExclusiveControlNodeIdValueID(endpoint: number): ValueID;
export declare function getLocalStateValueID(endpoint: number): ValueID;
export declare function getRFStateValueID(endpoint: number): ValueID;
export declare function getTimeoutValueID(endpoint: number): ValueID;
export declare function getSupportsExclusiveControlValueID(endpoint: number): ValueID;
export declare function getSupportsTimeoutValueID(endpoint: number): ValueID;
export declare class ProtectionCCAPI extends CCAPI {
    supportsCommand(cmd: ProtectionCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
    get(): Promise<Pick<ProtectionCCReport, "local" | "rf"> | undefined>;
    set(local: LocalProtectionState, rf?: RFProtectionState): Promise<void>;
    getSupported(): Promise<Pick<ProtectionCCSupportedReport, "supportsExclusiveControl" | "supportsTimeout" | "supportedLocalStates" | "supportedRFStates"> | undefined>;
    getExclusiveControl(): Promise<number | undefined>;
    setExclusiveControl(nodeId: number): Promise<void>;
    getTimeout(): Promise<Timeout | undefined>;
    setTimeout(timeout: Timeout): Promise<void>;
}
export declare class ProtectionCC extends CommandClass {
    ccCommand: ProtectionCommand;
    interview(complete?: boolean): Promise<void>;
}
interface ProtectionCCSetOptions extends CCCommandOptions {
    local: LocalProtectionState;
    rf?: RFProtectionState;
}
export declare class ProtectionCCSet extends ProtectionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ProtectionCCSetOptions);
    local: LocalProtectionState;
    rf?: RFProtectionState;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ProtectionCCReport extends ProtectionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly local: LocalProtectionState;
    readonly rf?: RFProtectionState;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ProtectionCCGet extends ProtectionCC {
}
export declare class ProtectionCCSupportedReport extends ProtectionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    readonly supportsExclusiveControl: boolean;
    readonly supportsTimeout: boolean;
    readonly supportedLocalStates: LocalProtectionState[];
    readonly supportedRFStates: RFProtectionState[];
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ProtectionCCSupportedGet extends ProtectionCC {
}
export declare class ProtectionCCExclusiveControlReport extends ProtectionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly exclusiveControlNodeId: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ProtectionCCExclusiveControlGet extends ProtectionCC {
}
interface ProtectionCCExclusiveControlSetOptions extends CCCommandOptions {
    exclusiveControlNodeId: number;
}
export declare class ProtectionCCExclusiveControlSet extends ProtectionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ProtectionCCExclusiveControlSetOptions);
    exclusiveControlNodeId: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ProtectionCCTimeoutReport extends ProtectionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly timeout: Timeout;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ProtectionCCTimeoutGet extends ProtectionCC {
}
interface ProtectionCCTimeoutSetOptions extends CCCommandOptions {
    timeout: Timeout;
}
export declare class ProtectionCCTimeoutSet extends ProtectionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ProtectionCCTimeoutSetOptions);
    timeout: Timeout;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
